/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.proxy.core.parser;

import java.beans.IntrospectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ptp.rm.proxy.core.attributes.AttributeDefinition;
import org.eclipse.ptp.rm.proxy.core.element.IElement;
import org.eclipse.ptp.rm.proxy.core.parser.IParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLReader
implements IParser {
    private static boolean DEBUG = false;

    public static void main(String[] argv) throws IntrospectionException, IllegalAccessException, InvocationTargetException, InstantiationException, FileNotFoundException {
        DEBUG = true;
    }

    private NodeList getXMLChildren(InputStream in) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(in);
        Element root = doc.getDocumentElement();
        root.normalize();
        return root.getChildNodes();
    }

    @Override
    public Set<IElement> parse(AttributeDefinition attrDef, InputStream in) {
        HashSet<IElement> elementList = null;
        NodeList xmlNodes = null;
        try {
            xmlNodes = this.getXMLChildren(in);
        }
        catch (Exception exception) {
            return new HashSet<IElement>();
        }
        try {
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        elementList = new HashSet<IElement>(xmlNodes.getLength());
        int i = 0;
        while (i < xmlNodes.getLength()) {
            Node node = xmlNodes.item(i);
            if (node.getNodeType() == 1) {
                try {
                    Map<String, String> input = this.populateInput(node, null);
                    IElement bean = this.populateElement(attrDef, input);
                    if (DEBUG) {
                        System.out.println(bean);
                        System.out.println();
                    }
                    elementList.add(bean);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        if (DEBUG) {
            System.out.println(elementList.size());
        }
        return elementList;
    }

    private IElement populateElement(AttributeDefinition attrDef, Map<String, String> input) throws IElement.UnknownValueExecption {
        org.eclipse.ptp.rm.proxy.core.element.Element element = attrDef.createElement();
        for (String attr : attrDef.getRequiredAttributes()) {
            element.setAttribute(attr, input.get(attr));
        }
        return element;
    }

    protected Map<String, String> populateInput(Node node, Map<String, String> input) throws IntrospectionException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (input == null) {
            input = new HashMap<String, String>();
        }
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() == 1) {
                if (childNode.getChildNodes().getLength() > 1) {
                    this.populateInput(childNode, input);
                } else {
                    input.put(childNode.getNodeName().toLowerCase(), childNode.getTextContent());
                }
            }
            ++i;
        }
        return input;
    }
}

