/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rmsystem;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.core.elementcontrols.IPJobControl;
import org.eclipse.ptp.core.elementcontrols.IPMachineControl;
import org.eclipse.ptp.core.elementcontrols.IPNodeControl;
import org.eclipse.ptp.core.elementcontrols.IPQueueControl;
import org.eclipse.ptp.core.elementcontrols.IPUniverseControl;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.attributes.ElementAttributeManager;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.core.elements.attributes.ResourceManagerAttributes;
import org.eclipse.ptp.core.messages.Messages;
import org.eclipse.ptp.rmsystem.AbstractResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.rtsystem.IRuntimeEventListener;
import org.eclipse.ptp.rtsystem.IRuntimeSystem;
import org.eclipse.ptp.rtsystem.events.IRuntimeAttributeDefinitionEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeConnectedStateEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeErrorStateEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeJobChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeMachineChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeMessageEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeNewJobEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeNewMachineEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeNewNodeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeNewProcessEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeNewQueueEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeNodeChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeProcessChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeQueueChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRMChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRemoveAllEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRemoveJobEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRemoveMachineEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRemoveNodeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRemoveProcessEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRemoveQueueEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRunningStateEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeShutdownStateEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeStartupErrorEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeSubmitJobErrorEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeTerminateJobErrorEvent;
import org.eclipse.ptp.utils.core.RangeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRuntimeResourceManager
extends AbstractResourceManager
implements IRuntimeEventListener {
    private Map<String, JobSubmission> jobSubmissions = Collections.synchronizedMap(new HashMap());
    private IRuntimeSystem runtimeSystem;

    public AbstractRuntimeResourceManager(String id, IPUniverseControl universe, IResourceManagerConfiguration config) {
        super(id, universe, config);
    }

    @Override
    public void handleEvent(IRuntimeAttributeDefinitionEvent e) {
        IAttributeDefinition<?, ?, ?>[] iAttributeDefinitionArray = e.getDefinitions();
        int n = iAttributeDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAttributeDefinition<?, ?, ?> attr = iAttributeDefinitionArray[n2];
            this.getAttributeDefinitionManager().setAttributeDefinition(attr);
            ++n2;
        }
    }

    @Override
    public void handleEvent(IRuntimeConnectedStateEvent e) {
    }

    @Override
    public void handleEvent(IRuntimeErrorStateEvent e) {
        for (JobSubmission sub : this.jobSubmissions.values()) {
            sub.setError(Messages.AbstractRuntimeResourceManager_6);
        }
        this.jobSubmissions.clear();
        this.setState(ResourceManagerAttributes.State.ERROR);
        this.fireError(Messages.AbstractRuntimeResourceManager_6);
    }

    @Override
    public void handleEvent(IRuntimeJobChangeEvent e) {
        ElementAttributeManager eMgr = e.getElementAttributeManager();
        HashMap<IPQueueControl, ArrayList<IPJobControl>> map = new HashMap<IPQueueControl, ArrayList<IPJobControl>>();
        for (Map.Entry<RangeSet, AttributeManager> mgrEntry : eMgr.getEntrySet()) {
            AttributeManager attrs = mgrEntry.getValue();
            RangeSet jobIds = mgrEntry.getKey();
            for (String elementId : jobIds) {
                IPJobControl job = this.getJobControl(elementId);
                if (job != null) {
                    IPQueueControl queue = job.getQueueControl();
                    ArrayList<IPJobControl> changedJobs = (ArrayList<IPJobControl>)map.get(queue);
                    if (changedJobs == null) {
                        changedJobs = new ArrayList<IPJobControl>();
                        map.put(queue, changedJobs);
                    }
                    changedJobs.add(job);
                    continue;
                }
                PTPCorePlugin.log(String.valueOf(Messages.AbstractRuntimeResourceManager_7) + elementId);
            }
            for (Map.Entry entry : map.entrySet()) {
                this.doUpdateJobs((IPQueueControl)entry.getKey(), (Collection)entry.getValue(), attrs);
            }
            map.clear();
        }
    }

    @Override
    public void handleEvent(IRuntimeMachineChangeEvent e) {
        ElementAttributeManager eMgr = e.getElementAttributeManager();
        ArrayList<IPMachineControl> machines = new ArrayList<IPMachineControl>();
        for (Map.Entry<RangeSet, AttributeManager> entry : eMgr.getEntrySet()) {
            AttributeManager attrs = entry.getValue();
            RangeSet machineIds = entry.getKey();
            for (String elementId : machineIds) {
                IPMachineControl machine = this.getMachineControl(elementId);
                if (machine != null) {
                    machines.add(machine);
                    continue;
                }
                System.out.println(String.valueOf(Messages.AbstractRuntimeResourceManager_8) + elementId);
            }
            this.doUpdateMachines(machines, attrs);
            machines.clear();
        }
    }

    @Override
    public void handleEvent(IRuntimeMessageEvent e) {
    }

    @Override
    public void handleEvent(IRuntimeNewJobEvent e) {
        IPQueueControl queue = this.getQueueControl(e.getParentId());
        if (queue != null) {
            ElementAttributeManager mgr = e.getElementAttributeManager();
            for (Map.Entry<RangeSet, AttributeManager> entry : mgr.getEntrySet()) {
                AttributeManager jobAttrs = entry.getValue();
                RangeSet jobIds = entry.getKey();
                ArrayList<IPJobControl> newJobs = new ArrayList<IPJobControl>(jobIds.size());
                for (String elementId : jobIds) {
                    JobSubmission sub;
                    IPJobControl job = this.getJobControl(elementId);
                    if (job != null) continue;
                    job = this.doCreateJob(queue, elementId, jobAttrs);
                    newJobs.add(job);
                    StringAttribute jobSubAttr = (StringAttribute)jobAttrs.getAttribute(JobAttributes.getSubIdAttributeDefinition());
                    if (jobSubAttr == null || (sub = this.jobSubmissions.remove(jobSubAttr.getValue())) == null) continue;
                    sub.setJob(job);
                    job.setLaunchConfiguration(sub.getLaunchConfiguration());
                    sub.setState(JobSubState.COMPLETED);
                }
                this.addJobs(queue, newJobs);
            }
        } else {
            PTPCorePlugin.log(String.valueOf(Messages.AbstractRuntimeResourceManager_0) + e.getParentId());
        }
    }

    @Override
    public void handleEvent(IRuntimeNewMachineEvent e) {
        ElementAttributeManager mgr = e.getElementAttributeManager();
        for (Map.Entry<RangeSet, AttributeManager> entry : mgr.getEntrySet()) {
            AttributeManager attrs = entry.getValue();
            RangeSet machineIds = entry.getKey();
            ArrayList<IPMachineControl> newMachines = new ArrayList<IPMachineControl>(machineIds.size());
            for (String elementId : machineIds) {
                IPMachineControl machine = this.getMachineControl(elementId);
                if (machine != null) continue;
                machine = this.doCreateMachine(elementId, attrs);
                newMachines.add(machine);
            }
            this.addMachines(newMachines);
        }
    }

    @Override
    public void handleEvent(IRuntimeNewNodeEvent e) {
        IPMachineControl machine = this.getMachineControl(e.getParentId());
        if (machine != null) {
            ElementAttributeManager mgr = e.getElementAttributeManager();
            for (Map.Entry<RangeSet, AttributeManager> entry : mgr.getEntrySet()) {
                AttributeManager attrs = entry.getValue();
                RangeSet nodeIds = entry.getKey();
                ArrayList<IPNodeControl> newNodes = new ArrayList<IPNodeControl>(nodeIds.size());
                for (String elementId : nodeIds) {
                    IPNodeControl node = this.getNodeControl(elementId);
                    if (node != null) continue;
                    node = this.doCreateNode(machine, elementId, attrs);
                    newNodes.add(node);
                }
                this.addNodes(machine, newNodes);
            }
        } else {
            PTPCorePlugin.log(String.valueOf(Messages.AbstractRuntimeResourceManager_1) + e.getParentId());
        }
    }

    @Override
    public void handleEvent(IRuntimeNewProcessEvent e) {
        String jobId = e.getParentId();
        IPJobControl job = this.getJobControl(jobId);
        if (job != null) {
            ElementAttributeManager mgr = e.getElementAttributeManager();
            for (Map.Entry<RangeSet, AttributeManager> entry : mgr.getEntrySet()) {
                AttributeManager attrs = entry.getValue();
                RangeSet processJobRanks = entry.getKey();
                BitSet newProcessJobRanks = this.getProcessJobRanks(processJobRanks);
                this.addProcessesByJobRanks(job, newProcessJobRanks, attrs);
            }
        } else {
            PTPCorePlugin.log(String.valueOf(Messages.AbstractRuntimeResourceManager_2) + e.getParentId());
        }
    }

    @Override
    public void handleEvent(IRuntimeNewQueueEvent e) {
        ElementAttributeManager mgr = e.getElementAttributeManager();
        for (Map.Entry<RangeSet, AttributeManager> entry : mgr.getEntrySet()) {
            AttributeManager attrs = entry.getValue();
            RangeSet queueIds = entry.getKey();
            ArrayList<IPQueueControl> newQueues = new ArrayList<IPQueueControl>(queueIds.size());
            for (String elementId : queueIds) {
                IPQueueControl queue = this.getQueueControl(elementId);
                if (queue != null) continue;
                queue = this.doCreateQueue(elementId, attrs);
                newQueues.add(queue);
            }
            this.addQueues(newQueues);
        }
    }

    @Override
    public void handleEvent(IRuntimeNodeChangeEvent e) {
        ElementAttributeManager eMgr = e.getElementAttributeManager();
        HashMap<IPMachineControl, ArrayList<IPNodeControl>> map = new HashMap<IPMachineControl, ArrayList<IPNodeControl>>();
        for (Map.Entry<RangeSet, AttributeManager> mgrEntry : eMgr.getEntrySet()) {
            AttributeManager attrs = mgrEntry.getValue();
            RangeSet nodeIds = mgrEntry.getKey();
            for (String elementId : nodeIds) {
                IPNodeControl node = this.getNodeControl(elementId);
                if (node != null) {
                    IPMachineControl machine = node.getMachineControl();
                    ArrayList<IPNodeControl> changedNodes = (ArrayList<IPNodeControl>)map.get(machine);
                    if (changedNodes == null) {
                        changedNodes = new ArrayList<IPNodeControl>();
                        map.put(machine, changedNodes);
                    }
                    changedNodes.add(node);
                    continue;
                }
                PTPCorePlugin.log(String.valueOf(Messages.AbstractRuntimeResourceManager_9) + elementId);
            }
            for (Map.Entry entry : map.entrySet()) {
                this.doUpdateNodes((IPMachineControl)entry.getKey(), (Collection)entry.getValue(), attrs);
            }
            map.clear();
        }
    }

    @Override
    public void handleEvent(IRuntimeProcessChangeEvent e) {
        ElementAttributeManager eMgr = e.getElementAttributeManager();
        String jobId = e.getJobId();
        IPJobControl job = this.getJobControl(jobId);
        for (Map.Entry<RangeSet, AttributeManager> mgrEntry : eMgr.getEntrySet()) {
            AttributeManager attrs = mgrEntry.getValue();
            RangeSet processJobRanks = mgrEntry.getKey();
            BitSet changedProcessesJobRanks = this.getProcessJobRanks(processJobRanks);
            this.doUpdateProcesses(job, changedProcessesJobRanks, attrs);
        }
    }

    @Override
    public void handleEvent(IRuntimeQueueChangeEvent e) {
        ElementAttributeManager eMgr = e.getElementAttributeManager();
        ArrayList<IPQueueControl> queues = new ArrayList<IPQueueControl>();
        for (Map.Entry<RangeSet, AttributeManager> entry : eMgr.getEntrySet()) {
            AttributeManager attrs = entry.getValue();
            RangeSet queueIds = entry.getKey();
            for (String elementId : queueIds) {
                IPQueueControl queue = this.getQueueControl(elementId);
                if (queue != null) {
                    queues.add(queue);
                    continue;
                }
                PTPCorePlugin.log(String.valueOf(Messages.AbstractRuntimeResourceManager_3) + elementId);
            }
            this.doUpdateQueues(queues, attrs);
            queues.clear();
        }
    }

    @Override
    public void handleEvent(IRuntimeRemoveAllEvent e) {
        this.cleanUp();
    }

    @Override
    public void handleEvent(IRuntimeRemoveJobEvent e) {
        Object job;
        HashMap<IPQueueControl, ArrayList<Object>> map = new HashMap<IPQueueControl, ArrayList<Object>>();
        HashSet<IPJobControl> removedJobs = new HashSet<IPJobControl>();
        for (String elementId : e.getElementIds()) {
            job = this.getJobControl(elementId);
            if (job == null) continue;
            removedJobs.add((IPJobControl)job);
            IPQueueControl queue = job.getQueueControl();
            ArrayList<Object> jobs = (ArrayList<Object>)map.get(queue);
            if (jobs == null) {
                jobs = new ArrayList<Object>();
                map.put(queue, jobs);
            }
            jobs.add(job);
        }
        for (Map.Entry entry : map.entrySet()) {
            job = (List)entry.getValue();
            this.removeJobs((IPQueueControl)entry.getKey(), (Collection<IPJobControl>)job);
        }
    }

    @Override
    public void handleEvent(IRuntimeRemoveMachineEvent e) {
        HashMap<IResourceManager, ArrayList<IPMachineControl>> map = new HashMap<IResourceManager, ArrayList<IPMachineControl>>();
        for (String elementId : e.getElementIds()) {
            IPMachineControl machine = this.getMachineControl(elementId);
            if (machine == null) continue;
            IResourceManager rm = machine.getResourceManager();
            ArrayList<IPMachineControl> machines = (ArrayList<IPMachineControl>)map.get(rm);
            if (machines == null) {
                machines = new ArrayList<IPMachineControl>();
                map.put(rm, machines);
            }
            machines.add(machine);
        }
        for (Map.Entry entry : map.entrySet()) {
            this.removeMachines((IResourceManager)entry.getKey(), (Collection)entry.getValue());
        }
    }

    @Override
    public void handleEvent(IRuntimeRemoveNodeEvent e) {
        HashMap<IPMachineControl, ArrayList<IPNodeControl>> map = new HashMap<IPMachineControl, ArrayList<IPNodeControl>>();
        for (String elementId : e.getElementIds()) {
            IPNodeControl node = this.getNodeControl(elementId);
            if (node == null) continue;
            IPMachineControl machine = node.getMachineControl();
            ArrayList<IPNodeControl> nodes = (ArrayList<IPNodeControl>)map.get(machine);
            if (nodes == null) {
                nodes = new ArrayList<IPNodeControl>();
                map.put(machine, nodes);
            }
            nodes.add(node);
        }
        for (Map.Entry entry : map.entrySet()) {
            this.removeNodes((IPMachineControl)entry.getKey(), (Collection)entry.getValue());
        }
    }

    @Override
    public void handleEvent(IRuntimeRemoveProcessEvent e) {
        RangeSet jobRanks = e.getProcessJobRanks();
        BitSet removedProcessJobRanks = this.getProcessJobRanks(jobRanks);
        IPJobControl job = this.getJobControl(e.getJobId());
        job.removeProcessesByJobRanks(removedProcessJobRanks);
    }

    @Override
    public void handleEvent(IRuntimeRemoveQueueEvent e) {
        HashMap<IResourceManager, ArrayList<IPQueueControl>> map = new HashMap<IResourceManager, ArrayList<IPQueueControl>>();
        for (String elementId : e.getElementIds()) {
            IPQueueControl queue = this.getQueueControl(elementId);
            if (queue == null) continue;
            IResourceManager rm = queue.getResourceManager();
            ArrayList<IPQueueControl> queues = (ArrayList<IPQueueControl>)map.get(rm);
            if (queues == null) {
                queues = new ArrayList<IPQueueControl>();
                map.put(rm, queues);
            }
            queues.add(queue);
        }
        for (Map.Entry entry : map.entrySet()) {
            this.removeQueues((IResourceManager)entry.getKey(), (Collection)entry.getValue());
        }
    }

    @Override
    public void handleEvent(IRuntimeRMChangeEvent e) {
        ElementAttributeManager eMgr = e.getElementAttributeManager();
        for (Map.Entry<RangeSet, AttributeManager> mgrEntry : eMgr.getEntrySet()) {
            AttributeManager attrs = mgrEntry.getValue();
            RangeSet rmIds = mgrEntry.getKey();
            for (String elementId : rmIds) {
                if (!this.getID().equals(elementId)) continue;
                this.doUpdateRM(attrs);
            }
        }
    }

    @Override
    public void handleEvent(IRuntimeRunningStateEvent e) {
        ResourceManagerAttributes.State state = ResourceManagerAttributes.State.STARTED;
        try {
            this.runtimeSystem.startEvents();
        }
        catch (CoreException ex) {
            state = ResourceManagerAttributes.State.ERROR;
            this.fireError(ex.getMessage());
        }
        this.setState(state);
    }

    @Override
    public void handleEvent(IRuntimeShutdownStateEvent e) {
        this.setState(ResourceManagerAttributes.State.STOPPED);
        this.cleanUp();
    }

    @Override
    public void handleEvent(IRuntimeStartupErrorEvent e) {
        this.setState(ResourceManagerAttributes.State.ERROR);
        this.fireError(e.getErrorMessage());
    }

    @Override
    public void handleEvent(IRuntimeSubmitJobErrorEvent e) {
        JobSubmission sub;
        if (e.getJobSubID() != null && (sub = this.jobSubmissions.remove(e.getJobSubID())) != null) {
            sub.setError(e.getErrorMessage());
        }
        this.fireSubmitJobError(e.getJobSubID(), e.getErrorMessage());
    }

    @Override
    public void handleEvent(IRuntimeTerminateJobErrorEvent e) {
        IPJobControl job = this.getJobControl(e.getJobID());
        String name = e.getJobID();
        if (job != null) {
            name = job.getName();
        }
        this.fireError(NLS.bind((String)Messages.AbstractRuntimeResourceManager_4, (Object[])new Object[]{name, e.getErrorMessage()}));
    }

    protected abstract void doAfterCloseConnection();

    protected abstract void doAfterOpenConnection();

    protected abstract void doBeforeCloseConnection();

    protected abstract void doBeforeOpenConnection();

    @Override
    protected void doCleanUp() {
        for (JobSubmission sub : this.jobSubmissions.values()) {
            sub.setState(JobSubState.CANCELED);
        }
        this.jobSubmissions.clear();
    }

    protected abstract IPJobControl doCreateJob(IPQueueControl var1, String var2, AttributeManager var3);

    protected abstract IPMachineControl doCreateMachine(String var1, AttributeManager var2);

    protected abstract IPNodeControl doCreateNode(IPMachineControl var1, String var2, AttributeManager var3);

    protected abstract IPQueueControl doCreateQueue(String var1, AttributeManager var2);

    protected abstract IRuntimeSystem doCreateRuntimeSystem() throws CoreException;

    @Override
    protected void doDisableEvents() {
    }

    @Override
    protected void doDispose() {
    }

    @Override
    protected void doEnableEvents() {
    }

    @Override
    protected List<IPJobControl> doRemoveTerminatedJobs(IPQueueControl queue) {
        ArrayList<IPJobControl> terminatedJobs = new ArrayList<IPJobControl>();
        if (queue != null) {
            for (IPJobControl job : queue.getJobControls()) {
                if (job.getState() != JobAttributes.State.COMPLETED) continue;
                terminatedJobs.add(job);
            }
            queue.removeJobs(terminatedJobs);
        }
        return terminatedJobs;
    }

    @Override
    protected void doShutdown() throws CoreException {
        this.doBeforeCloseConnection();
        this.runtimeSystem.shutdown();
        this.doAfterCloseConnection();
    }

    @Override
    protected void doStartup(IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        monitor.subTask(Messages.AbstractRuntimeResourceManager_11);
        this.runtimeSystem = this.doCreateRuntimeSystem();
        if (monitor.isCanceled()) {
            return;
        }
        monitor.worked(10);
        monitor.subTask(Messages.AbstractRuntimeResourceManager_5);
        this.runtimeSystem.addRuntimeEventListener(this);
        try {
            this.runtimeSystem.startup((IProgressMonitor)subMon.newChild(90));
        }
        catch (CoreException e) {
            this.runtimeSystem.removeRuntimeEventListener(this);
            throw e;
        }
    }

    @Override
    protected IPJob doSubmitJob(String subId, ILaunchConfiguration configuration, AttributeManager attrMgr, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IPJob job = null;
        try {
            JobSubmission sub = new JobSubmission(subId);
            sub.setLaunchConfiguration(configuration);
            this.jobSubmissions.put(subId, sub);
            this.runtimeSystem.submitJob(subId, attrMgr);
            if (subId != null) {
                IPJob iPJob = job;
                return iPJob;
            }
            JobSubState state = sub.waitFor(monitor);
            switch (state) {
                case CANCELED: 
                case SUBMITTED: {
                    break;
                }
                case COMPLETED: {
                    job = sub.getJob();
                    break;
                }
                case ERROR: {
                    throw new CoreException((IStatus)new Status(4, PTPCorePlugin.getUniqueIdentifier(), 4, sub.getErrorReason(), null));
                }
            }
        }
        finally {
            monitor.done();
        }
        return job;
    }

    @Override
    protected void doTerminateJob(IPJob job) throws CoreException {
        this.runtimeSystem.terminateJob(job);
    }

    protected abstract boolean doUpdateJobs(IPQueueControl var1, Collection<IPJobControl> var2, AttributeManager var3);

    protected abstract boolean doUpdateMachines(Collection<IPMachineControl> var1, AttributeManager var2);

    protected abstract boolean doUpdateNodes(IPMachineControl var1, Collection<IPNodeControl> var2, AttributeManager var3);

    protected abstract boolean doUpdateProcesses(IPJobControl var1, BitSet var2, AttributeManager var3);

    protected abstract boolean doUpdateQueues(Collection<IPQueueControl> var1, AttributeManager var2);

    protected abstract boolean doUpdateRM(AttributeManager var1);

    protected Integer getProcessJobRank(String sJobRank) {
        Integer procId;
        try {
            procId = Integer.valueOf(sJobRank);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return procId;
    }

    protected BitSet getProcessJobRanks(RangeSet processJobRanks) {
        BitSet bitSet = new BitSet(processJobRanks.size());
        for (String sRank : processJobRanks) {
            Integer rank = this.getProcessJobRank(sRank);
            if (rank != null) {
                bitSet.set(rank);
                continue;
            }
            PTPCorePlugin.log(String.valueOf(Messages.AbstractRuntimeResourceManager_12) + sRank + Messages.AbstractRuntimeResourceManager_13);
        }
        return bitSet;
    }

    protected IRuntimeSystem getRuntimeSystem() {
        return this.runtimeSystem;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JobSubState {
        CANCELED,
        COMPLETED,
        ERROR,
        SUBMITTED;

    }

    private class JobSubmission {
        private ILaunchConfiguration configuration;
        private String id;
        private IPJob job = null;
        private String reason;
        private JobSubState state = JobSubState.SUBMITTED;
        private final ReentrantLock subLock = new ReentrantLock();
        private final Condition subCondition = this.subLock.newCondition();

        public JobSubmission(int count) {
            this.id = "JOB_" + Long.toString(System.currentTimeMillis()) + Integer.toString(count);
        }

        public JobSubmission(String id) {
            this.id = id;
        }

        public String getErrorReason() {
            return this.reason;
        }

        public String getId() {
            return this.id;
        }

        public IPJob getJob() {
            return this.job;
        }

        public ILaunchConfiguration getLaunchConfiguration() {
            return this.configuration;
        }

        public void setError(String reason) {
            this.reason = reason;
            this.setState(JobSubState.ERROR);
        }

        public void setJob(IPJob job) {
            this.job = job;
        }

        public void setLaunchConfiguration(ILaunchConfiguration configuration) {
            this.configuration = configuration;
        }

        public void setState(JobSubState state) {
            this.subLock.lock();
            try {
                this.state = state;
                this.subCondition.signalAll();
            }
            finally {
                this.subLock.unlock();
            }
        }

        /*
         * Exception decompiling
         */
        public JobSubState waitFor(IProgressMonitor monitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

