/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.lrparser;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.gnu.c.GCCLanguage;
import org.eclipse.cdt.core.dom.lrparser.IParser;
import org.eclipse.cdt.core.dom.parser.CLanguageKeywords;
import org.eclipse.cdt.core.dom.parser.IScannerExtensionConfiguration;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.AbstractLanguage;
import org.eclipse.cdt.core.model.ICLanguageKeywords;
import org.eclipse.cdt.core.model.IContributedModelBuilder;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IncludeFileContentProvider;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.util.ASTPrinter;
import org.eclipse.cdt.core.parser.util.DebugUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.parser.scanner.CPreprocessor;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMLinkageFactory;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCLinkageFactory;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPLinkageFactory;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseExtensibleLanguage
extends AbstractLanguage {
    private static final boolean DEBUG_PRINT_GCC_AST = false;
    private static final boolean DEBUG_PRINT_AST = false;
    private ICLanguageKeywords cLanguageKeywords = new CLanguageKeywords(this.getParserLanguage(), this.getScannerExtensionConfiguration());

    protected abstract IParser<IASTTranslationUnit> getParser(IScanner var1, IIndex var2, Map<String, String> var3);

    protected abstract ParserLanguage getParserLanguage();

    protected abstract IScannerExtensionConfiguration getScannerExtensionConfiguration();

    @Deprecated
    public IASTTranslationUnit getASTTranslationUnit(CodeReader reader, IScannerInfo scanInfo, ICodeReaderFactory codeReaderFactory, IIndex index, int options, IParserLogService log) throws CoreException {
        return this.getASTTranslationUnit(FileContent.adapt((CodeReader)reader), scanInfo, IncludeFileContentProvider.adapt((ICodeReaderFactory)codeReaderFactory), index, options, log);
    }

    public IASTTranslationUnit getASTTranslationUnit(FileContent reader, IScannerInfo scanInfo, IncludeFileContentProvider fileCreator, IIndex index, int options, IParserLogService log) throws CoreException {
        IScannerExtensionConfiguration config = this.getScannerExtensionConfiguration();
        ParserLanguage pl = this.getParserLanguage();
        CPreprocessor preprocessor = new CPreprocessor(reader, scanInfo, pl, log, config, fileCreator);
        preprocessor.setComputeImageLocations((options & 4) == 0);
        HashMap<String, String> parserProperties = new HashMap<String, String>();
        parserProperties.put("org.eclipse.cdt.core.dom.lrparser.translationUnitPath", reader.getFileLocation());
        if ((options & 1) != 0) {
            parserProperties.put("org.eclipse.cdt.core.dom.lrparser.skipFunctionBodies", "true");
        }
        if ((options & 0x10) != 0) {
            parserProperties.put("org.eclipse.cdt.core.dom.lrparser.skipTrivialExpressionsInAggregateInitializers", "true");
        }
        IParser<IASTTranslationUnit> parser = this.getParser((IScanner)preprocessor, index, parserProperties);
        IASTTranslationUnit tu = parser.parse();
        tu.setIsHeaderUnit((options & 8) == 0);
        return tu;
    }

    @Deprecated
    public IASTTranslationUnit getASTTranslationUnit(CodeReader reader, IScannerInfo scanInfo, ICodeReaderFactory fileCreator, IIndex index, IParserLogService log) throws CoreException {
        return this.getASTTranslationUnit(reader, scanInfo, fileCreator, index, 0, log);
    }

    @Deprecated
    public IASTCompletionNode getCompletionNode(CodeReader reader, IScannerInfo scanInfo, ICodeReaderFactory fileCreator, IIndex index, IParserLogService log, int offset) throws CoreException {
        return this.getCompletionNode(FileContent.adapt((CodeReader)reader), scanInfo, IncludeFileContentProvider.adapt((ICodeReaderFactory)fileCreator), index, log, offset);
    }

    public IASTCompletionNode getCompletionNode(FileContent reader, IScannerInfo scanInfo, IncludeFileContentProvider fileCreator, IIndex index, IParserLogService log, int offset) throws CoreException {
        IScannerExtensionConfiguration config = this.getScannerExtensionConfiguration();
        ParserLanguage pl = this.getParserLanguage();
        CPreprocessor preprocessor = new CPreprocessor(reader, scanInfo, pl, log, config, fileCreator);
        preprocessor.setContentAssistMode(offset);
        HashMap<String, String> parserProperties = new HashMap<String, String>();
        parserProperties.put("org.eclipse.cdt.core.dom.lrparser.translationUnitPath", reader.getFileLocation());
        parserProperties.put("org.eclipse.cdt.core.dom.lrparser.skipFunctionBodies", "true");
        parserProperties.put("org.eclipse.cdt.core.dom.lrparser.skipTrivialExpressionsInAggregateInitializers", "true");
        IParser<IASTTranslationUnit> parser = this.getParser((IScanner)preprocessor, index, parserProperties);
        parser.parse();
        IASTCompletionNode completionNode = parser.getCompletionNode();
        return completionNode;
    }

    private static void printCompletionNode(IASTCompletionNode cn) {
        if (cn == null) {
            System.out.println("Completion node is null");
            return;
        }
        ASTPrinter.print((IASTNode)cn.getTranslationUnit());
        IASTName[] iASTNameArray = cn.getNames();
        int n = iASTNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTName name = iASTNameArray[n2];
            ASTNode context = (ASTNode)name.getCompletionContext();
            System.out.printf("Name: %s, Context: %s, At: %d", name, DebugUtil.safeClassName((Object)context), context == null ? null : Integer.valueOf(context.getOffset()));
            if (name.getTranslationUnit() == null) {
                System.out.print(", not hooked up");
            }
            System.out.println();
            ++n2;
        }
        System.out.println();
    }

    @Deprecated
    public IASTName[] getSelectedNames(IASTTranslationUnit ast, int start, int length) {
        return GCCLanguage.getDefault().getSelectedNames(ast, start, length);
    }

    public Object getAdapter(Class adapter) {
        if (ICLanguageKeywords.class.equals((Object)adapter)) {
            return this.cLanguageKeywords;
        }
        if (IPDOMLinkageFactory.class.equals((Object)adapter)) {
            if (this.getParserLanguage().isCPP()) {
                return new PDOMCPPLinkageFactory();
            }
            return new PDOMCLinkageFactory();
        }
        return super.getAdapter(adapter);
    }

    public IContributedModelBuilder createModelBuilder(ITranslationUnit tu) {
        return null;
    }
}

