/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.core.runtime.PlatformObject;

public class CPPTypedef
extends PlatformObject
implements ITypedef,
ITypeContainer,
ICPPInternalBinding {
    private IASTName[] declarations = null;
    private IType type = null;

    public CPPTypedef(IASTName name) {
        if (name != null && name.getParent() instanceof ICPPASTQualifiedName) {
            name = (IASTName)name.getParent();
        }
        this.declarations = new IASTName[]{name};
        if (name != null) {
            name.setBinding(this);
        }
    }

    public IASTNode[] getDeclarations() {
        return this.declarations;
    }

    public IASTNode getDefinition() {
        return this.declarations[0];
    }

    public boolean isSameType(IType o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ITypedef) {
            IType t = this.getType();
            if (t != null) {
                return t.isSameType(((ITypedef)o).getType());
            }
            return false;
        }
        IType t = this.getType();
        if (t != null) {
            return t.isSameType(o);
        }
        return false;
    }

    public IType getType() {
        if (this.type == null) {
            this.type = CPPVisitor.createType((IASTDeclarator)this.declarations[0].getParent());
        }
        return this.type;
    }

    public void setType(IType t) {
        this.type = t;
    }

    public String getName() {
        return new String(this.getNameCharArray());
    }

    public char[] getNameCharArray() {
        return this.declarations[0].getSimpleID();
    }

    public IScope getScope() {
        return CPPVisitor.getContainingScope(this.declarations[0].getParent());
    }

    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    public boolean isGloballyQualified() throws DOMException {
        IScope scope = this.getScope();
        while (scope != null) {
            if (scope instanceof ICPPBlockScope) {
                return false;
            }
            scope = scope.getParent();
        }
        return true;
    }

    public void addDefinition(IASTNode node) {
        this.addDeclaration(node);
    }

    public void addDeclaration(IASTNode node) {
        IASTName name;
        if (node instanceof IASTName) {
            name = node.getParent() instanceof ICPPASTQualifiedName ? (IASTName)node.getParent() : (IASTName)node;
        } else {
            return;
        }
        this.declarations = this.declarations == null ? new IASTName[]{name} : (this.declarations.length > 0 && ((ASTNode)node).getOffset() < ((ASTNode)((Object)this.declarations[0])).getOffset() ? (IASTName[])ArrayUtil.prepend(IASTName.class, this.declarations, name) : (IASTName[])ArrayUtil.append(IASTName.class, this.declarations, name));
    }

    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    public String toString() {
        return this.getName();
    }

    public IBinding getOwner() throws DOMException {
        if (this.declarations != null && this.declarations.length > 0) {
            return CPPVisitor.findDeclarationOwner(this.declarations[0], true);
        }
        return null;
    }
}

