/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.model;

import java.io.Serializable;
import java.net.URI;
import org.eclipse.cdt.utils.FileSystemUtilityManager;
import org.eclipse.core.resources.IProject;

public class Scope
implements Serializable {
    public static final String WORKSPACE_ROOT_SCOPE_NAME = "__WORKSPACE_ROOT_SCOPE__";
    public static final Scope WORKSPACE_ROOT_SCOPE = new Scope("__WORKSPACE_ROOT_SCOPE__", null, null, null, null);
    private static final long serialVersionUID = 1L;
    private String fName;
    private String fScheme;
    private String fMappedPath;
    private String fHost;
    private String fRootPath;

    public Scope(String name, String scheme, String host, String rootPath, String mappedPath) {
        this.fName = name;
        this.fScheme = scheme;
        this.fHost = host;
        this.fRootPath = rootPath;
        this.fMappedPath = mappedPath;
    }

    public Scope(IProject project) {
        FileSystemUtilityManager fsUtilityManager = FileSystemUtilityManager.getDefault();
        URI locationURI = project.getLocationURI();
        this.fName = project.getName();
        this.fScheme = locationURI.getScheme();
        this.fMappedPath = fsUtilityManager.getMappedPath(locationURI);
        this.fRootPath = fsUtilityManager.getPathFromURI(locationURI);
        URI managedURI = fsUtilityManager.getManagedURI(locationURI);
        this.fHost = managedURI == null ? locationURI.getHost() : managedURI.getHost();
    }

    public String getName() {
        return this.fName;
    }

    public String getScheme() {
        return this.fScheme;
    }

    public String getMappedPath() {
        return this.fMappedPath;
    }

    public String getHost() {
        return this.fHost;
    }

    public String getRootPath() {
        return this.fRootPath;
    }
}

