/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTImplicitNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTImplicitName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPArithmeticConversion;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class CPPASTBinaryExpression
extends ASTNode
implements ICPPASTBinaryExpression,
IASTAmbiguityParent {
    private int op;
    private IASTExpression operand1;
    private IASTInitializerClause operand2;
    private IType type;
    private ICPPFunction overload = UNINITIALIZED_FUNCTION;
    private IASTImplicitName[] implicitNames = null;

    public CPPASTBinaryExpression() {
    }

    public CPPASTBinaryExpression(int op, IASTExpression operand1, IASTInitializerClause operand2) {
        this.op = op;
        this.setOperand1(operand1);
        this.setInitOperand2(operand2);
    }

    public CPPASTBinaryExpression copy() {
        CPPASTBinaryExpression copy = new CPPASTBinaryExpression();
        copy.op = this.op;
        copy.setOperand1(this.operand1 == null ? null : this.operand1.copy());
        copy.setInitOperand2(this.operand2 == null ? null : this.operand2.copy());
        copy.setOffsetAndLength(this);
        return copy;
    }

    public int getOperator() {
        return this.op;
    }

    public IASTExpression getOperand1() {
        return this.operand1;
    }

    public IASTInitializerClause getInitOperand2() {
        return this.operand2;
    }

    public IASTExpression getOperand2() {
        if (this.operand2 instanceof IASTExpression) {
            return (IASTExpression)this.operand2;
        }
        return null;
    }

    public void setOperator(int op) {
        this.assertNotFrozen();
        this.op = op;
    }

    public void setOperand1(IASTExpression expression) {
        this.assertNotFrozen();
        this.operand1 = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(OPERAND_ONE);
        }
    }

    public void setInitOperand2(IASTInitializerClause operand) {
        this.assertNotFrozen();
        this.operand2 = operand;
        if (operand != null) {
            operand.setParent(this);
            operand.setPropertyInParent(OPERAND_TWO);
        }
    }

    public void setOperand2(IASTExpression expression) {
        this.setInitOperand2(expression);
    }

    public IASTImplicitName[] getImplicitNames() {
        if (this.implicitNames == null) {
            ICPPFunction overload = this.getOverload();
            if (overload == null) {
                this.implicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
            } else {
                CPPASTImplicitName operatorName = new CPPASTImplicitName(overload.getNameCharArray(), (IASTNode)this);
                operatorName.setBinding(overload);
                operatorName.setOperator(true);
                operatorName.computeOperatorOffsets(this.operand1, true);
                this.implicitNames = new IASTImplicitName[]{operatorName};
            }
        }
        return this.implicitNames;
    }

    public boolean accept(ASTVisitor action) {
        if (this.operand1 instanceof IASTBinaryExpression || this.operand2 instanceof IASTBinaryExpression) {
            return CPPASTBinaryExpression.acceptWithoutRecursion(this, action);
        }
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.operand1 != null && !this.operand1.accept(action)) {
            return false;
        }
        if (action.shouldVisitImplicitNames) {
            IASTImplicitName[] iASTImplicitNameArray = this.getImplicitNames();
            int n = iASTImplicitNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTImplicitName name = iASTImplicitNameArray[n2];
                if (!name.accept(action)) {
                    return false;
                }
                ++n2;
            }
        }
        if (this.operand2 != null && !this.operand2.accept(action)) {
            return false;
        }
        return !action.shouldVisitExpressions || action.leave(this) != 2;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean acceptWithoutRecursion(IASTBinaryExpression bexpr, ASTVisitor action) {
        stack = new N(bexpr);
        block4: while (stack != null) {
            block13: {
                expr = stack.fExpression;
                if (stack.fState != 0) break block13;
                if (!action.shouldVisitExpressions) ** GOTO lbl-1000
                switch (action.visit(expr)) {
                    case 2: {
                        return false;
                    }
                    case 1: {
                        stack = stack.fNext;
                        continue block4;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        stack.fState = 1;
                        op1 = expr.getOperand1();
                        if (op1 instanceof IASTBinaryExpression) {
                            n = new N((IASTBinaryExpression)op1);
                            n.fNext = stack;
                            stack = n;
                            continue block4;
                        }
                        if (op1 == null || op1.accept(action)) break;
                        return false;
                    }
                }
            }
            if (stack.fState == 1) {
                if (action.shouldVisitImplicitNames) {
                    var7_9 = ((IASTImplicitNameOwner)expr).getImplicitNames();
                    var6_8 = var7_9.length;
                    n = 0;
                    while (n < var6_8) {
                        name = var7_9[n];
                        if (!name.accept(action)) {
                            return false;
                        }
                        ++n;
                    }
                }
                stack.fState = 2;
                op2 = expr.getOperand2();
                if (op2 instanceof IASTBinaryExpression) {
                    n = new N((IASTBinaryExpression)op2);
                    n.fNext = stack;
                    stack = n;
                    continue;
                }
                if (op2 != null && !op2.accept(action)) {
                    return false;
                }
            }
            if (action.shouldVisitExpressions && action.leave(expr) == 2) {
                return false;
            }
            stack = stack.fNext;
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.operand1) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.operand1 = (IASTExpression)other;
        }
        if (child == this.operand2) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.operand2 = (IASTInitializerClause)other;
        }
    }

    public IType getExpressionType() {
        if (this.type == null) {
            this.type = this.createExpressionType();
        }
        return this.type;
    }

    public ICPPFunction getOverload() {
        if (this.overload != UNINITIALIZED_FUNCTION) {
            return this.overload;
        }
        this.overload = CPPSemantics.findOverloadedOperator(this);
        return this.overload;
    }

    public boolean isLValue() {
        ICPPFunction op = this.getOverload();
        if (op != null) {
            try {
                return CPPVisitor.isLValueReference(op.getType().getReturnType());
            }
            catch (DOMException dOMException) {}
        }
        switch (this.getOperator()) {
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return true;
            }
        }
        return false;
    }

    private IType createExpressionType() {
        ICPPFunction o = this.getOverload();
        if (o != null) {
            try {
                return o.getType().getReturnType();
            }
            catch (DOMException e) {
                e.getProblem();
            }
        }
        int op = this.getOperator();
        IType type1 = SemanticUtil.getUltimateTypeUptoPointers(this.getOperand1().getExpressionType());
        if (type1 instanceof IProblemBinding) {
            return type1;
        }
        IType type2 = SemanticUtil.getUltimateTypeUptoPointers(this.getOperand2().getExpressionType());
        if (type2 instanceof IProblemBinding) {
            return type2;
        }
        IType type = CPPArithmeticConversion.convertCppOperandTypes(op, type1, type2);
        if (type != null) {
            return type;
        }
        switch (op) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 28: 
            case 29: {
                return new CPPBasicType(IBasicType.Kind.eBoolean, 0, this);
            }
            case 4: {
                if (!(type2 instanceof IPointerType)) break;
                return type2;
            }
            case 5: {
                if (!(type2 instanceof IPointerType)) break;
                if (type1 instanceof IPointerType) {
                    return CPPVisitor.getPointerDiffType(this);
                }
                return type1;
            }
            case 30: 
            case 31: {
                if (type2 instanceof ICPPPointerToMemberType) {
                    return ((ICPPPointerToMemberType)type2).getType();
                }
                return new ProblemBinding(this, 5, this.getRawSignature().toCharArray());
            }
        }
        return type1;
    }

    private static class N {
        final IASTBinaryExpression fExpression;
        int fState;
        N fNext;

        N(IASTBinaryExpression expr) {
            this.fExpression = expr;
        }
    }
}

