/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConversionName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.core.parser.util.CharArrayMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.index.DeclaredBindingsFilter;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.BindingCollector;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.IPDOMCPPClassType;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMClassUtil;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PDOMCPPClassScope
implements ICPPClassScope,
IIndexScope {
    private static final IndexFilter CONVERSION_FILTER = new DeclaredBindingsFilter(1, true, false){

        public boolean acceptBinding(IBinding binding) throws CoreException {
            return binding instanceof ICPPMethod && SemanticUtil.isConversionOperator((ICPPMethod)binding) && super.acceptBinding(binding);
        }
    };
    private IPDOMCPPClassType fBinding;

    public PDOMCPPClassScope(IPDOMCPPClassType binding) {
        this.fBinding = binding;
    }

    @Override
    public EScopeKind getKind() {
        return EScopeKind.eClassType;
    }

    @Override
    public ICPPClassType getClassType() {
        return this.fBinding;
    }

    @Override
    public IBinding getBinding(IASTName name, boolean resolve) throws DOMException {
        return this.getBinding(name, resolve, null);
    }

    @Override
    public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup) throws DOMException {
        return this.getBindings(name, resolve, prefixLookup, null);
    }

    @Override
    public IBinding getBinding(IASTName name, boolean resolve, IIndexFileSet fileSet) throws DOMException {
        try {
            char[] nameChars = name.getSimpleID();
            if (CharArrayUtils.equals(this.fBinding.getNameCharArray(), nameChars)) {
                return this.getClassNameBinding();
            }
            Object[] candidates = PDOMCPPClassScope.getBindingsViaCache(this.fBinding, nameChars, IndexFilter.CPP_DECLARED_OR_IMPLICIT_NO_INSTANCE);
            return CPPSemantics.resolveAmbiguities(name, candidates);
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return null;
        }
    }

    private IBinding getClassNameBinding() throws DOMException {
        if (this.fBinding instanceof ICPPClassTemplatePartialSpecialization) {
            return ((ICPPClassTemplatePartialSpecialization)((Object)this.fBinding)).getPrimaryClassTemplate();
        }
        if (this.fBinding instanceof ICPPSpecialization) {
            return ((ICPPSpecialization)((Object)this.fBinding)).getSpecializedBinding();
        }
        return this.fBinding;
    }

    @Override
    public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup, IIndexFileSet fileSet) throws DOMException {
        try {
            if (name instanceof ICPPASTConversionName) {
                BindingCollector visitor = new BindingCollector((PDOMLinkage)this.fBinding.getLinkage(), Keywords.cOPERATOR, CONVERSION_FILTER, true, true);
                PDOMCPPClassScope.acceptViaCache(this.fBinding, visitor, true);
                return visitor.getBindings();
            }
            char[] nameChars = name.getSimpleID();
            if (!prefixLookup) {
                if (CharArrayUtils.equals(this.fBinding.getNameCharArray(), nameChars)) {
                    if (CPPClassScope.shallReturnConstructors(name, prefixLookup)) {
                        return this.fBinding.getConstructors();
                    }
                    return new IBinding[]{this.getClassNameBinding()};
                }
                return PDOMCPPClassScope.getBindingsViaCache(this.fBinding, nameChars, IndexFilter.CPP_DECLARED_OR_IMPLICIT_NO_INSTANCE);
            }
            BindingCollector visitor = new BindingCollector((PDOMLinkage)this.fBinding.getLinkage(), nameChars, IndexFilter.CPP_DECLARED_OR_IMPLICIT_NO_INSTANCE, prefixLookup, !prefixLookup);
            if (CharArrayUtils.equals(this.fBinding.getNameCharArray(), 0, nameChars.length, nameChars, true)) {
                visitor.visit((IPDOMNode)((Object)this.getClassNameBinding()));
            }
            PDOMCPPClassScope.acceptViaCache(this.fBinding, visitor, true);
            return visitor.getBindings();
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return null;
        }
    }

    public static IBinding[] getBindingsViaCache(IPDOMCPPClassType ct, char[] name, IndexFilter filter) throws CoreException {
        CharArrayMap<List<PDOMBinding>> map = PDOMCPPClassScope.getBindingMap(ct);
        List<PDOMBinding> cached = map.get(name);
        if (cached == null) {
            return IBinding.EMPTY_BINDING_ARRAY;
        }
        int i = 0;
        IBinding[] result = new IBinding[cached.size()];
        for (IBinding iBinding : cached) {
            if (!filter.acceptBinding(iBinding)) continue;
            result[i++] = iBinding;
        }
        if (i == result.length) {
            return result;
        }
        IBinding[] iBindingArray = new IBinding[i];
        System.arraycopy(result, 0, iBindingArray, 0, i);
        return iBindingArray;
    }

    public static void acceptViaCache(IPDOMCPPClassType ct, IPDOMVisitor visitor, boolean includeNestedInAnonymous) throws CoreException {
        long record = ct.getRecord();
        CharArrayMap<List<PDOMBinding>> map = PDOMCPPClassScope.getBindingMap(ct);
        for (List<PDOMBinding> list : map.values()) {
            for (PDOMBinding node : list) {
                if (!includeNestedInAnonymous && node.getParentNodeRec() != record) continue;
                if (visitor.visit(node)) {
                    node.accept(visitor);
                }
                visitor.leave(node);
            }
        }
    }

    public static void updateCache(IPDOMCPPClassType ct, PDOMNode member) throws CoreException {
        if (member instanceof PDOMBinding) {
            CharArrayMap map;
            Long key = ct.getRecord() + 0L;
            PDOM pdom = ct.getPDOM();
            Reference cached = (Reference)pdom.getCachedResult(key);
            CharArrayMap charArrayMap = map = cached == null ? null : (CharArrayMap)cached.get();
            if (map != null) {
                new PopulateMap(map).visit(member);
            }
        }
    }

    public static CharArrayMap<List<PDOMBinding>> getBindingMap(IPDOMCPPClassType ct) throws CoreException {
        CharArrayMap map;
        Long key = ct.getRecord() + 0L;
        PDOM pdom = ct.getPDOM();
        Reference cached = (Reference)pdom.getCachedResult(key);
        CharArrayMap charArrayMap = map = cached == null ? null : (CharArrayMap)cached.get();
        if (map == null) {
            map = new CharArrayMap();
            PopulateMap visitor = new PopulateMap(map);
            visitor.visit(ct);
            ct.acceptUncached(visitor);
            pdom.putCachedResult(key, new SoftReference(map));
        }
        return map;
    }

    @Override
    public IBinding[] find(String name) throws DOMException {
        return CPPSemantics.findBindings((IScope)this, name, false);
    }

    @Override
    public IIndexBinding getScopeBinding() {
        return this.fBinding;
    }

    @Override
    public ICPPMethod[] getImplicitMethods() {
        try {
            PDOMClassUtil.MethodCollector methods = new PDOMClassUtil.MethodCollector(true, false);
            PDOMCPPClassScope.acceptViaCache(this.fBinding, methods, false);
            return methods.getMethods();
        }
        catch (CoreException coreException) {
            return new ICPPMethod[0];
        }
    }

    @Override
    public ICPPConstructor[] getConstructors() throws DOMException {
        return this.fBinding.getConstructors();
    }

    @Override
    public IIndexScope getParent() {
        return this.fBinding.getScope();
    }

    @Override
    public IIndexName getScopeName() {
        return this.fBinding.getScopeName();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PDOMCPPClassScope) {
            return this.fBinding.equals(((PDOMCPPClassScope)obj).fBinding);
        }
        return false;
    }

    public int hashCode() {
        return this.fBinding.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PopulateMap
    implements IPDOMVisitor {
        private final CharArrayMap<List<PDOMBinding>> fResult;

        private PopulateMap(CharArrayMap<List<PDOMBinding>> result) {
            this.fResult = result;
        }

        @Override
        public boolean visit(IPDOMNode node) throws CoreException {
            if (node instanceof PDOMBinding) {
                PDOMBinding binding = (PDOMBinding)node;
                char[] nchars = binding.getNameCharArray();
                List<PDOMBinding> list = this.fResult.get(nchars);
                if (list == null) {
                    list = new ArrayList<PDOMBinding>();
                    this.fResult.put(nchars, list);
                }
                list.add(binding);
                try {
                    if (binding instanceof ICompositeType && ((ICompositeType)((Object)binding)).isAnonymous()) {
                        return true;
                    }
                }
                catch (DOMException dOMException) {}
            }
            return false;
        }

        @Override
        public void leave(IPDOMNode node) {
        }
    }
}

