/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.proxy.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.ptp.proxy.command.IProxyCommand;
import org.eclipse.ptp.proxy.command.IProxyCommandFactory;
import org.eclipse.ptp.proxy.command.IProxyCommandListener;
import org.eclipse.ptp.proxy.packet.ProxyPacket;
import org.eclipse.ptp.proxy.server.IProxyServer;

public abstract class AbstractProxyServer
implements IProxyServer {
    public static final int MAX_ERRORS = 5;
    protected ServerState state = ServerState.INIT;
    private final String sessHost;
    private final int sessPort;
    protected ReadableByteChannel sessInput;
    protected WritableByteChannel sessOutput;
    private final IProxyCommandFactory proxyCommandFactory;
    private Thread commandThread;
    private final List<IProxyCommandListener> listeners = Collections.synchronizedList(new ArrayList());

    public AbstractProxyServer(String host, int port, IProxyCommandFactory factory) {
        this.sessHost = host;
        this.sessPort = port;
        this.proxyCommandFactory = factory;
    }

    public void addListener(IProxyCommandListener listener) {
        this.listeners.add(listener);
    }

    public void connect() throws IOException {
        SocketChannel channel = SocketChannel.open();
        channel.connect(new InetSocketAddress(this.sessHost, this.sessPort));
        this.sessInput = channel;
        this.sessOutput = channel;
    }

    protected void fireProxyCommand(IProxyCommand cmd) {
        System.out.println("fireProxyCommand: " + cmd.getCommandID());
        for (IProxyCommandListener listener : this.listeners) {
            listener.handleCommand(cmd);
        }
    }

    public void removeListener(IProxyCommandListener listener) {
        this.listeners.remove(listener);
    }

    protected abstract void runStateMachine() throws InterruptedException, IOException;

    private boolean sessionProgress() throws IOException {
        ProxyPacket packet = new ProxyPacket();
        System.out.print("sessionProgress: ");
        if (!packet.read(this.sessInput)) {
            System.out.println("false");
            return false;
        }
        System.out.println(String.valueOf(packet.getID()) + "," + packet.getTransID() + "," + packet.getArgs());
        IProxyCommand cmd = this.proxyCommandFactory.toCommand(packet);
        System.out.println("cmd: " + cmd);
        if (cmd != null) {
            this.fireProxyCommand(cmd);
            return true;
        }
        return false;
    }

    public void start() throws IOException {
        this.commandThread = new Thread("Proxy Server Command Thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ServerState serverState;
                boolean error = false;
                int errorCount = 0;
                System.out.println("server command thread starting...");
                try {
                    while (errorCount < 5 && !this.isInterrupted()) {
                        serverState = AbstractProxyServer.this.state;
                        synchronized (serverState) {
                            if (AbstractProxyServer.this.state == ServerState.SHUTDOWN) {
                                break;
                            }
                        }
                        if (AbstractProxyServer.this.sessionProgress()) continue;
                        ++errorCount;
                    }
                }
                catch (IOException e) {
                    ServerState serverState2 = AbstractProxyServer.this.state;
                    synchronized (serverState2) {
                        if (!this.isInterrupted() && AbstractProxyServer.this.state != ServerState.SHUTDOWN) {
                            error = true;
                            System.out.println("event thread IOException . . . " + e.getMessage());
                        }
                    }
                }
                if (errorCount >= 5) {
                    error = true;
                }
                try {
                    AbstractProxyServer.this.sessInput.close();
                }
                catch (IOException iOException) {}
                serverState = AbstractProxyServer.this.state;
                synchronized (serverState) {
                    AbstractProxyServer.this.state = ServerState.SHUTDOWN;
                }
                System.out.println("server thread exited");
                if (error) {
                    System.out.println(" due to errors");
                } else {
                    System.out.println(" normally");
                }
            }
        };
        this.commandThread.start();
        try {
            this.runStateMachine();
            this.commandThread.interrupt();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ServerState {
        INIT,
        DISCOVERY,
        NORMAL,
        SUSPENDED,
        SHUTDOWN;

    }
}

