/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.refactoring;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.ui.actions.FortranEditorActionDelegate;
import org.eclipse.photran.internal.ui.editor.FortranEditor;
import org.eclipse.photran.internal.ui.vpg.PhotranResourceFilter;
import org.eclipse.rephraserengine.core.refactorings.IEditorRefactoring;
import org.eclipse.rephraserengine.core.refactorings.IResourceRefactoring;
import org.eclipse.rephraserengine.core.resources.IResourceFilter;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;
import org.eclipse.rephraserengine.ui.UIUtil;
import org.eclipse.rephraserengine.ui.WorkbenchSelectionInfo;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFortranRefactoringActionDelegate
extends FortranEditorActionDelegate {
    private Class<?> refactoringClass;
    private Class<?> wizardClass;

    public AbstractFortranRefactoringActionDelegate(Class<?> refactoringClass, Class<?> wizardClass) {
        this.refactoringClass = refactoringClass;
        this.wizardClass = wizardClass;
    }

    public void run(IAction action) {
        WorkbenchSelectionInfo selection = new WorkbenchSelectionInfo((IResourceFilter)new PhotranResourceFilter());
        if (IEditorRefactoring.class.isAssignableFrom(this.refactoringClass) && (!IResourceRefactoring.class.isAssignableFrom(this.refactoringClass) || selection.isTextSelectedInEditor()) && UIUtil.askUserToSaveModifiedFiles((IFile)selection.getFileInEditor())) {
            super.run(action);
        } else if (IResourceRefactoring.class.isAssignableFrom(this.refactoringClass) && UIUtil.askUserToSaveModifiedFiles((List)selection.getAllFilesInSelectedResources())) {
            this.runForSelectedFiles(selection);
        } else {
            throw new IllegalStateException("refactoringClass " + this.refactoringClass.getName() + " passed to AbstractFortranRefactoringActionDelegate constructor " + " is not an instance of IResourceRefactoring or IEditorRefactoring");
        }
    }

    private void runForSelectedFiles(WorkbenchSelectionInfo selection) {
        VPGRefactoring<IFortranAST, Token, PhotranVPG> refact = this.getRefactoring(selection.getAllFilesInSelectedResources());
        RefactoringWizard wizard = this.getRefactoringWizard(this.wizardClass, refact);
        try {
            Shell shell = UIUtil.determineActiveShell();
            if (shell == null) {
                return;
            }
            try {
                String name = refact.getName();
                RefactoringWizardOpenOperation wiz = new RefactoringWizardOpenOperation(wizard);
                wiz.run(shell, name);
                FortranEditor activeFortranEditor = this.getFortranEditor();
                if (activeFortranEditor != null) {
                    activeFortranEditor.forceOutlineViewUpdate();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        finally {
            PhotranVPG.getInstance().releaseAllASTs();
        }
    }

    public void run(IProgressMonitor progressMonitor) {
        block6: {
            try {
                try {
                    if (this.getFortranEditor().getIFile() == null) {
                        MessageDialog.openError((Shell)this.getFortranEditor().getShell(), (String)"Error", (String)"The file in the editor cannot be refactored.\n\nFortran files can only be refactored if they are located inside a Fortran project in your workspace.");
                        break block6;
                    }
                    ArrayList<IFile> files = new ArrayList<IFile>();
                    files.add(this.getFortranEditor().getIFile());
                    VPGRefactoring<IFortranAST, Token, PhotranVPG> refactoring = this.getRefactoring(files);
                    RefactoringWizard wizard = this.getRefactoringWizard(this.wizardClass, refactoring);
                    new RefactoringWizardOpenOperation(wizard).run(this.getFortranEditor().getShell(), refactoring.getName());
                    this.getFortranEditor().forceOutlineViewUpdate();
                }
                catch (InterruptedException interruptedException) {
                    PhotranVPG.getInstance().releaseAllASTs();
                }
            }
            finally {
                PhotranVPG.getInstance().releaseAllASTs();
            }
        }
    }

    protected abstract VPGRefactoring<IFortranAST, Token, PhotranVPG> getRefactoring(List<IFile> var1);

    private RefactoringWizard getRefactoringWizard(Class<?> wizardClass, VPGRefactoring<IFortranAST, Token, PhotranVPG> refactoring) {
        try {
            Constructor<?> ctor = wizardClass.getConstructors()[0];
            return (RefactoringWizard)ctor.newInstance(refactoring);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

