/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core.elements;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ptp.core.elementcontrols.IPElementControl;
import org.eclipse.ptp.core.elements.IPElement;

public class PElementInfo {
    private final Map<String, IPElementControl> fChildren = Collections.synchronizedMap(new HashMap());
    protected final IPElementControl element;

    public PElementInfo(IPElementControl element) {
        this.element = element;
    }

    public void addChild(IPElementControl member) {
        this.fChildren.put(member.getID(), member);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPElementControl findChild(String key) {
        Map<String, IPElementControl> map = this.fChildren;
        synchronized (map) {
            if (this.fChildren.containsKey(key)) {
                return this.fChildren.get(key);
            }
        }
        return null;
    }

    public IPElementControl[] getChildren() {
        return this.fChildren.values().toArray(new IPElementControl[this.size()]);
    }

    public IPElementControl getElement() {
        return this.element;
    }

    public boolean hasChildren() {
        return this.size() > 0;
    }

    public boolean includesChild(IPElementControl child) {
        return this.fChildren.containsKey(child.getID());
    }

    public void removeChild(IPElement member) {
        this.fChildren.remove(member.getID());
    }

    public void removeChildren() {
        this.fChildren.clear();
    }

    public void setChildren(IPElementControl[] children) {
        IPElementControl[] iPElementControlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IPElementControl element = iPElementControlArray[n2];
            this.fChildren.put(element.getID(), element);
            ++n2;
        }
    }

    public int size() {
        return this.fChildren.size();
    }
}

