/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.vpg.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.rephraserengine.core.preservation.PreservationAnalysis;
import org.eclipse.rephraserengine.core.preservation.PreservationRule;
import org.eclipse.rephraserengine.core.vpg.TokenRef;
import org.eclipse.rephraserengine.core.vpg.VPGDB;
import org.eclipse.rephraserengine.core.vpg.eclipse.EclipseVPG;
import org.eclipse.rephraserengine.core.vpg.eclipse.EclipseVPGLog;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGEditorRefactoring;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VPGPreservationBasedEditorRefactoring<A, T, V extends EclipseVPG<A, T, ? extends TokenRef<T>, ? extends VPGDB<A, T, ?, ?>, ? extends EclipseVPGLog<T, ?>>>
extends VPGEditorRefactoring<A, T, V> {
    protected PreservationAnalysis preservation = null;

    @Override
    protected final void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        try {
            pm.beginTask("Checking final preconditions", 40);
            this.astOfFileInEditor = this.vpg.acquireTransientAST(this.fileInEditor);
            this.doValidateUserInput(status, (IProgressMonitor)new SubProgressMonitor(pm, 5));
            if (!status.hasFatalError()) {
                this.vpg.acquirePermanentAST(this.fileInEditor);
                this.preservation = new PreservationAnalysis((EclipseVPG)this.getVPG(), pm, 10, this.fileInEditor, this.getEdgesToPreserve());
                this.doTransform(status, (IProgressMonitor)new SubProgressMonitor(pm, 5));
                this.vpg.commitChangesFromInMemoryASTs(pm, 20, this.fileInEditor);
                this.preservation.checkForPreservation(status, pm, 0);
                this.addChangeFromModifiedAST(this.fileInEditor, pm);
            }
            pm.done();
        }
        finally {
            this.vpg.releaseAllASTs();
        }
    }

    @Override
    protected final void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
    }

    protected abstract void doValidateUserInput(RefactoringStatus var1, IProgressMonitor var2) throws VPGRefactoring.PreconditionFailure;

    protected abstract PreservationRule[] getEdgesToPreserve();

    protected abstract void doTransform(RefactoringStatus var1, IProgressMonitor var2) throws VPGRefactoring.PreconditionFailure;
}

