/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openmp.analysis.ompcfg.factory;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTContinueStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.ptp.pldt.openmp.analysis.PAST.PASTOMPPragma;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.OMPBasicBlock;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.OMPCFG;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.OMPCFGNode;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.OMPExpressionBlock;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.OMPPragmaNode;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.factory.OMPCFGResult;

public class OMPCFGMaker
extends ASTVisitor {
    protected IASTNode tNode_ = null;
    protected OMPCFGResult result_ = new OMPCFGResult();
    protected static Hashtable pragmaRegionMap_ = null;
    protected static Hashtable pragmaLocationMap_ = null;
    protected static Stack pragmaContext_ = null;
    protected OMPCFGNode firstNode_ = null;
    protected OMPCFGNode currentNode_ = null;
    protected static boolean traceOn_ = false;

    public static OMPCFG constructCFG(PASTOMPPragma pragma, IASTStatement statement, Hashtable pragmaRegionMap, Hashtable pragmaLocationMap) {
        pragmaRegionMap_ = pragmaRegionMap;
        pragmaLocationMap_ = pragmaLocationMap;
        pragmaContext_ = new Stack();
        OMPCFGMaker maker = new OMPCFGMaker(statement);
        maker.buildCFG();
        OMPCFGResult result = maker.getResult();
        result.resolve();
        OMPCFG cfg = new OMPCFG(pragma, statement, result.getFirstChain(), result.getUnconnectedChains(), result.getUnresolvedControlFlow(), result.getLabelMap());
        pragmaRegionMap_ = null;
        pragmaLocationMap_ = null;
        pragmaContext_ = null;
        return cfg;
    }

    protected OMPCFGMaker(IASTStatement tNode) {
        this.tNode_ = tNode;
        this.shouldVisitStatements = true;
        this.shouldVisitDeclarations = true;
    }

    protected OMPCFGMaker(IASTExpression tNode) {
        this.tNode_ = tNode;
        this.shouldVisitExpressions = true;
    }

    public void buildCFG() {
        if (this.tNode_ == null) {
            this.firstNode_ = this.currentNode_ = new OMPBasicBlock();
        } else {
            this.tNode_.accept((ASTVisitor)this);
        }
        if (this.currentNode_ != null) {
            this.result_.addChain(this.firstNode_, this.currentNode_, 0, null);
            this.currentNode_ = null;
            this.firstNode_ = null;
        }
    }

    public OMPCFGResult getResult() {
        return this.result_;
    }

    public int visit(IASTExpression expression) {
        OMPExpressionBlock b = new OMPExpressionBlock();
        b.setPragmaContext(this.getLastPragma());
        b.addExpression(expression);
        this.firstNode_ = this.currentNode_ = b;
        return 3;
    }

    public int visit(IASTDeclaration declaration) {
        return 3;
    }

    public int visit(IASTStatement statement) {
        int checkValue = this.pragmaRegionCheck(statement);
        if (checkValue != -1) {
            return checkValue;
        }
        if (statement instanceof IASTIfStatement) {
            this.processIfStatement((IASTIfStatement)statement);
            this.pragmaRegionlessCheck(statement, 0);
            return 1;
        }
        if (statement instanceof IASTSwitchStatement) {
            this.processSwitchStatement((IASTSwitchStatement)statement);
            this.pragmaRegionlessCheck(statement, 0);
            return 1;
        }
        if (statement instanceof IASTCaseStatement) {
            this.processCaseStatement((IASTCaseStatement)statement);
            return 3;
        }
        if (statement instanceof IASTForStatement) {
            this.processForStatement((IASTForStatement)statement);
            this.pragmaRegionlessCheck(statement, 0);
            return 1;
        }
        if (statement instanceof IASTWhileStatement) {
            this.processWhileStatement((IASTWhileStatement)statement);
            this.pragmaRegionlessCheck(statement, 0);
            return 1;
        }
        if (statement instanceof IASTDoStatement) {
            this.processDoStatement((IASTDoStatement)statement);
            this.pragmaRegionlessCheck(statement, 0);
            return 1;
        }
        if (statement instanceof IASTCompoundStatement) {
            this.pragmaRegionlessCheck(statement, 1);
            return 3;
        }
        if (statement instanceof IASTBreakStatement) {
            this.addToBasicBlockAndChain(statement, 2);
            return 3;
        }
        if (statement instanceof IASTContinueStatement) {
            this.addToBasicBlockAndChain(statement, 1);
            return 3;
        }
        if (statement instanceof IASTReturnStatement) {
            this.addToBasicBlockAndChain(statement, 3);
            return 3;
        }
        this.addToBasicBlock(statement);
        this.pragmaRegionlessCheck(statement, 0);
        return 3;
    }

    protected int pragmaRegionCheck(IASTStatement statement) {
        PASTOMPPragma pragma = (PASTOMPPragma)pragmaRegionMap_.get(statement);
        if (pragmaContext_.size() != 0 && ((OMPPragmaNode)pragmaContext_.peek()).getPragma() == pragma) {
            return -1;
        }
        if (pragma != null) {
            int type;
            OMPPragmaNode pNode = new OMPPragmaNode(pragma, this.getLastPragma());
            pNode.setPragmaContext(this.getLastPragma());
            this.addToChain(pNode);
            pragmaContext_.push(pNode);
            OMPCFGMaker maker = new OMPCFGMaker(statement);
            maker.buildCFG();
            pragmaContext_.pop();
            this.result_.merge(maker.getResult());
            if (maker.getResult().getFirstChain() != null) {
                pNode.connectTo(maker.getResult().getFirstChain().getHeadNode());
                this.currentNode_ = maker.getResult().getFirstChain().getTailNode();
            }
            if (!((type = pragma.getOMPType()) != 0 && type != 5 && type != 6 && type != 4 || pragma.getNoWait())) {
                this.addToChain(new OMPPragmaNode(), true);
            }
            return 1;
        }
        return -1;
    }

    protected void pragmaRegionlessCheck(IASTStatement statement, int proximity) {
        LinkedList l = (LinkedList)pragmaLocationMap_.get(statement);
        if (l == null) {
            return;
        }
        for (PASTOMPPragma oPragma : l) {
            if (oPragma.getProximity() != proximity || oPragma.getRegion() != null) continue;
            OMPPragmaNode pNode = new OMPPragmaNode(oPragma, this.getLastPragma());
            pNode.setPragmaContext(this.getLastPragma());
            this.addToChain(pNode);
        }
    }

    private void processIfStatement(IASTIfStatement ifs) {
        OMPCFGMaker ift = new OMPCFGMaker(ifs.getThenClause());
        OMPCFGMaker ife = new OMPCFGMaker(ifs.getElseClause());
        ift.buildCFG();
        ife.buildCFG();
        OMPCFGResult.Chain thenChain = ift.getResult().getFirstChain();
        OMPCFGResult.Chain elseChain = ife.getResult().getFirstChain();
        if (!this.getRelevance(ift.getResult()) && !this.getRelevance(ife.getResult())) {
            this.addToBasicBlock((IASTStatement)ifs);
            return;
        }
        this.addBasicBlockBranch(ifs.getConditionExpression(), 0);
        if (traceOn_) {
            System.out.println("CFGFactory: Create IF BranchNode");
        }
        this.currentNode_.connectTo(thenChain.getHeadNode());
        this.currentNode_.connectTo(elseChain.getHeadNode());
        OMPBasicBlock jn = new OMPBasicBlock();
        jn.setPragmaContext(this.getLastPragma());
        if (traceOn_) {
            System.out.println("CFGFactory: Create JoinNode");
        }
        if (thenChain.getTerminationReason() == 0) {
            thenChain.getTailNode().connectTo(jn);
        }
        if (elseChain.getTerminationReason() == 0) {
            elseChain.getTailNode().connectTo(jn);
        }
        this.result_.merge(ift.getResult());
        this.result_.merge(ife.getResult());
        if (jn.hasPredecessors()) {
            this.addToChain(jn, false);
        }
    }

    private void processSwitchStatement(IASTSwitchStatement iss) {
        IASTStatement body = iss.getBody();
        OMPCFGMaker caseBodyFactory = new OMPCFGMaker(body);
        caseBodyFactory.buildCFG();
        OMPCFGResult cBody = caseBodyFactory.getResult();
        OMPBasicBlock bn = new OMPBasicBlock();
        bn.setPragmaContext(this.getLastPragma());
        OMPBasicBlock jn = new OMPBasicBlock();
        jn.setPragmaContext(this.getLastPragma());
        bn.setBranchingExpression(iss.getControllerExpression(), 1);
        LinkedList chains = cBody.getChains();
        for (OMPCFGResult.Chain chain : chains) {
            OMPCFGNode p = chain.getHeadNode();
            while (p != null) {
                if (p instanceof OMPBasicBlock && ((OMPBasicBlock)p).isCase()) {
                    bn.connectTo(p);
                }
                p = p.getSuccessor();
            }
        }
        LinkedList ucf = cBody.getUnresolvedControlFlow();
        Object[] ucfList = ucf.toArray();
        int i = 0;
        while (i < ucfList.length) {
            OMPCFGResult.Chain urcf = (OMPCFGResult.Chain)ucfList[i];
            if (urcf.getTerminationReason() == 2) {
                urcf.getTailNode().connectTo(jn);
                cBody.removeUnresolvedControlFlow(urcf);
            }
            ++i;
        }
        if (!this.getRelevance(cBody)) {
            this.addToBasicBlock((IASTStatement)iss);
            return;
        }
        this.result_.merge(cBody);
        this.addToChain(bn, true);
        this.addToChain(jn, false);
    }

    private void processWhileStatement(IASTWhileStatement whileStmt) {
        IASTExpression condition = whileStmt.getCondition();
        IASTStatement body = whileStmt.getBody();
        OMPCFGMaker bodyBuilder = new OMPCFGMaker(body);
        bodyBuilder.buildCFG();
        OMPCFGResult cBody = bodyBuilder.getResult();
        OMPBasicBlock bn = new OMPBasicBlock();
        bn.setPragmaContext(this.getLastPragma());
        bn.setBranchingExpression(condition, 2);
        OMPBasicBlock jn = new OMPBasicBlock();
        jn.setPragmaContext(this.getLastPragma());
        bn.connectTo(jn);
        bn.connectTo(cBody.getFirstChain().getHeadNode());
        cBody.getLastChain().getTailNode().connectTo(bn);
        LinkedList ucf = cBody.getUnresolvedControlFlow();
        for (OMPCFGResult.Chain urcf : ucf) {
            if (urcf.getTerminationReason() == 2) {
                urcf.getTailNode().connectTo(jn);
                cBody.removeUnresolvedControlFlow(urcf);
                continue;
            }
            if (urcf.getTerminationReason() != 1) continue;
            urcf.getTailNode().connectTo(bn);
            cBody.removeUnresolvedControlFlow(urcf);
        }
        if (!this.getRelevance(cBody)) {
            this.addToBasicBlock((IASTStatement)whileStmt);
            return;
        }
        this.result_.merge(cBody);
        this.addToChain(bn, true);
        this.addToChain(jn, false);
    }

    private void processDoStatement(IASTDoStatement doStmt) {
        IASTExpression condition = doStmt.getCondition();
        IASTStatement body = doStmt.getBody();
        OMPBasicBlock bn = new OMPBasicBlock();
        bn.setPragmaContext(this.getLastPragma());
        bn.setBranchingExpression(condition, 3);
        OMPBasicBlock jn = new OMPBasicBlock();
        jn.setPragmaContext(this.getLastPragma());
        OMPCFGMaker bodyBuilder = new OMPCFGMaker(body);
        bodyBuilder.buildCFG();
        OMPCFGResult cBody = bodyBuilder.getResult();
        cBody.getLastChain().getTailNode().connectTo(bn);
        bn.connectTo(cBody.getFirstChain().getHeadNode());
        bn.connectTo(jn);
        if (!this.getRelevance(cBody)) {
            this.addToBasicBlock((IASTStatement)doStmt);
            return;
        }
        this.result_.merge(cBody);
        this.addToChain(cBody.getFirstChain().getHeadNode(), true);
        this.addToChain(jn, true);
    }

    private void processCaseStatement(IASTCaseStatement ics) {
        OMPBasicBlock b = new OMPBasicBlock();
        b.setPragmaContext(this.getLastPragma());
        this.addToChain(b);
        if (traceOn_) {
            System.out.println("CFGFactory: Create BasicBlock due to case statement");
        }
        ((OMPBasicBlock)this.currentNode_).addStatement((IASTStatement)ics);
    }

    private void processForStatement(IASTForStatement forStmt) {
        IASTStatement initializer = forStmt.getInitializerStatement();
        IASTExpression condition = forStmt.getConditionExpression();
        IASTExpression iteration = forStmt.getIterationExpression();
        IASTStatement body = forStmt.getBody();
        OMPBasicBlock bn = new OMPBasicBlock();
        bn.setBranchingExpression(condition, 4);
        OMPBasicBlock jn = new OMPBasicBlock();
        OMPCFGMaker initBuilder = new OMPCFGMaker(initializer);
        initBuilder.buildCFG();
        OMPCFGResult cInit = initBuilder.getResult();
        OMPCFGMaker forBodyFactory = new OMPCFGMaker(body);
        forBodyFactory.buildCFG();
        OMPCFGResult cBody = forBodyFactory.getResult();
        OMPCFGMaker iterBodyFactory = new OMPCFGMaker(iteration);
        iterBodyFactory.buildCFG();
        OMPCFGResult cIter = iterBodyFactory.getResult();
        cInit.getLastChain().getTailNode().connectTo(bn);
        bn.connectTo(jn);
        bn.connectTo(cBody.getFirstChain().getHeadNode());
        cBody.getLastChain().getTailNode().connectTo(cIter.getFirstChain().getHeadNode());
        cIter.getLastChain().getTailNode().connectTo(bn);
        LinkedList ucf = cBody.getUnresolvedControlFlow();
        Object[] uList = ucf.toArray();
        int i = 0;
        while (i < uList.length) {
            OMPCFGResult.Chain urcf = (OMPCFGResult.Chain)uList[i];
            if (urcf.getTerminationReason() == 2) {
                urcf.getTailNode().connectTo(jn);
                cBody.removeUnresolvedControlFlow(urcf);
            } else if (urcf.getTerminationReason() == 1) {
                urcf.getTailNode().connectTo(cIter.getFirstChain().getHeadNode());
                cBody.removeUnresolvedControlFlow(urcf);
            }
            ++i;
        }
        if (!this.getRelevance(cBody)) {
            this.addToBasicBlock((IASTStatement)forStmt);
            return;
        }
        this.result_.merge(cInit);
        this.result_.merge(cIter);
        this.result_.merge(cBody);
        this.addToChain(cInit.getFirstChain().getHeadNode(), true);
        this.addToChain(bn, true);
        this.addToChain(jn, false);
    }

    protected boolean getRelevance(OMPCFGResult result) {
        boolean tf = result.getNumberOfPragmas() != 0 || result.getNumberOfLabels() != 0 || result.getUnresolvedControlFlow().size() != 0;
        return tf;
    }

    protected OMPPragmaNode getLastPragma() {
        return pragmaContext_.isEmpty() ? null : (OMPPragmaNode)pragmaContext_.peek();
    }

    private void addToBasicBlock(IASTStatement statement) {
        if (this.currentNode_ == null || !(this.currentNode_ instanceof OMPBasicBlock)) {
            OMPBasicBlock b = new OMPBasicBlock();
            b.setPragmaContext(this.getLastPragma());
            this.addToChain(b);
            if (traceOn_) {
                System.out.println("CFGFactory: Create BasicBlock");
            }
        }
        ((OMPBasicBlock)this.currentNode_).addStatement(statement);
    }

    private void addBasicBlockBranch(IASTExpression expression, int type) {
        if (this.currentNode_ == null || !(this.currentNode_ instanceof OMPBasicBlock)) {
            this.addToChain(new OMPBasicBlock(), true);
            if (traceOn_) {
                System.out.println("CFGFactory: Create BasicBlock");
            }
        }
        assert (((OMPBasicBlock)this.currentNode_).getBranchingExpression() == null);
        ((OMPBasicBlock)this.currentNode_).setBranchingExpression(expression, type);
    }

    private void addToChain(OMPCFGNode node, boolean connect) {
        if (this.firstNode_ == null) {
            this.firstNode_ = node;
            this.currentNode_ = node;
        } else {
            if (connect) {
                this.currentNode_.connectTo(node);
            }
            this.currentNode_ = node;
        }
    }

    private void addToChain(OMPCFGNode node) {
        this.addToChain(node, true);
    }

    private void addToBasicBlockAndChain(IASTStatement statement, int termReason) {
        this.addToBasicBlock(statement);
        OMPCFGResult.Chain chain = this.result_.addChain(this.firstNode_, this.currentNode_, termReason, statement);
        if (termReason == 2 || termReason == 1 || termReason == 3) {
            this.result_.addUnresolvedControlFlow(chain);
        }
        this.currentNode_ = null;
        this.firstNode_ = null;
    }
}

