/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import org.eclipse.cdt.internal.core.parser.scanner.AbstractCharArray;
import org.eclipse.cdt.internal.core.parser.scanner.CharArray;
import org.eclipse.cdt.internal.core.parser.scanner.LazyCharArray;

public class FileCharArray
extends LazyCharArray {
    private String fFileName;
    private String fCharSet;
    private FileChannel fChannel;

    public static AbstractCharArray create(String fileName, String charSet, InputStream in) throws IOException {
        FileChannel channel;
        long lsize;
        if (!(in instanceof FileInputStream)) {
            return null;
        }
        FileInputStream fis = (FileInputStream)in;
        if (!Charset.isSupported(charSet)) {
            charSet = System.getProperty("file.encoding");
        }
        if ((lsize = (channel = fis.getChannel()).size()) < 65536L) {
            return FileCharArray.decodeSmallFile(channel, (int)lsize, charSet);
        }
        return new FileCharArray(fileName, charSet);
    }

    private static AbstractCharArray decodeSmallFile(FileChannel channel, int lsize, String charSet) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(lsize);
        channel.read(byteBuffer);
        byteBuffer.flip();
        CharBuffer charBuffer = Charset.forName(charSet).decode(byteBuffer);
        char[] buf = FileCharArray.extractChars(charBuffer);
        return new CharArray(buf);
    }

    private static char[] extractChars(CharBuffer charBuffer) {
        char[] buf;
        if (charBuffer.hasArray() && charBuffer.arrayOffset() == 0 && (buf = charBuffer.array()).length == charBuffer.remaining()) {
            return buf;
        }
        buf = new char[charBuffer.remaining()];
        charBuffer.get(buf);
        return buf;
    }

    private FileCharArray(String fileName, String charSet) {
        this.fFileName = fileName;
        this.fCharSet = charSet;
    }

    protected LazyCharArray.Chunk createChunk(int chunkOffset) {
        LazyCharArray.Chunk chunk;
        FileInputStream fis;
        try {
            fis = new FileInputStream(this.fFileName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        this.fChannel = fis.getChannel();
        try {
            chunk = super.createChunk(chunkOffset);
            this.fChannel = null;
        }
        catch (Throwable throwable) {
            this.fChannel = null;
            try {
                fis.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            fis.close();
        }
        catch (IOException iOException) {}
        return chunk;
    }

    protected char[] readChunkData(long fileOffset, long[] fileEndOffsetHolder) throws IOException {
        assert (this.fChannel != null);
        Charset charset = Charset.forName(this.fCharSet);
        CharsetDecoder decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        int needBytes = (int)(65536.0 * (double)decoder.averageCharsPerByte());
        ByteBuffer in = ByteBuffer.allocate(needBytes);
        CharBuffer dest = CharBuffer.allocate(65536);
        boolean endOfInput = false;
        while (dest.position() < 65536 && !endOfInput) {
            this.fChannel.position(fileOffset);
            in.clear();
            int count = this.fChannel.read(in);
            if (count == -1) break;
            endOfInput = count < in.capacity();
            in.flip();
            decoder.decode(in, dest, endOfInput);
            fileOffset += (long)in.position();
        }
        fileEndOffsetHolder[0] = fileOffset;
        dest.flip();
        return FileCharArray.extractChars(dest);
    }

    protected void rereadChunkData(long fileOffset, long fileEndOffset, char[] dest) {
        block13: {
            FileInputStream fis;
            try {
                fis = new FileInputStream(this.fFileName);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return;
            }
            try {
                try {
                    FileChannel channel = fis.getChannel();
                    this.decode(channel, fileOffset, fileEndOffset, CharBuffer.wrap(dest));
                }
                catch (IOException iOException) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException2) {}
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                fis.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void decode(FileChannel channel, long fileOffset, long fileEndOffset, CharBuffer dest) throws IOException {
        Charset charset = Charset.forName(this.fCharSet);
        CharsetDecoder decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        int needBytes = (int)(fileEndOffset - fileOffset);
        ByteBuffer in = ByteBuffer.allocate(needBytes);
        channel.position(fileOffset);
        in.clear();
        channel.read(in);
        in.flip();
        decoder.decode(in, dest, true);
    }
}

