/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.serviceproviders;

import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.ptp.internal.rdt.core.RemoteIndexerInfoProviderFactory;
import org.eclipse.ptp.internal.rdt.core.RemoteScannerInfo;
import org.eclipse.ptp.internal.rdt.core.model.ModelAdapter;
import org.eclipse.ptp.internal.rdt.core.model.TranslationUnit;
import org.eclipse.ptp.internal.rdt.core.model.WorkingCopy;
import org.eclipse.ptp.internal.rdt.core.subsystems.ICIndexSubsystem;
import org.eclipse.ptp.rdt.core.RDTLog;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;

public class AbstractRemoteService {
    protected IConnectorService fConnectorService;
    protected ICIndexSubsystem fIndexSubsystem;

    public AbstractRemoteService(ICIndexSubsystem subSystem) {
        this.fIndexSubsystem = subSystem;
    }

    public AbstractRemoteService(IConnectorService connectorService) {
        this.fConnectorService = connectorService;
    }

    protected ICIndexSubsystem getSubSystem() {
        if (this.fIndexSubsystem == null && this.fConnectorService != null) {
            ISubSystem[] subSystems = this.fConnectorService.getSubSystems();
            int k = 0;
            while (k < subSystems.length) {
                if (subSystems[k] instanceof ICIndexSubsystem) {
                    this.fIndexSubsystem = (ICIndexSubsystem)subSystems[k];
                }
                ++k;
            }
        }
        return this.fIndexSubsystem;
    }

    protected ITranslationUnit adaptWorkingCopy(IWorkingCopy workingCopy) throws CModelException {
        ITranslationUnit unit;
        if (workingCopy.isConsistent()) {
            unit = (ITranslationUnit)ModelAdapter.adaptElement(null, workingCopy, 0, true);
        } else {
            String contents = new String(workingCopy.getContents());
            unit = new WorkingCopy(null, (ITranslationUnit)workingCopy, contents);
        }
        if (unit instanceof TranslationUnit) {
            IResource resource = workingCopy.getResource();
            ICProject project = workingCopy.getCProject();
            IProject rproject = project.getProject();
            IResource infoResource = resource != null ? resource : rproject;
            RemoteScannerInfo scannerInfo = RemoteIndexerInfoProviderFactory.getScannerInfo(infoResource);
            Map<String, String> langaugeProperties = null;
            try {
                String languageId = unit.getLanguage().getId();
                langaugeProperties = RemoteIndexerInfoProviderFactory.getLanguageProperties(languageId, rproject);
            }
            catch (Exception e) {
                RDTLog.logError(e);
            }
            ((TranslationUnit)unit).setASTContext(scannerInfo, langaugeProperties);
        }
        return unit;
    }
}

