/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.tau.perfdmf.views;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.ptp.etfw.internal.BuildLaunchUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParaProfController {
    private LinkedBlockingQueue<String> pushQueue = null;
    private LinkedBlockingQueue<String> pullQueue = null;
    private PrintStream stdout = null;
    private StreamRunner inRun;
    private StreamRunner errRun;
    private ProcessBuilder pb;
    private Process proc;
    private static final String DATABASES = "databases";
    private static final String APPLICATIONS = "applications";
    private static final String EXPERIMENTS = "experiments";
    private static final String TRIALS = "trials";
    public static TreeTuple EMPTY;

    public ParaProfController() {
        this.createProcess();
    }

    private void killProcess() {
        this.pushQueue = null;
        this.pullQueue = null;
        this.pb = null;
        this.errRun = null;
        this.inRun = null;
    }

    private void createProcess() {
        String paraprof = String.valueOf(BuildLaunchUtils.getToolPath((String)"tau")) + File.separator + "paraprof";
        EMPTY = new TreeTuple("None", -1, -1, Level.DATABASE);
        File checkp = new File(paraprof);
        if (!checkp.exists()) {
            return;
        }
        this.pushQueue = new LinkedBlockingQueue();
        this.pullQueue = new LinkedBlockingQueue();
        ArrayList<String> command = new ArrayList<String>();
        command.add(paraprof);
        command.add("--control");
        this.pb = new ProcessBuilder(command);
        this.proc = null;
        try {
            this.proc = this.pb.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.errRun = new StreamRunner(this.proc.getErrorStream());
        this.inRun = new StreamRunner(this.proc.getInputStream(), this.pushQueue, this.pullQueue);
        this.stdout = new PrintStream(new BufferedOutputStream(this.proc.getOutputStream()));
        this.errRun.start();
        this.inRun.start();
    }

    public List<TreeTuple> getDatabases() {
        List<TreeTuple> l = this.getInfo(DATABASES, -1, -1, Level.DATABASE);
        int i = 0;
        while (i < l.size()) {
            String name = l.get((int)i).name;
            if (name.equals("Default") || name.equals("default")) {
                TreeTuple t = l.remove(i);
                l.add(0, t);
                break;
            }
            ++i;
        }
        return l;
    }

    public List<TreeTuple> getApplications(int db) {
        return this.getInfo(APPLICATIONS, db, -1, Level.APPLICATION);
    }

    public List<TreeTuple> getExperiments(int db, int ap) {
        return this.getInfo(EXPERIMENTS, db, ap, Level.EXPERIMENT);
    }

    public List<TreeTuple> getTrials(int db, int ex) {
        return this.getInfo(TRIALS, db, ex, Level.TRIAL);
    }

    private List<TreeTuple> getInfo(String type, int dbid, int hid, Level level) {
        int res;
        ArrayList<TreeTuple> out = new ArrayList<TreeTuple>();
        String comBuf = "control list " + type;
        if (dbid > -1) {
            comBuf = String.valueOf(comBuf) + " " + dbid;
            if (hid > -1) {
                comBuf = String.valueOf(comBuf) + " " + hid;
            }
        }
        if ((res = this.issueCommand(comBuf)) != 0) {
            return out;
        }
        List<String> l = this.getResults();
        for (String s : l) {
            if (!s.startsWith("control return")) continue;
            String[] split = s.split(" ");
            int id = Integer.parseInt(split[2]);
            String name = split[3];
            int j = 4;
            while (j < split.length) {
                name = String.valueOf(name) + " " + split[j];
                ++j;
            }
            out.add(new TreeTuple(name, id, dbid, level));
        }
        return out;
    }

    public TreeTuple uploadTrial(String profile, int dbid, String app, String exp, String tri) {
        String comBuf = "control upload " + profile + " " + dbid + " " + app + " " + exp + " " + tri;
        int res = this.issueCommand(comBuf);
        if (res != 0) {
            return null;
        }
        TreeTuple tt = null;
        List<String> l = this.getResults();
        for (String s : l) {
            if (!s.startsWith("control return")) continue;
            String[] split = s.split(" ");
            int id = Integer.parseInt(split[2]);
            tt = new TreeTuple(tri, id, dbid, Level.TRIAL);
        }
        return tt;
    }

    private List<String> getResults() {
        boolean done = false;
        ArrayList<String> l = new ArrayList<String>();
        if (this.pushQueue != null) {
            while (!done) {
                String s = "";
                try {
                    s = this.pushQueue.take();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (s.equals("control endreturn") || s.equals("DONE")) {
                    done = true;
                    continue;
                }
                l.add(s);
            }
        }
        return l;
    }

    private int issueCommand(String command) {
        if (this.stdout != null) {
            this.stdout.println(command);
            this.stdout.flush();
        }
        if (this.errRun.exception) {
            System.out.println("Restarting Paraprof");
            this.killProcess();
            this.createProcess();
            return -1;
        }
        return 0;
    }

    public void openTrial(int dbid, int tid) {
        String comBuf = "control load " + dbid + " " + tid;
        this.issueCommand(comBuf);
    }

    public void openManager() {
        String comBuf = "control open manager";
        this.issueCommand(comBuf);
    }

    public BlockingQueue<String> getPullQueue() {
        return this.pullQueue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        DATABASE,
        APPLICATION,
        EXPERIMENT,
        TRIAL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StreamRunner
    extends Thread {
        private final LinkedBlockingQueue<String> pushQueue;
        private final LinkedBlockingQueue<String> pullQueue;
        InputStream is;
        boolean exception = false;

        StreamRunner(InputStream is, LinkedBlockingQueue<String> pushQueue, LinkedBlockingQueue<String> pullQueue) {
            this.is = is;
            this.pushQueue = pushQueue;
            this.pullQueue = pullQueue;
        }

        StreamRunner(InputStream is) {
            this.is = is;
            this.pushQueue = null;
            this.pullQueue = null;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (this.pushQueue == null || this.pullQueue == null) {
                        if (line.contains("Exception")) {
                            this.exception = true;
                        }
                        System.out.println(line);
                        continue;
                    }
                    if (line.startsWith("control sourcecode")) {
                        this.pullQueue.add(line);
                        continue;
                    }
                    this.pushQueue.add(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (this.pullQueue != null) {
                this.pullQueue.add("DONE");
            }
            if (this.pushQueue != null) {
                this.pushQueue.add("DONE");
            }
        }
    }

    public class TreeTuple {
        public int id;
        public String name;
        public int dbid;
        public Level level;

        public TreeTuple(String name, int id, int dbid, Level level) {
            this.id = id;
            this.name = name;
            this.dbid = dbid;
            this.level = level;
        }
    }
}

