/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.lexer;

import java.io.IOException;
import java.io.InputStream;

public final class LineAppendingInputStream
extends InputStream {
    private InputStream originalInputStream;
    private InputStream eolInputStream;
    private InputStream currentInputStream;
    private int lastChar = -1;

    public LineAppendingInputStream(InputStream streamToWrap) {
        this.originalInputStream = streamToWrap;
        this.eolInputStream = new EOLInputStream();
        this.currentInputStream = this.originalInputStream;
    }

    public int read() throws IOException {
        int result = this.currentInputStream.read();
        if (result == -1 && this.currentInputStream == this.originalInputStream && !this.isEOL(this.lastChar)) {
            this.currentInputStream = this.eolInputStream;
            result = this.currentInputStream.read();
        } else {
            this.lastChar = result;
        }
        return result;
    }

    private boolean isEOL(int c) {
        return c == 10 || c == 13;
    }

    private static class EOLInputStream
    extends InputStream {
        private static final byte[] EOL = System.getProperty("line.separator").getBytes();
        private int eolByte = 0;

        private EOLInputStream() {
        }

        public int read() throws IOException {
            return this.eolByte < EOL.length ? EOL[this.eolByte++] : -1;
        }
    }
}

