/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.GenericASTVisitor;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranResourceRefactoring;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

public class KeywordCaseRefactoring
extends FortranResourceRefactoring {
    private boolean lowerCase = true;

    public String getName() {
        return "Change Keyword Case";
    }

    public void setLowerCase(boolean value) {
        this.lowerCase = value;
    }

    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        this.removeFixedFormFilesFrom(this.selectedFiles, status);
        this.removeCpreprocessedFilesFrom(this.selectedFiles, status);
    }

    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        try {
            for (IFile file : this.selectedFiles) {
                IFortranAST ast = (IFortranAST)((PhotranVPG)this.vpg).acquirePermanentAST(file);
                if (ast == null) {
                    status.addError("One of the selected files (" + file.getName() + ") cannot be parsed.");
                }
                this.makeChangesTo(file, ast, status, pm);
                ((PhotranVPG)this.vpg).releaseAST(file);
            }
        }
        finally {
            ((PhotranVPG)this.vpg).releaseAllASTs();
        }
    }

    private void makeChangesTo(IFile file, IFortranAST ast, RefactoringStatus status, IProgressMonitor pm) throws Error {
        try {
            if (ast == null) {
                return;
            }
            CaseChangingVisitor replacer = new CaseChangingVisitor();
            replacer.lowerCase = this.lowerCase;
            ast.accept(replacer);
            if (replacer.changedAST) {
                this.addChangeFromModifiedAST(file, pm);
            }
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
    }

    private static final class CaseChangingVisitor
    extends GenericASTVisitor {
        private boolean changedAST = false;
        private boolean lowerCase;

        private CaseChangingVisitor() {
        }

        public void visitToken(Token node) {
            Terminal term = node.getTerminal();
            if (term != Terminal.T_IDENT && term != Terminal.T_PCON && term != Terminal.T_FCON && term != Terminal.T_BCON && term != Terminal.T_ZCON && term != Terminal.T_SCON && term != Terminal.T_DCON && term != Terminal.T_XCON && term != Terminal.T_OCON && term != Terminal.T_HCON) {
                this.changeCaseOf(node);
            }
        }

        private void changeCaseOf(Token node) {
            if (this.lowerCase) {
                node.findFirstToken().setText(node.getText().toLowerCase());
            } else {
                node.findFirstToken().setText(node.getText().toUpperCase());
            }
            this.changedAST = true;
        }
    }
}

