/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring.infrastructure;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranResourceRefactoring;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.refactorings.IEditorRefactoring;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FortranEditorRefactoring
extends FortranResourceRefactoring
implements IEditorRefactoring {
    protected IFile fileInEditor;
    protected ITextSelection selectedRegionInEditor;
    protected IFortranAST astOfFileInEditor;

    public final void initialize(List<IFile> files) {
        throw new IllegalArgumentException("#initialize(List) cannot be invoked on VPGEditorRefactoring");
    }

    public void initialize(IFile file, ITextSelection selection) {
        if (file == null) {
            throw new IllegalArgumentException("file argument cannot be null");
        }
        super.initialize(Collections.singletonList(file));
        this.fileInEditor = file;
        this.selectedRegionInEditor = selection;
        this.astOfFileInEditor = null;
    }

    public void initialize(IFile file) {
        this.initialize(file, null);
    }

    protected void checkFiles(RefactoringStatus status) throws VPGRefactoring.PreconditionFailure {
        assert (this.fileInEditor != null);
        this.checkIfFileIsAccessibleAndWritable(this.fileInEditor);
        this.astOfFileInEditor = (IFortranAST)((PhotranVPG)this.vpg).acquireTransientAST(this.fileInEditor);
        this.logVPGErrors(status, this.fileInEditor);
        if (this.astOfFileInEditor == null) {
            this.fail("The file in the editor cannot be parsed.");
        }
    }

    @Override
    protected void ensureProjectHasRefactoringEnabled(RefactoringStatus status) throws VPGRefactoring.PreconditionFailure {
        if (!PhotranVPG.getInstance().doesProjectHaveRefactoringEnabled(this.fileInEditor)) {
            this.fail("Please enable analysis and refactoring in the project properties.");
        }
    }
}

