/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public class CPPASTParameterDeclaration
extends ASTNode
implements ICPPASTParameterDeclaration,
IASTAmbiguityParent {
    private IASTDeclSpecifier fDeclSpec;
    private ICPPASTDeclarator fDeclarator;

    public CPPASTParameterDeclaration() {
    }

    public CPPASTParameterDeclaration(IASTDeclSpecifier declSpec, IASTDeclarator declarator) {
        this.setDeclSpecifier(declSpec);
        this.setDeclarator(declarator);
    }

    public boolean isParameterPack() {
        return this.fDeclarator != null && CPPVisitor.findInnermostDeclarator(this.fDeclarator).declaresParameterPack();
    }

    public CPPASTParameterDeclaration copy() {
        CPPASTParameterDeclaration copy = new CPPASTParameterDeclaration();
        copy.setDeclSpecifier(this.fDeclSpec == null ? null : this.fDeclSpec.copy());
        copy.setDeclarator(this.fDeclarator == null ? null : this.fDeclarator.copy());
        copy.setOffsetAndLength(this);
        return copy;
    }

    public IASTDeclSpecifier getDeclSpecifier() {
        return this.fDeclSpec;
    }

    public ICPPASTDeclarator getDeclarator() {
        return this.fDeclarator;
    }

    public void setDeclSpecifier(IASTDeclSpecifier declSpec) {
        this.assertNotFrozen();
        this.fDeclSpec = declSpec;
        if (declSpec != null) {
            declSpec.setParent(this);
            declSpec.setPropertyInParent(DECL_SPECIFIER);
        }
    }

    public void setDeclarator(IASTDeclarator declarator) {
        this.assertNotFrozen();
        if (declarator instanceof ICPPASTDeclarator) {
            this.fDeclarator = (ICPPASTDeclarator)declarator;
            declarator.setParent(this);
            declarator.setPropertyInParent(DECLARATOR);
        } else {
            this.fDeclarator = null;
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitParameterDeclarations) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.fDeclSpec != null && !this.fDeclSpec.accept(action)) {
            return false;
        }
        if (this.fDeclarator != null && !this.fDeclarator.accept(action)) {
            return false;
        }
        if (action.shouldVisitParameterDeclarations) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.fDeclarator) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.fDeclarator = (ICPPASTDeclarator)other;
        }
    }
}

