/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.properties;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.photran.internal.core.properties.SearchPathProperties;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.ui.FortranUIPlugin;
import org.eclipse.photran.internal.ui.properties.FortranBooleanFieldEditor;
import org.eclipse.photran.internal.ui.properties.FortranPropertyPage;
import org.eclipse.photran.internal.ui.properties.WorkspacePathEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SearchPathsPropertyPage
extends FortranPropertyPage {
    private FortranBooleanFieldEditor enableVPG;
    private FortranBooleanFieldEditor enableDeclView;
    private FortranBooleanFieldEditor enableContentAssist;
    private FortranBooleanFieldEditor enableHoverTip;
    private WorkspacePathEditor modulePathEditor;
    private WorkspacePathEditor includePathEditor;
    private SearchPathProperties properties;

    protected Control createContents(Composite parent) {
        IProject proj = (IProject)this.getElement();
        this.properties = new SearchPathProperties(proj);
        IPreferenceStore scopedStore = this.properties.getPropertyStore();
        scopedStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SearchPathsPropertyPage.this.setDirty();
            }
        });
        final Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        Label l = new Label(composite, 64);
        l.setText("To enable Open Declaration, Find All References, the Fortran Declaration\nview, content assist, and refactoring in Fortran programs, check the\nfollowing box.  A program database (index) will be updated every time\na Fortran file is created or saved.");
        l.setLayoutData((Object)new GridData(4, 128, true, false));
        this.enableVPG = new FortranBooleanFieldEditor("EnableVPG", "Enable Fortran analysis/refactoring", composite){

            protected void valueChanged(boolean oldValue, boolean newValue) {
                SearchPathsPropertyPage.this.enableDeclView.setEnabled(newValue, composite);
                SearchPathsPropertyPage.this.enableContentAssist.setEnabled(newValue, composite);
                SearchPathsPropertyPage.this.enableHoverTip.setEnabled(newValue, composite);
                SearchPathsPropertyPage.this.enableDeclView.setValue(newValue);
                SearchPathsPropertyPage.this.enableContentAssist.setValue(newValue);
                SearchPathsPropertyPage.this.enableHoverTip.setValue(newValue);
            }
        };
        this.enableVPG.setPreferenceStore(scopedStore);
        this.enableVPG.load();
        this.properties.setProperty(proj, "EnableVPG", String.valueOf(this.enableVPG.getBooleanValue()));
        this.enableDeclView = new FortranBooleanFieldEditor("EnableDeclView", "Enable Fortran Declaration view", composite);
        this.enableDeclView.setPreferenceStore(scopedStore);
        this.enableDeclView.load();
        this.enableContentAssist = new FortranBooleanFieldEditor("EnableContentAssist", "Enable Fortran content assist (Ctrl+Space)", composite);
        this.enableContentAssist.setPreferenceStore(scopedStore);
        this.enableContentAssist.load();
        this.enableHoverTip = new FortranBooleanFieldEditor("EnableHoverTip", "Enable Fortran Hover tips", composite);
        this.enableHoverTip.setPreferenceStore(scopedStore);
        this.enableHoverTip.load();
        this.enableDeclView.setEnabled(this.enableVPG.getBooleanValue(), composite);
        this.enableContentAssist.setEnabled(this.enableVPG.getBooleanValue(), composite);
        this.enableHoverTip.setEnabled(this.enableVPG.getBooleanValue(), composite);
        l = new Label(composite, 64);
        l.setLayoutData((Object)new GridData(4, 128, true, true));
        l = new Label(composite, 64);
        l.setText("The following specify the paths searched for modules\nand INCLUDE files during analysis and refactoring.\nThese MAY BE DIFFERENT from the settings used by\nyour compiler to build your project.");
        l.setLayoutData((Object)new GridData(4, 128, true, false));
        this.modulePathEditor = new WorkspacePathEditor((IProject)this.getElement(), "FortranModulePaths", "Folders to be searched for &modules, in order of preference:", "Select a folder to be searched for Fortran modules:", composite);
        this.modulePathEditor.setPreferenceStore(scopedStore);
        this.modulePathEditor.load();
        this.includePathEditor = new WorkspacePathEditor((IProject)this.getElement(), "FortranIncludePaths", "Folders to be searched for &INCLUDE files, in order of preference:", "Select a folder to be searched for INCLUDE files:", composite);
        this.includePathEditor.setPreferenceStore(scopedStore);
        this.includePathEditor.load();
        return composite;
    }

    public void performDefaults() {
        this.enableVPG.loadDefault();
        this.enableDeclView.loadDefault();
        this.enableContentAssist.loadDefault();
        this.enableHoverTip.loadDefault();
        this.modulePathEditor.loadDefault();
        this.includePathEditor.loadDefault();
    }

    public boolean doPerformOk() {
        this.enableVPG.store();
        this.enableDeclView.store();
        this.enableContentAssist.store();
        this.enableHoverTip.store();
        this.modulePathEditor.store();
        this.includePathEditor.store();
        try {
            this.properties.save();
        }
        catch (IOException e) {
            FortranUIPlugin.log((Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error Saving Project Properties", (String)("The project properties could not be saved.\n" + e.getClass().getName() + ": " + e.getMessage()));
        }
        PhotranVPG.getInstance().queueJobToEnsureVPGIsUpToDate();
        return true;
    }
}

