/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.ui;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.Workbench;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UIUtil {
    private UIUtil() {
    }

    public static File createTempFile() throws IOException {
        File tempFile = File.createTempFile("rephraser-tmp", ".txt");
        tempFile.deleteOnExit();
        return tempFile;
    }

    public static PrintStream createPrintStream(File tempFile) throws FileNotFoundException {
        return new PrintStream(new BufferedOutputStream(new FileOutputStream(tempFile)));
    }

    public static void openHtmlViewerOn(String title, String str) {
        try {
            File temp = UIUtil.createTempFile();
            PrintStream text = UIUtil.createPrintStream(temp);
            text.print(str);
            text.close();
            UIUtil.openHtmlViewerOn(title, temp);
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)UIUtil.determineActiveShell(), (String)"Error", (String)("Unable to create temporary file.\n\n" + e.getMessage()));
        }
    }

    public static void openHtmlViewerOn(String title, File file) {
        final class HtmlRunnable
        implements Runnable {
            private final /* synthetic */ String val$title;
            private final /* synthetic */ File val$file;

            HtmlRunnable(String string, File file) {
                this.val$title = string;
                this.val$file = file;
            }

            public void run() {
                try {
                    PlatformUI.getWorkbench().getBrowserSupport().createBrowser(0, null, this.val$title, null).openURL(this.val$file.toURI().toURL());
                }
                catch (Throwable e) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openError((Shell)UIUtil.determineActiveShell(), (String)"Error", (String)("Unable to open Web browser.\n\n" + e.getMessage()));
                        }
                    });
                }
            }
        }
        Display.getDefault().syncExec((Runnable)new HtmlRunnable(title, file));
    }

    public static Shell determineActiveShell() {
        if (Workbench.getInstance().getWorkbenchWindowCount() == 0) {
            return null;
        }
        return Workbench.getInstance().getActiveWorkbenchWindow().getShell();
    }

    public static void displayErrorDialog(String message) {
        MessageDialog.openError((Shell)UIUtil.determineActiveShell(), (String)"Error", (String)message);
    }

    public static void displayInfoDialog(String message) {
        MessageDialog.openInformation((Shell)UIUtil.determineActiveShell(), (String)"Note", (String)message);
    }

    public static IEditorPart[] getDirtyEditors() {
        IWorkbenchWindow window = Workbench.getInstance().getActiveWorkbenchWindow();
        if (window == null) {
            return new IEditorPart[0];
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return new IEditorPart[0];
        }
        return page.getDirtyEditors();
    }

    public static boolean askUserToSaveModifiedFiles() {
        return UIUtil.askUserToSaveModifiedFiles(null);
    }

    public static boolean askUserToSaveModifiedFiles(IFile fileInEditor) {
        return UIUtil.askUserToSaveModifiedFiles(Collections.singletonList(fileInEditor));
    }

    public static boolean askUserToSaveModifiedFiles(List<IFile> filesToCheck) {
        return UIUtil.askUserToSaveModifiedFiles(filesToCheck, UIUtil.getDirtyEditors());
    }

    public static boolean askUserToSaveModifiedFiles(List<IFile> filesToCheck, IEditorPart[] dirtyEditors) {
        boolean promptUser = true;
        int i = 0;
        while (i < dirtyEditors.length) {
            IEditorInput editorInput = dirtyEditors[i].getEditorInput();
            if (editorInput instanceof IFileEditorInput) {
                IPath fullPath;
                IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
                IFile file = fileEditorInput.getFile();
                IPath iPath = fullPath = file == null ? null : file.getFullPath();
                if (fullPath != null && UIUtil.hasFile(filesToCheck, fullPath) && dirtyEditors[i].isDirty()) {
                    if (!UIUtil.promptUser(promptUser)) {
                        return false;
                    }
                    UIUtil.saveFileInEditorIfDirty(dirtyEditors[i]);
                    promptUser = false;
                }
            }
            ++i;
        }
        return true;
    }

    private static boolean hasFile(List<IFile> files, IPath fullPath) {
        if (files == null) {
            return true;
        }
        for (IFile f : files) {
            IPath fileFullPath = f.getFullPath();
            if (fileFullPath == null || !fileFullPath.equals((Object)fullPath)) continue;
            return true;
        }
        return false;
    }

    private static boolean promptUser(boolean shouldPrompt) {
        boolean userSelection = true;
        if (shouldPrompt) {
            userSelection = MessageDialog.openConfirm(null, (String)"Save Files Before Refactoring", (String)"Some file(s) currently being edited have unsaved changes; these must be saved before the refactoring can proceed.\n\nDo you want to save these changes?");
        }
        return userSelection;
    }

    private static void saveFileInEditorIfDirty(IEditorPart editor) {
        if (editor.isDirty()) {
            editor.doSave(null);
        }
    }
}

