/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.ui.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.part.FileEditorInput;

public class SearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    private ISearchQuery query;

    public SearchResult(ISearchQuery query) {
        this.query = query;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getLabel() {
        return this.getQuery().getLabel();
    }

    public ISearchQuery getQuery() {
        return this.query;
    }

    public String getTooltip() {
        return "Search Result";
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        return this.getMatches(file);
    }

    public IFile getFile(Object element) {
        return (IFile)element;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        IPath path = this.getFileName(editor);
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        return this.getMatches(res);
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        IPath path = this.getFileName(editor);
        return path != null && path.equals((Object)((IFile)match.getElement()).getLocation());
    }

    private IPath getFileName(IEditorPart editor) {
        ILocationProvider provider;
        IEditorInput input = editor.getEditorInput();
        if (input instanceof FileEditorInput) {
            FileEditorInput fileInput = (FileEditorInput)input;
            return fileInput.getFile().getLocation();
        }
        if (input instanceof IStorageEditorInput) {
            try {
                IStorage storage = ((IStorageEditorInput)input).getStorage();
                if (storage.getFullPath() != null) {
                    return storage.getFullPath();
                }
            }
            catch (CoreException coreException) {}
        } else if (input instanceof IPathEditorInput) {
            return ((IPathEditorInput)input).getPath();
        }
        if ((provider = (ILocationProvider)input.getAdapter(ILocationProvider.class)) != null) {
            return provider.getPath((Object)input);
        }
        return null;
    }
}

