/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.lexer.preprocessor.fortran_include;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.photran.internal.core.lexer.LineReader;
import org.eclipse.photran.internal.core.lexer.SingleCharReader;
import org.eclipse.photran.internal.core.lexer.preprocessor.fortran_include.FortranIncludeDirective;
import org.eclipse.photran.internal.core.lexer.preprocessor.fortran_include.IncludeLoaderCallback;

public final class FortranPreprocessor
extends SingleCharReader {
    private static final Pattern INCLUDE_LINE = Pattern.compile("[ \t]*[Ii][Nn][Cc][Ll][Uu][Dd][Ee][ \t]+[\"']([^\r\n\"]*)[\"'][ \t]*(![^\r\n]*)?[\r\n]*");
    private static final int INCLUDE_LINE_CAPTURING_GROUP_OF_FILENAME = 1;
    private IncludeLoaderCallback callback;
    private IFile topLevelFile;
    private StreamStack streamStack;
    private int offset = 0;
    private int line = 1;
    private LinkedList<FortranIncludeDirective> directivesInTopLevelFile;
    private ArrayList<Integer> directiveStartOffsets;
    private LinkedList<String> fileNames;
    private ArrayList<Integer> fileStartOffsets;
    private ArrayList<Integer> fileStartOffsetAdjustments;
    private ArrayList<Integer> fileStartLines;
    private ArrayList<Integer> fileStartLineAdjustments;

    public FortranPreprocessor(Reader readFrom, IFile file, String filename, IncludeLoaderCallback callback) throws IOException {
        this.topLevelFile = file;
        this.callback = callback;
        this.streamStack = new StreamStack();
        this.streamStack.push(new LineReader(readFrom, filename));
        this.directivesInTopLevelFile = new LinkedList();
        this.directivesInTopLevelFile.add(null);
        this.directiveStartOffsets = new ArrayList();
        this.directiveStartOffsets.add(new Integer(0));
        this.fileNames = new LinkedList();
        this.fileNames.add(filename);
        this.fileStartOffsets = new ArrayList();
        this.fileStartOffsets.add(new Integer(0));
        this.fileStartOffsetAdjustments = new ArrayList();
        this.fileStartOffsetAdjustments.add(new Integer(0));
        this.fileStartLines = new ArrayList();
        this.fileStartLines.add(new Integer(1));
        this.fileStartLineAdjustments = new ArrayList();
        this.fileStartLineAdjustments.add(new Integer(0));
    }

    public String getFilenameAtOffset(int offset) {
        int i = this.fileStartOffsets.size() - 1;
        while (i >= 0) {
            if (this.fileStartOffsets.get(i) <= offset) {
                return this.fileNames.get(i);
            }
            --i;
        }
        return null;
    }

    public int getStartOffsetOfFileContainingStreamOffset(int offset) {
        int i = this.fileStartOffsets.size() - 1;
        while (i >= 0) {
            int fileStartOffset = this.fileStartOffsets.get(i);
            if (fileStartOffset <= offset) {
                return fileStartOffset;
            }
            --i;
        }
        throw new IllegalArgumentException();
    }

    public FortranIncludeDirective getDirectiveAtOffset(int offset) {
        int i = this.directiveStartOffsets.size() - 1;
        while (i >= 0) {
            if (this.directiveStartOffsets.get(i) <= offset) {
                return this.directivesInTopLevelFile.get(i);
            }
            --i;
        }
        throw new IllegalArgumentException();
    }

    public int getFileLineFromStreamLine(int line) {
        int i = this.fileStartLines.size() - 1;
        while (i >= 0) {
            if (this.fileStartLines.get(i) <= line) {
                return line - this.fileStartLineAdjustments.get(i);
            }
            --i;
        }
        throw new IllegalArgumentException();
    }

    public int getFileOffsetFromStreamOffset(int offset) {
        int i = this.fileStartOffsets.size() - 1;
        while (i >= 0) {
            if (this.fileStartOffsets.get(i) <= offset) {
                return offset - this.fileStartOffsetAdjustments.get(i);
            }
            --i;
        }
        throw new IllegalArgumentException();
    }

    public int read() throws IOException {
        int result;
        LineReader currentStream = this.streamStack.topStream;
        if (currentStream.atBOL()) {
            this.checkForInclude();
        }
        if ((currentStream = this.streamStack.topStream).atEOF()) {
            this.finishInclude();
        }
        if ((result = currentStream.read()) >= 0) {
            ++this.offset;
            if (result == 10) {
                ++this.line;
            }
        }
        return result;
    }

    private boolean inTopLevelFile() {
        return this.streamStack.size() <= 1;
    }

    private void checkForInclude() throws FileNotFoundException, IOException {
        Matcher m = INCLUDE_LINE.matcher(this.streamStack.topStream);
        if (m.matches()) {
            LineReader origStream = this.streamStack.topStream;
            String includeLine = origStream.currentLine();
            String fileToInclude = m.group(1);
            Reader newStream = this.findIncludedFile(fileToInclude);
            if (newStream != null) {
                if (this.inTopLevelFile()) {
                    this.directivesInTopLevelFile.add(new FortranIncludeDirective(includeLine));
                    this.directiveStartOffsets.add(new Integer(this.offset));
                }
                origStream.setRestartOffset(this.offset + includeLine.length());
                origStream.setRestartLine(this.line + 1);
                this.streamStack.push(new LineReader(newStream, fileToInclude, this.offset, this.line));
                this.fileNames.add(fileToInclude);
                this.fileStartOffsets.add(new Integer(this.offset));
                this.fileStartOffsetAdjustments.add(new Integer(this.getOffsetAdjustment(0)));
                this.fileStartLines.add(new Integer(this.line));
                this.fileStartLineAdjustments.add(new Integer(this.getLineAdjustment(1)));
                origStream.advanceToNextLine();
            }
        }
    }

    protected Reader findIncludedFile(String fileToInclude) throws IOException {
        if (this.callback == null) {
            return null;
        }
        try {
            return this.callback.getIncludedFileAsStream(fileToInclude);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.callback.logError("Unable to locate INCLUDE file \"" + fileToInclude + "\"", this.topLevelFile, this.offset);
            return null;
        }
    }

    private void finishInclude() throws IOException {
        if (!this.inTopLevelFile()) {
            this.streamStack.topStream.close();
            this.streamStack.pop();
            this.fileNames.add(this.streamStack.topStream.getFilename());
            this.fileStartOffsets.add(new Integer(this.offset));
            this.fileStartOffsetAdjustments.add(new Integer(this.getOffsetAdjustment(this.streamStack.topStream.getRestartOffset())));
            this.fileStartLines.add(new Integer(this.line));
            this.fileStartLineAdjustments.add(new Integer(this.getLineAdjustment(this.streamStack.topStream.getRestartLine())));
        }
        if (this.inTopLevelFile()) {
            this.directivesInTopLevelFile.add(null);
            this.directiveStartOffsets.add(new Integer(this.offset));
        }
    }

    private int getOffsetAdjustment(int desiredOffset) {
        return this.offset - desiredOffset;
    }

    private int getLineAdjustment(int desiredLine) {
        return this.line - desiredLine;
    }

    public IFile getTopLevelFile() {
        return this.topLevelFile;
    }

    public void close() throws IOException {
        this.streamStack.topStream.close();
    }

    private static final class StreamStack {
        private Stack<LineReader> streamStack = new Stack();
        private LineReader topStream = null;

        private StreamStack() {
        }

        public void push(LineReader lineReader) {
            this.streamStack.push(lineReader);
            this.topStream = lineReader;
        }

        public int size() {
            return this.streamStack.size();
        }

        public void pop() {
            this.streamStack.pop();
            this.topStream = this.streamStack.isEmpty() ? null : this.streamStack.peek();
        }
    }
}

