/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.vpg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.analysis.binding.Binder;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ImplicitSpec;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.lexer.ASTLexerFactory;
import org.eclipse.photran.internal.core.lexer.FixedFormReplacement;
import org.eclipse.photran.internal.core.lexer.IAccumulatingLexer;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.lexer.preprocessor.fortran_include.IncludeLoaderCallback;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.parser.ASTNodeWithErrorRecoverySymbols;
import org.eclipse.photran.internal.core.sourceform.ISourceForm;
import org.eclipse.photran.internal.core.sourceform.SourceForm;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.vpg.TokenRef;
import org.eclipse.rephraserengine.core.vpg.VPG;
import org.eclipse.rephraserengine.core.vpg.VPGDependency;
import org.eclipse.rephraserengine.core.vpg.VPGEdge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhotranVPGBuilder
extends PhotranVPG {
    protected PhotranVPGBuilder() {
    }

    public void markFileAsExportingSubprogram(IFile file, String subprogramName) {
        this.db.ensure(new VPGDependency((VPG)this, "subprogram:" + PhotranVPGBuilder.canonicalizeIdentifier(subprogramName), PhotranVPGBuilder.getFilenameForIFile((IFile)file)));
    }

    public void markFileAsImportingSubprogram(IFile file, String subprogramName) {
        this.db.ensure(new VPGDependency((VPG)this, PhotranVPGBuilder.getFilenameForIFile((IFile)file), "subprogram:" + PhotranVPGBuilder.canonicalizeIdentifier(subprogramName)));
    }

    public void markFileAsExportingModule(IFile file, String moduleName) {
        this.db.ensure(new VPGDependency((VPG)this, "module:" + PhotranVPGBuilder.canonicalizeIdentifier(moduleName), PhotranVPGBuilder.getFilenameForIFile((IFile)file)));
    }

    public void markFileAsImportingModule(IFile file, String moduleName) {
        this.db.ensure(new VPGDependency((VPG)this, PhotranVPGBuilder.getFilenameForIFile((IFile)file), "module:" + PhotranVPGBuilder.canonicalizeIdentifier(moduleName)));
    }

    public void markFileAsUsingCommonBlock(IFile file, String commonBlockName) {
        this.db.ensure(new VPGDependency((VPG)this, PhotranVPGBuilder.getFilenameForIFile((IFile)file), "common:" + PhotranVPGBuilder.canonicalizeIdentifier(commonBlockName)));
    }

    public void setDefinitionFor(PhotranTokenRef tokenRef, Definition definition) {
        this.db.setAnnotation(tokenRef, 3, definition);
    }

    public void markDefinitionVisibilityInScope(PhotranTokenRef definitionTokenRef, ScopingNode scope, Definition.Visibility visibility) {
        VPGEdge privateEdge = new VPGEdge((VPG)this, (TokenRef)definitionTokenRef, (TokenRef)scope.getRepresentativeToken(), 4);
        if (visibility.equals((Object)Definition.Visibility.PRIVATE)) {
            this.db.ensure(privateEdge);
        } else {
            this.db.delete(privateEdge);
        }
    }

    public void markScope(PhotranTokenRef identifier, ScopingNode scope) {
        this.db.ensure(new VPGEdge((VPG)this, (TokenRef)identifier, (TokenRef)scope.getRepresentativeToken(), 0));
    }

    public void markIllegalShadowing(PhotranTokenRef shadowingIdent, PhotranTokenRef shadowedIdent) {
        this.db.ensure(new VPGEdge((VPG)this, (TokenRef)shadowingIdent, (TokenRef)shadowedIdent, 5));
    }

    public void markBinding(PhotranTokenRef reference, PhotranTokenRef definition) {
        this.db.ensure(new VPGEdge((VPG)this, (TokenRef)reference, (TokenRef)definition, 2));
    }

    public void markRenamedBinding(PhotranTokenRef reference, PhotranTokenRef definition) {
        this.db.ensure(new VPGEdge((VPG)this, (TokenRef)reference, (TokenRef)definition, 3));
    }

    public void setScopeImplicitSpec(ScopingNode scope, ImplicitSpec implicitSpec) {
        if (implicitSpec != null) {
            this.db.setAnnotation(scope.getRepresentativeToken(), 2, implicitSpec);
        } else {
            this.db.deleteAnnotation(scope.getRepresentativeToken(), 2);
        }
    }

    public void setDefaultScopeVisibilityToPrivate(ScopingNode scope) {
        this.db.setAnnotation(scope.getRepresentativeToken(), 0, Boolean.TRUE);
    }

    public void setModuleSymbolTable(Token moduleNameToken, List<Definition> symbolTable) {
        this.clearModuleSymbolTableEntries(moduleNameToken);
        String filename = "module:" + PhotranVPGBuilder.canonicalizeIdentifier(moduleNameToken.getText());
        PhotranTokenRef tokenRef = this.createTokenRef(filename, 0, 0);
        this.db.setAnnotation(tokenRef, 5, moduleNameToken.getTokenRef());
        int entries = 0;
        for (Definition def : symbolTable) {
            tokenRef = this.createTokenRef(filename, entries++, 0);
            this.db.setAnnotation(tokenRef, 7, def);
        }
        tokenRef = this.createTokenRef(filename, 0, 0);
        this.db.setAnnotation(tokenRef, 6, Integer.valueOf(entries));
    }

    private void clearModuleSymbolTableEntries(Token moduleNameToken) {
        String canonicalizedModuleName = PhotranVPGBuilder.canonicalizeIdentifier(moduleNameToken.getText());
        this.moduleSymTabCache.remove(canonicalizedModuleName);
        int entries = this.countModuleSymbolTableEntries(canonicalizedModuleName);
        if (entries > 0) {
            String filename = "module:" + canonicalizedModuleName;
            int i = 0;
            while (i < entries) {
                PhotranTokenRef tokenRef = this.createTokenRef(filename, i, 0);
                this.db.deleteAnnotation(tokenRef, 7);
                ++i;
            }
            PhotranTokenRef tokenRef = this.createTokenRef(filename, 0, 0);
            this.db.setAnnotation(tokenRef, 6, Integer.valueOf(0));
        }
    }

    public boolean isVirtualFile(String filename) {
        return filename.startsWith("module:") || filename.startsWith("common:") || filename.startsWith("subprogram:");
    }

    public PhotranTokenRef createTokenRef(String filename, int offset, int length) {
        return new PhotranTokenRef(filename, offset, length);
    }

    protected void calculateDependencies(String filename) {
        if (this.isVirtualFile(filename)) {
            return;
        }
        ISourceForm sourceForm = this.determineSourceForm(filename);
        try {
            IAccumulatingLexer lexer = new ASTLexerFactory().createLexer(PhotranVPGBuilder.getIFileForFilename((String)filename), sourceForm);
            long start = System.currentTimeMillis();
            this.calculateDependencies(filename, lexer);
            this.debug("  - Elapsed time in calculateDependencies: " + (System.currentTimeMillis() - start) + " ms", filename);
        }
        catch (Exception e) {
            this.log.logError((Throwable)e, (TokenRef)new PhotranTokenRef(filename, 0, 0));
        }
    }

    private ISourceForm determineSourceForm(final String filename) {
        IFile file = PhotranVPGBuilder.getIFileForFilename((String)filename);
        return SourceForm.of((IFile)file).configuredWith((Object)new IncludeLoaderCallback(file.getProject()){

            public Reader getIncludedFileAsStream(String fileToInclude) throws FileNotFoundException {
                PhotranVPGBuilder.this.db.ensure(new VPGDependency((VPG)PhotranVPGBuilder.this, filename, PhotranVPGBuilder.getFilenameForIFile((IFile)this.getIncludedFile(fileToInclude))));
                return super.getIncludedFileAsStream(fileToInclude);
            }

            public void logError(String message, IFile topLevelFile, int offset) {
                PhotranVPG.getInstance().log.clearEntriesFor(PhotranVPG.getFilenameForIFile((IFile)topLevelFile));
                PhotranVPG.getInstance().log.logError(message, (TokenRef)new PhotranTokenRef(topLevelFile, offset, 0));
            }
        });
    }

    private void calculateDependencies(String filename, IAccumulatingLexer lexer) {
        if (!this.isVirtualFile(filename)) {
            this.db.deleteAllIncomingDependenciesFor(filename);
            this.db.deleteAllOutgoingDependenciesFor(filename);
        }
        if (lexer == null) {
            return;
        }
        try {
            this.calculateFileDepsFromModuleAndUseStmts(filename, lexer);
        }
        catch (Exception e) {
            this.log.logError((Throwable)e);
        }
    }

    private void calculateFileDepsFromModuleAndUseStmts(String filename, IAccumulatingLexer lexer) throws Exception {
        IFile file = PhotranVPGBuilder.getIFileForFilename((String)filename);
        int state = 0;
        Token tok = lexer.yylex();
        while (tok != null && tok.getTerminal() != Terminal.END_OF_INPUT) {
            if (state == 0 && tok.getTerminal() == Terminal.T_USE) {
                state = 1;
            } else if (state == 0 && tok.getTerminal() == Terminal.T_MODULE) {
                state = 2;
            } else if (state == 1) {
                if (tok.getTerminal() == Terminal.T_IDENT) {
                    this.markFileAsImportingModule(file, tok.getText());
                }
                state = 0;
            } else if (state == 2) {
                if (tok.getTerminal() == Terminal.T_IDENT) {
                    this.markFileAsExportingModule(file, tok.getText());
                }
                state = 0;
            }
            tok = lexer.yylex();
        }
    }

    protected void doCommitChangeFromAST(String filename) {
        if (this.isVirtualFile(filename)) {
            return;
        }
        IFortranAST ast = (IFortranAST)this.acquireTransientAST(filename);
        if (ast == null) {
            throw new IllegalArgumentException(String.valueOf(filename) + " returned null AST");
        }
        try {
            String charset = Charset.defaultCharset().name();
            ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
            ast.getRoot().printOn(new PrintStream((OutputStream)out, false, charset), null);
            ast = this.parse(filename, new InputStreamReader((InputStream)new ByteArrayInputStream(out.toByteArray()), charset));
            this.computeEdgesAndAnnotations(filename, ast);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    public String getSourceCodeFromAST(IFortranAST ast) {
        return ast.getRoot().toString();
    }

    protected IFortranAST parse(String filename) {
        return this.parse(filename, null);
    }

    /*
     * Exception decompiling
     */
    private IFortranAST parse(String filename, Reader stream) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkForErrors(ASTExecutableProgramNode ast, String filename) {
        ASTNodeWithErrorRecoverySymbols firstError = PhotranVPGBuilder.findFirstErrorIn(ast);
        if (firstError != null) {
            PhotranTokenRef errorTokenRef = this.getErrorTokenRef(filename, firstError.getErrorToken());
            this.log.clearEntriesFor(filename);
            this.log.logError(String.valueOf(filename) + " contains syntax errors and may not be refactored correctly.", (TokenRef)errorTokenRef);
        }
    }

    private PhotranTokenRef getErrorTokenRef(String filename, Token errorToken) {
        if (this.isPreprocessed(errorToken)) {
            return null;
        }
        return new PhotranTokenRef(filename, errorToken.getStreamOffset(), errorToken.getLength());
    }

    private boolean isPreprocessed(Token token) {
        return token.getPreprocessorDirective() != null && !(token.getPreprocessorDirective() instanceof FixedFormReplacement);
    }

    private void logError(IFile file, String message, Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append(message);
        sb.append(": ");
        sb.append(e.getMessage());
        sb.append('\n');
        sb.append(e.getClass().getName());
        sb.append(":\n");
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        e.printStackTrace(new PrintStream(bs));
        sb.append(bs);
        if (file != null) {
            this.log.logError(sb.toString(), (TokenRef)new PhotranTokenRef(file, 0, 0));
        } else {
            this.log.logError(sb.toString());
        }
    }

    protected void populateVPG(String filename, IFortranAST ast) {
        if (!this.isVirtualFile(filename)) {
            this.db.deleteAllIncomingDependenciesFor(filename);
            this.db.deleteAllOutgoingDependenciesFor(filename);
        }
        if (ast == null || PhotranVPGBuilder.isEmpty(ast.getRoot())) {
            return;
        }
        long start = System.currentTimeMillis();
        Binder.bind(ast, PhotranVPGBuilder.getIFileForFilename((String)filename));
        this.debug("  - Elapsed time in Binder#bind: " + (System.currentTimeMillis() - start) + " ms", filename);
    }

    public static boolean isEmpty(ASTExecutableProgramNode ast) {
        return ast.findFirstToken() == null;
    }
}

