/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.vpg;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.rephraserengine.core.vpg.TokenRef;
import org.eclipse.rephraserengine.core.vpg.VPGDB;
import org.eclipse.rephraserengine.core.vpg.VPGEdge;
import org.eclipse.rephraserengine.core.vpg.VPGLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VPG<A, T, R extends TokenRef<T>, D extends VPGDB<A, T, R, L>, L extends VPGLog<T, R>> {
    protected HashMap<String, A> permanentASTs;
    protected HashMap<String, WeakReference<A>> transientASTs;
    protected Object[] transientASTCache;
    private int transientASTCacheIndex = 0;
    public final D db;
    public final VPGLog<T, R> log;

    protected VPG(L log, D database) {
        this(log, database, 5);
    }

    protected VPG(L log, D database, int transientASTCacheSize) {
        assert (transientASTCacheSize > 0);
        this.transientASTs = new HashMap();
        this.permanentASTs = new HashMap();
        this.transientASTCache = new Object[transientASTCacheSize];
        this.log = log;
        this.log.setVPG(this);
        this.db = database;
        ((VPGDB)this.db).setVPG(this);
    }

    public A acquireTransientAST(String filename) {
        return this.acquireTransientAST(filename, false);
    }

    private A acquireTransientAST(String filename, boolean forceRecomputationOfEdgesAndAnnotations) {
        if (this.isVirtualFile(filename) || !this.shouldProcessFile(filename)) {
            return null;
        }
        A ast = null;
        if (!forceRecomputationOfEdgesAndAnnotations) {
            if (this.permanentASTs.containsKey(filename)) {
                ast = this.permanentASTs.get(filename);
            } else if (this.transientASTs.containsKey(filename)) {
                ast = (A)this.transientASTs.get(filename).get();
            }
            if (ast != null) {
                return ast;
            }
        }
        long start = System.currentTimeMillis();
        ast = this.parse(filename);
        long parseTime = System.currentTimeMillis() - start;
        if (ast != null) {
            WeakReference<Object> astRef = new WeakReference<Object>(ast);
            this.transientASTs.put(filename, astRef);
            this.transientASTCache[this.transientASTCacheIndex] = ast;
            this.transientASTCacheIndex = (this.transientASTCacheIndex + 1) % this.transientASTCache.length;
        }
        long computeTime = -1L;
        if (forceRecomputationOfEdgesAndAnnotations || ((VPGDB)this.db).isOutOfDate(filename)) {
            computeTime = this.computeEdgesAndAnnotations(filename, ast);
        }
        this.debug(parseTime, computeTime, filename);
        return ast;
    }

    public A acquirePermanentAST(String filename) {
        A ast = this.acquireTransientAST(filename);
        return this.makeTransientASTPermanent(filename, ast);
    }

    protected long computeEdgesAndAnnotations(String filename, A ast) {
        long start = System.currentTimeMillis();
        this.log.clearEntriesFor(filename);
        ((VPGDB)this.db).deleteAllEdgesAndAnnotationsFor(filename);
        this.populateVPG(filename, ast);
        ((VPGDB)this.db).updateModificationStamp(filename);
        ((VPGDB)this.db).flush();
        return System.currentTimeMillis() - start;
    }

    public List<String> sortFilesAccordingToDependencies(List<String> files, IProgressMonitor monitor) {
        int i = 0;
        while (i < files.size()) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            monitor.subTask("Sorting files according to dependencies - enqueuing dependents (" + i + " of " + files.size() + ")");
            this.enqueueNewDependents(files.get(i), files);
            ++i;
        }
        class DFS {
            final Integer WHITE = 0;
            final Integer GRAY = 1;
            final Integer BLACK = 2;
            final int numFiles;
            ArrayList<String> result;
            HashMap<String, Integer> color;
            int time;
            private final /* synthetic */ IProgressMonitor val$monitor;
            private final /* synthetic */ List val$files;

            DFS(List list, IProgressMonitor iProgressMonitor) {
                this.val$files = list;
                this.val$monitor = iProgressMonitor;
                this.numFiles = list.size();
                this.result = new ArrayList(this.numFiles);
                this.color = new HashMap();
                for (String filename : list) {
                    this.color.put(filename, this.WHITE);
                }
                this.time = 0;
                for (String filename : list) {
                    if (this.color.get(filename) != this.WHITE) continue;
                    this.dfsVisit(filename);
                }
            }

            private void dfsVisit(String u) {
                if (this.val$monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.val$monitor.subTask("Sorting files according to dependencies - sorting dependents of " + u + " (" + this.time + " of " + this.val$files.size() + ")");
                this.color.put(u, this.GRAY);
                ++this.time;
                for (String v : ((VPGDB)VPG.this.db).getIncomingDependenciesTo(u)) {
                    if (this.color.get(v) != this.WHITE) continue;
                    this.dfsVisit(v);
                }
                this.color.put(u, this.BLACK);
                this.result.add(0, u);
            }
        }
        return (VPG)this.new DFS(files, (IProgressMonitor)monitor).result;
    }

    protected void processingDependent(String filename, String dependentFilename) {
        this.debug("- Processing dependent file " + dependentFilename, filename);
    }

    protected void enqueueNewDependents(String filename, List<String> dependents) {
        for (String f : this.findAllFilesDependentUpon(filename)) {
            if (dependents.contains(f)) continue;
            dependents.add(f);
        }
    }

    public void forceRecomputationOfDependencies(String filename) {
        this.calculateDependencies(filename);
    }

    public void forceRecomputationOfEdgesAndAnnotations(String filename) {
        this.releaseAST(filename);
        this.acquireTransientAST(filename, true);
    }

    private Set<String> findAllFilesDependentUpon(String filename) {
        HashSet<String> dependents = new HashSet<String>();
        for (String dependentFilename : ((VPGDB)this.db).getIncomingDependenciesTo(filename)) {
            dependents.add(dependentFilename);
        }
        return dependents;
    }

    public A makeTransientASTPermanent(String filename) {
        return this.makeTransientASTPermanent(filename, this.acquireTransientAST(filename));
    }

    public A makeTransientASTPermanent(String filename, A ast) {
        this.transientASTs.remove(filename);
        this.permanentASTs.put(filename, ast);
        return ast;
    }

    public void releaseAST(String filename) {
        this.transientASTs.remove(filename);
        this.permanentASTs.remove(filename);
    }

    public void releaseAllASTs() {
        this.transientASTs.clear();
        this.permanentASTs.clear();
    }

    public String getFilenameCorrespondingTo(A ast) {
        for (String filename : this.transientASTs.keySet()) {
            if (this.transientASTs.get(filename).get() != ast) continue;
            return filename;
        }
        for (String filename : this.permanentASTs.keySet()) {
            if (this.permanentASTs.get(filename) != ast) continue;
            return filename;
        }
        return null;
    }

    protected abstract boolean shouldProcessFile(String var1);

    public abstract R createTokenRef(String var1, int var2, int var3);

    public VPGEdge<A, T, R> createEdge(R fromRef, R toRef, int type) {
        return new VPGEdge(this, fromRef, toRef, type);
    }

    public final VPGEdge<A, T, R> createEdge(T from, T to, int type) {
        return this.createEdge((T)this.getTokenRef(from), (T)this.getTokenRef(to), type);
    }

    protected abstract void calculateDependencies(String var1);

    public boolean isVirtualFile(String filename) {
        return false;
    }

    protected abstract A parse(String var1);

    protected abstract void populateVPG(String var1, A var2);

    protected abstract R getTokenRef(T var1);

    public abstract T findToken(R var1);

    public void commitChangesFromInMemoryASTs(IProgressMonitor pm, int ticks, String ... filenames) {
        List<String> files = new ArrayList<String>(Arrays.asList(filenames));
        files = this.sortFilesAccordingToDependencies(files, pm);
        pm = new SubProgressMonitor(pm, ticks, 4);
        pm.beginTask("Post-transform analysis:", files.size());
        for (String thisFile : files) {
            pm.subTask(VPG.lastSegmentOfFilename(thisFile));
            this.doCommitChangeFromAST(thisFile);
            pm.worked(1);
        }
        pm.done();
    }

    protected void doCommitChangeFromAST(String filename) {
        if (!this.isVirtualFile(filename)) {
            this.computeEdgesAndAnnotations(filename, this.acquireTransientAST(filename));
        }
    }

    public static String lastSegmentOfFilename(String filename) {
        if (filename == null) {
            return "";
        }
        int lastSlash = filename.lastIndexOf(47);
        int lastBackslash = filename.lastIndexOf(92);
        if (lastSlash < 0 && lastBackslash < 0) {
            return filename;
        }
        return filename.substring(Math.max(lastSlash + 1, lastBackslash + 1));
    }

    public String getSourceCodeFromAST(A ast) {
        return null;
    }

    protected void debug(String message, String filename) {
    }

    protected void debug(long parseTimeMillisec, long computeEdgesAndAnnotationsMillisec, String filename) {
    }

    public void close() {
        ((VPGDB)this.db).close();
    }

    public String describeEdgeType(int edgeType) {
        return "Edge of type " + edgeType;
    }

    public String describeAnnotationType(int annotationType) {
        return "Annotation of type " + annotationType;
    }
}

