/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.vpg.eclipse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.rephraserengine.core.vpg.TokenRef;
import org.eclipse.rephraserengine.core.vpg.VPG;
import org.eclipse.rephraserengine.core.vpg.VPGDB;
import org.eclipse.rephraserengine.core.vpg.eclipse.EclipseVPGLog;
import org.eclipse.rephraserengine.core.vpg.eclipse.VPGJob;
import org.eclipse.rephraserengine.core.vpg.eclipse.VPGSchedulingRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EclipseVPG<A, T, R extends TokenRef<T>, D extends VPGDB<A, T, R, L>, L extends EclipseVPGLog<T, R>>
extends VPG<A, T, R, D, L> {
    private String syncMessage;

    public EclipseVPG(L log, D database, String syncMessage, int transientASTCacheSize) {
        super(log, database, transientASTCacheSize);
        this.syncMessage = syncMessage;
    }

    public EclipseVPG(L log, D database, String syncMessage) {
        super(log, database);
        this.syncMessage = syncMessage;
    }

    public void start() {
        this.log.readLogFromFile();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new VPGResourceChangeListener(), 1);
        this.queueJobToEnsureVPGIsUpToDate();
    }

    public WorkspaceJob queueJobToEnsureVPGIsUpToDate() {
        VPGInitialWorkspaceSyncJob job = new VPGInitialWorkspaceSyncJob(this.syncMessage);
        job.setRule(MultiRule.combine((ISchedulingRule)VPGSchedulingRule.getInstance(), (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot()));
        job.schedule();
        return job;
    }

    public IStatus ensureVPGIsUpToDate(IProgressMonitor monitor) {
        try {
            WorkspaceSyncResourceVisitor visitor = new WorkspaceSyncResourceVisitor();
            this.collectFilesToIndex(visitor, monitor);
            visitor.calculateDependencies(monitor);
            visitor.index(monitor);
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    private void collectFilesToIndex(WorkspaceSyncResourceVisitor visitor, IProgressMonitor monitor) throws CoreException {
        monitor.subTask("Searching for workspace modifications...");
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        workspaceRoot.accept((IResourceVisitor)visitor);
    }

    private int countFilesInQueue(List<String> queue) {
        int total = 0;
        for (String filename : queue) {
            if (!this.shouldListFileInIndexerProgressMessages(filename)) continue;
            ++total;
        }
        return total;
    }

    protected boolean shouldListFileInIndexerProgressMessages(String filename) {
        return !this.isVirtualFile(filename);
    }

    protected void calculateDependenciesIfNotUpToDate(String filename) {
        if (this.db.isOutOfDate(filename)) {
            this.debug("Indexing", filename);
            this.forceRecomputationOfDependencies(filename);
        } else {
            this.debug("Index is up to date", filename);
        }
    }

    protected void indexIfNotUpToDate(String filename) {
        if (this.db.isOutOfDate(filename)) {
            this.debug("Indexing", filename);
            this.forceRecomputationOfEdgesAndAnnotations(filename);
        } else {
            this.debug("Index is up to date", filename);
        }
    }

    @Override
    protected boolean shouldProcessFile(String filename) {
        IFile file = EclipseVPG.getIFileForFilename(filename);
        return file == null ? false : this.shouldProcessFile(file);
    }

    protected abstract boolean shouldProcessProject(IProject var1);

    protected abstract boolean shouldProcessFile(IFile var1);

    public static IFile getIFileForFilename(String filename) {
        IResource resource = EclipseVPG.getIResourceForFilename(filename);
        if (resource instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    public static String getFilenameForIFile(IFile file) {
        return EclipseVPG.getFilenameForIResource((IResource)file);
    }

    public static IResource getIResourceForFilename(String filename) {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(filename);
    }

    public static String getFilenameForIResource(IResource resource) {
        if (resource == null) {
            return null;
        }
        return resource.getFullPath().toString();
    }

    public A acquireTransientAST(IFile file) {
        return file == null ? null : (A)this.acquireTransientAST(EclipseVPG.getFilenameForIFile(file));
    }

    public A acquirePermanentAST(IFile file) {
        return file == null ? null : (A)this.acquirePermanentAST(EclipseVPG.getFilenameForIFile(file));
    }

    public A makeTransientASTPermanent(IFile file) {
        return file == null ? null : (A)this.makeTransientASTPermanent(EclipseVPG.getFilenameForIFile(file));
    }

    public A makeTransientASTPermanent(IFile file, A ast) {
        return file == null ? null : (A)this.makeTransientASTPermanent(EclipseVPG.getFilenameForIFile(file), ast);
    }

    public void releaseAST(IFile file) {
        if (file != null) {
            this.releaseAST(EclipseVPG.getFilenameForIFile(file));
        }
    }

    public IFile getIFileCorrespondingTo(A ast) {
        String filename = this.getFilenameCorrespondingTo(ast);
        return filename == null ? null : EclipseVPG.getIFileForFilename(filename);
    }

    @Override
    protected void processingDependent(String filename, String dependentFilename) {
        super.processingDependent(filename, dependentFilename);
    }

    public void commitChangesFromInMemoryASTs(IProgressMonitor pm, int ticks, IFile file) {
        this.commitChangesFromInMemoryASTs(pm, ticks, EclipseVPG.getFilenameForIFile(file));
    }

    public void commitChangesFromInMemoryASTs(IProgressMonitor pm, int ticks, Set<IFile> files) {
        String[] filenames = new String[files.size()];
        int i = 0;
        for (IFile file : files) {
            filenames[i++] = EclipseVPG.getFilenameForIFile(file);
        }
        this.commitChangesFromInMemoryASTs(pm, ticks, filenames);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class VPGInitialWorkspaceSyncJob
    extends VPGJob<A, T> {
        private VPGInitialWorkspaceSyncJob(String name) {
            super(name);
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) {
            try {
                monitor.beginTask("Indexing", -1);
                IStatus iStatus = EclipseVPG.this.ensureVPGIsUpToDate(monitor);
                return iStatus;
            }
            finally {
                monitor.done();
            }
        }
    }

    private final class VPGResourceChangeListener
    implements IResourceChangeListener {
        private VPGResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (!(event.getSource() instanceof IWorkspace)) {
                return;
            }
            if (event.getType() != 1) {
                return;
            }
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            new VPGResourceDeltaJob(EclipseVPG.this.syncMessage, delta).schedule();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class VPGResourceDeltaJob
    extends VPGJob<A, T> {
        private final IResourceDelta delta;

        private VPGResourceDeltaJob(String name, IResourceDelta delta) {
            super(name);
            this.delta = delta;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) {
            try {
                monitor.beginTask("Indexing", -1);
                VPGResourceDeltaVisitor visitor = new VPGResourceDeltaVisitor();
                monitor.subTask("Searching for workspace modifications...");
                this.delta.accept((IResourceDeltaVisitor)visitor);
                visitor.calculateDependencies(monitor);
                visitor.index(monitor);
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            catch (CoreException e) {
                IStatus iStatus = e.getStatus();
                return iStatus;
            }
            finally {
                monitor.done();
            }
        }
    }

    private final class VPGResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private ArrayList<String> files = new ArrayList(256);
        private HashMap<String, Boolean> forceReindex = new HashMap(256);

        public boolean visit(IResourceDelta delta) {
            IFile file;
            block12: {
                IResource resource;
                block11: {
                    resource = delta.getResource();
                    if (resource instanceof IFile) break block11;
                    if (resource instanceof IProject) {
                        return EclipseVPG.this.shouldProcessProject((IProject)resource);
                    }
                    return true;
                }
                file = (IFile)resource;
                if (EclipseVPG.this.shouldProcessFile(file)) break block12;
                return true;
            }
            try {
                String filename = EclipseVPG.getFilenameForIFile(file);
                switch (delta.getKind()) {
                    case 1: {
                        EclipseVPG.this.debug("Resource Delta: Add", filename);
                        this.files.add(filename);
                        this.forceReindex.put(filename, true);
                        break;
                    }
                    case 4: {
                        EclipseVPG.this.debug("Resource Delta: Change", filename);
                        if ((delta.getFlags() & 0x40100) != 0) {
                            this.files.add(filename);
                            this.forceReindex.put(filename, true);
                        }
                        break;
                    }
                    case 2: {
                        EclipseVPG.this.debug("Resource Delta: Remove", filename);
                        EclipseVPG.this.log.clearEntriesFor(filename);
                        EclipseVPG.this.db.deleteAllEntriesFor(filename);
                    }
                }
            }
            catch (Exception e) {
                EclipseVPG.this.log.logError(e);
            }
            return true;
        }

        public void calculateDependencies(IProgressMonitor monitor) {
            ArrayList<String> queue = this.files;
            int completed = 0;
            int total = queue.size();
            for (String filename : queue) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                monitor.subTask(String.valueOf(filename) + " (" + ++completed + " of " + total + ")");
                Boolean force = this.forceReindex.get(filename);
                if (force == null || force.booleanValue()) {
                    EclipseVPG.this.forceRecomputationOfDependencies(filename);
                    continue;
                }
                EclipseVPG.this.calculateDependenciesIfNotUpToDate(filename);
            }
        }

        public void index(IProgressMonitor monitor) {
            List<String> queue = EclipseVPG.this.sortFilesAccordingToDependencies(this.files, monitor);
            int completed = 0;
            int total = EclipseVPG.this.countFilesInQueue(queue);
            for (String filename : queue) {
                Boolean force;
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (EclipseVPG.this.shouldListFileInIndexerProgressMessages(filename)) {
                    monitor.subTask(String.valueOf(filename) + " (" + ++completed + " of " + total + ")");
                }
                if ((force = this.forceReindex.get(filename)) == null || force.booleanValue()) {
                    EclipseVPG.this.forceRecomputationOfEdgesAndAnnotations(filename);
                    continue;
                }
                EclipseVPG.this.indexIfNotUpToDate(filename);
            }
        }
    }

    private final class WorkspaceSyncResourceVisitor
    implements IResourceVisitor {
        private final ArrayList<String> files = new ArrayList(1024);

        private WorkspaceSyncResourceVisitor() {
        }

        public boolean visit(IResource resource) {
            block6: {
                block5: {
                    if (resource.isAccessible()) break block5;
                    return false;
                }
                if (!(resource instanceof IProject) || EclipseVPG.this.shouldProcessProject((IProject)resource)) break block6;
                return false;
            }
            try {
                if (resource instanceof IFile && EclipseVPG.this.shouldProcessFile((IFile)resource)) {
                    this.files.add(EclipseVPG.getFilenameForIFile((IFile)resource));
                }
            }
            catch (Exception e) {
                EclipseVPG.this.log.logError(e);
            }
            return !(resource instanceof IFile);
        }

        public void calculateDependencies(IProgressMonitor monitor) {
            ArrayList<String> queue = this.files;
            int completed = 0;
            int total = queue.size();
            for (String filename : queue) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                monitor.subTask(String.valueOf(filename) + " (calculating dependencies - file " + ++completed + " of " + total + ")");
                EclipseVPG.this.calculateDependenciesIfNotUpToDate(filename);
            }
        }

        public void index(IProgressMonitor monitor) {
            List<String> queue = EclipseVPG.this.sortFilesAccordingToDependencies(this.files, monitor);
            int completed = 0;
            int total = EclipseVPG.this.countFilesInQueue(queue);
            for (String filename : queue) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (EclipseVPG.this.shouldListFileInIndexerProgressMessages(filename)) {
                    monitor.subTask(String.valueOf(filename) + " (" + ++completed + " of " + total + ")");
                }
                EclipseVPG.this.indexIfNotUpToDate(filename);
            }
        }
    }
}

