/******************************************************************************
 * Copyright (c) 2005 The Regents of the University of California. 
 * This material was produced under U.S. Government contract W-7405-ENG-36 
 * for Los Alamos National Laboratory, which is operated by the University 
 * of California for the U.S. Department of Energy. The U.S. Government has 
 * rights to use, reproduce, and distribute this software. NEITHER THE 
 * GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED, OR 
 * ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE. If software is modified 
 * to produce derivative works, such modified software should be clearly 
 * marked, so as not to confuse it with the version available from LANL.
 * 
 * Additionally, this program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * LA-CC 04-115
 ******************************************************************************/

#include <stdio.h>

#include "session.h"
#include "proxy.h"
#include "proxy_tcp.h"

int shutdown;

void
shutdown_server(void)
{
	shutdown++;
}

int
main(int argc, char *argv[])
{
	int stat;
	void *conn;
	
	shutdown = 0;
	
	if (proxy_tcp_svr_funcs.create(&conn, shutdown_server) < 0) {
		fprintf(stderr, "proxy_tcp_svr_create failed\n");
		exit(1);
	}
	
	while (!shutdown) {
		if ((stat = proxy_tcp_svr_funcs.progress(conn)) < 0)
			break;
	}
		
	if (!shutdown && stat < 0)
		fprintf(stderr, "progress failed\n");
	
	proxy_tcp_svr_funcs.finish(conn);
	
	printf("proxy server shutting down\n");
	exit(0);
}