/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumeration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.core.runtime.PlatformObject;

public class CPPEnumeration
extends PlatformObject
implements ICPPEnumeration,
ICPPInternalBinding {
    private static final IASTName NOT_INITIALIZED = CPPASTName.NOT_INITIALIZED;
    private static final IEnumerator[] EMPTY_ENUMERATORS = new IEnumerator[0];
    private final boolean fIsScoped;
    private final IType fFixedType;
    private IASTName fDefinition = NOT_INITIALIZED;
    private IASTName[] fDeclarations = IASTName.EMPTY_NAME_ARRAY;
    private Long fMaxValue;
    private Long fMinValue;
    private ICPPEnumeration fIndexBinding = null;
    private boolean fSearchedIndex = false;

    public CPPEnumeration(ICPPASTEnumerationSpecifier spec, IType fixedType) {
        IASTName name = spec.getName();
        this.fIsScoped = spec.isScoped();
        this.fFixedType = fixedType;
        if (spec.isOpaque()) {
            this.addDeclaration(name);
        } else {
            this.addDefinition(name);
        }
        name.setBinding(this);
    }

    public IASTNode[] getDeclarations() {
        this.fDeclarations = ArrayUtil.trim(this.fDeclarations);
        return this.fDeclarations;
    }

    public IASTName getDefinition() {
        if (this.fDefinition == NOT_INITIALIZED) {
            FindDefinitionAction action = new FindDefinitionAction();
            IASTNode node = CPPVisitor.getContainingBlockItem(this.getADeclaration()).getParent();
            node.accept(action);
            this.fDefinition = action.result;
        }
        return this.fDefinition;
    }

    public String getName() {
        return new String(this.getNameCharArray());
    }

    public char[] getNameCharArray() {
        return this.getADeclaration().getSimpleID();
    }

    private IASTName getADeclaration() {
        if (this.fDefinition != null && this.fDefinition != NOT_INITIALIZED) {
            return this.fDefinition;
        }
        return this.fDeclarations[0];
    }

    public IScope getScope() {
        return CPPVisitor.getContainingScope(this.getADeclaration());
    }

    public Object clone() {
        throw new IllegalArgumentException("Enums must not be cloned");
    }

    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    public boolean isGloballyQualified() throws DOMException {
        IScope scope = this.getScope();
        while (scope != null) {
            if (scope instanceof ICPPBlockScope) {
                return false;
            }
            scope = scope.getParent();
        }
        return true;
    }

    public void addDefinition(IASTNode node) {
        assert (this.fDefinition == null || this.fDefinition == NOT_INITIALIZED);
        this.fDefinition = (IASTName)node;
    }

    public void addDeclaration(IASTNode node) {
        assert (node instanceof IASTName);
        this.fDeclarations = this.fDeclarations == null ? new IASTName[]{(IASTName)node} : ArrayUtil.append(this.fDeclarations, (IASTName)node);
    }

    public boolean isSameType(IType type) {
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef || type instanceof IIndexBinding) {
            return type.isSameType(this);
        }
        return false;
    }

    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    public IBinding getOwner() throws DOMException {
        return CPPVisitor.findDeclarationOwner(this.getADeclaration(), true);
    }

    public String toString() {
        return this.getName();
    }

    public long getMinValue() {
        IEnumerator[] enumerators;
        if (this.fMinValue != null) {
            return this.fMinValue;
        }
        long minValue = Long.MAX_VALUE;
        IEnumerator[] iEnumeratorArray = enumerators = this.getEnumerators();
        int n = enumerators.length;
        int n2 = 0;
        while (n2 < n) {
            long v;
            Long val;
            IEnumerator enumerator = iEnumeratorArray[n2];
            IValue value = enumerator.getValue();
            if (value != null && (val = value.numericalValue()) != null && (v = val.longValue()) < minValue) {
                minValue = v;
            }
            ++n2;
        }
        this.fMinValue = minValue;
        return minValue;
    }

    public long getMaxValue() {
        IEnumerator[] enumerators;
        if (this.fMaxValue != null) {
            return this.fMaxValue;
        }
        long maxValue = Long.MIN_VALUE;
        IEnumerator[] iEnumeratorArray = enumerators = this.getEnumerators();
        int n = enumerators.length;
        int n2 = 0;
        while (n2 < n) {
            long v;
            Long val;
            IEnumerator enumerator = iEnumeratorArray[n2];
            IValue value = enumerator.getValue();
            if (value != null && (val = value.numericalValue()) != null && (v = val.longValue()) > maxValue) {
                maxValue = v;
            }
            ++n2;
        }
        this.fMaxValue = maxValue;
        return maxValue;
    }

    public boolean isScoped() {
        return this.fIsScoped;
    }

    public IType getFixedType() {
        return this.fFixedType;
    }

    public IEnumerator[] getEnumerators() {
        IASTName definition = this.getDefinition();
        if (definition == null) {
            ICPPEnumeration typeInIndex = this.getIndexBinding();
            if (typeInIndex != null) {
                try {
                    return typeInIndex.getEnumerators();
                }
                catch (DOMException dOMException) {}
            }
            return EMPTY_ENUMERATORS;
        }
        IASTEnumerationSpecifier.IASTEnumerator[] enums = ((IASTEnumerationSpecifier)definition.getParent()).getEnumerators();
        IEnumerator[] bindings = new IEnumerator[enums.length];
        int i = 0;
        while (i < enums.length) {
            bindings[i] = (IEnumerator)enums[i].getName().resolveBinding();
            ++i;
        }
        return bindings;
    }

    private ICPPEnumeration getIndexBinding() {
        IASTTranslationUnit translationUnit;
        IIndex index;
        if (!this.fSearchedIndex && (index = (translationUnit = this.getADeclaration().getTranslationUnit()).getIndex()) != null) {
            this.fIndexBinding = (ICPPEnumeration)((Object)index.adaptBinding(this));
        }
        return this.fIndexBinding;
    }

    public ICPPScope asScope() {
        IASTName def = this.getDefinition();
        if (def == null) {
            ICPPEnumeration indexBinding = this.getIndexBinding();
            if (indexBinding != null) {
                return indexBinding.asScope();
            }
            def = this.getADeclaration();
        }
        return ((ICPPASTEnumerationSpecifier)def.getParent()).getScope();
    }

    private class FindDefinitionAction
    extends CPPASTVisitor {
        private char[] nameArray;
        public IASTName result;

        private FindDefinitionAction() {
            this.nameArray = CPPEnumeration.this.getNameCharArray();
            this.result = null;
            this.shouldVisitNames = true;
            this.shouldVisitDeclarations = true;
            this.shouldVisitDeclSpecifiers = true;
            this.shouldVisitDeclarators = true;
        }

        public int visit(IASTName name) {
            IBinding binding;
            if (name instanceof ICPPASTTemplateId || name instanceof ICPPASTQualifiedName) {
                return 1;
            }
            char[] c = name.getLookupKey();
            if (name.getParent() instanceof ICPPASTEnumerationSpecifier && CharArrayUtils.equals(c, this.nameArray) && (binding = name.resolveBinding()) == CPPEnumeration.this) {
                this.result = name;
                return 2;
            }
            return 3;
        }

        public int visit(IASTDeclaration declaration) {
            if (declaration instanceof IASTSimpleDeclaration) {
                return 3;
            }
            return 1;
        }

        public int visit(IASTDeclSpecifier declSpec) {
            return declSpec instanceof ICPPASTEnumerationSpecifier ? 3 : 1;
        }

        public int visit(IASTDeclarator declarator) {
            return 1;
        }
    }
}

