/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTPointerToMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.core.runtime.CoreException;

public class CPPPointerToMemberType
extends CPPPointerType
implements ICPPPointerToMemberType {
    private ICPPASTPointerToMember operator;
    private IType classType;

    public CPPPointerToMemberType(IType type, ICPPASTPointerToMember operator) {
        super(type, operator);
        this.operator = operator;
    }

    public CPPPointerToMemberType(IType type, IType thisType, boolean isConst, boolean isVolatile) {
        super(type, isConst, isVolatile);
        this.classType = thisType;
    }

    public boolean isSameType(IType o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ITypedef) {
            return o.isSameType(this);
        }
        if (!(o instanceof ICPPPointerToMemberType)) {
            return false;
        }
        if (!super.isSameType(o)) {
            return false;
        }
        ICPPPointerToMemberType pt = (ICPPPointerToMemberType)o;
        IType cls = pt.getMemberOfClass();
        if (cls != null) {
            return cls.isSameType(this.getMemberOfClass());
        }
        return false;
    }

    public IType getMemberOfClass() {
        if (this.classType == null) {
            IASTName name;
            IBinding binding = null;
            ICPPASTPointerToMember pm = this.operator;
            if (pm == null) {
                name = new CPPASTName();
            } else {
                name = pm.getName();
                if (name instanceof ICPPASTQualifiedName) {
                    IASTName[] ns = ((ICPPASTQualifiedName)name).getNames();
                    name = ns.length > 1 ? ns[ns.length - 2] : ns[ns.length - 1];
                }
                binding = name.resolvePreBinding();
            }
            this.classType = binding instanceof IType ? (IType)((Object)binding) : new CPPClassType.CPPClassTypeProblem((IASTNode)name, 5, name.toCharArray());
        }
        return this.classType;
    }

    public void marshal(ITypeMarshalBuffer buffer) throws CoreException {
        int firstByte = 7;
        if (this.isConst()) {
            firstByte |= 0x10;
        }
        if (this.isVolatile()) {
            firstByte |= 0x20;
        }
        buffer.putByte((byte)firstByte);
        buffer.marshalType(this.getType());
        buffer.marshalType(this.getMemberOfClass());
    }

    public static IType unmarshal(int firstByte, ITypeMarshalBuffer buffer) throws CoreException {
        IType nested = buffer.unmarshalType();
        IType memberOf = buffer.unmarshalType();
        return new CPPPointerToMemberType(nested, memberOf, (firstByte & 0x10) != 0, (firstByte & 0x20) != 0);
    }
}

