/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.server.dstore.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ptp.rdt.server.dstore.core.RemoteToolsCIndexServiceProvider;
import org.eclipse.ptp.rdt.server.dstore.messages.Messages;
import org.eclipse.ptp.rdt.server.dstore.ui.DStoreServerWidget;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.ui.IRemoteUIConnectionManager;
import org.eclipse.ptp.remote.ui.PTPRemoteUIPlugin;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.ui.IServiceProviderContributor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RemoteToolsCIndexServiceProviderContributer
implements IServiceProviderContributor {
    private RemoteToolsCIndexServiceProvider fProvider;
    private final Map<Integer, IRemoteServices> fComboIndexToRemoteServicesProviderMap = new HashMap<Integer, IRemoteServices>();
    private IRemoteServices fSelectedServices;
    private final Map<Integer, IRemoteConnection> fComboIndexToRemoteConnectionMap = new HashMap<Integer, IRemoteConnection>();
    private IRemoteConnection fSelectedConnection;
    private DStoreServerWidget fServerWidget;
    private String fConfigPath;

    public void configureServiceProvider(IServiceProvider sp, final Composite container) {
        if (!(sp instanceof RemoteToolsCIndexServiceProvider)) {
            throw new IllegalArgumentException();
        }
        this.fProvider = (RemoteToolsCIndexServiceProvider)sp;
        container.setLayout((Layout)new GridLayout(1, false));
        Group connectionGroup = new Group(container, 0);
        connectionGroup.setText(Messages.RemoteToolsCIndexServiceProviderContributer_0);
        connectionGroup.setLayout((Layout)new GridLayout(3, false));
        connectionGroup.setLayoutData((Object)new GridData(768));
        Label providerLabel = new Label((Composite)connectionGroup, 16384);
        providerLabel.setText(Messages.RemoteToolsCIndexServiceProviderContributer_1);
        final Combo providerCombo = new Combo((Composite)connectionGroup, 12);
        GridData data = new GridData(1, 1, false, false);
        data.horizontalSpan = 2;
        providerCombo.setLayoutData((Object)data);
        this.populateProviderCombo(providerCombo);
        Label connectionLabel = new Label((Composite)connectionGroup, 16384);
        connectionLabel.setText(Messages.RemoteToolsCIndexServiceProviderContributer_2);
        final Combo connectionCombo = new Combo((Composite)connectionGroup, 12);
        connectionCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.populateConnectionCombo(connectionCombo);
        final Button newConnectionButton = new Button((Composite)connectionGroup, 8);
        newConnectionButton.setText(Messages.RemoteToolsCIndexServiceProviderContributer_3);
        this.updateNewConnectionButtonEnabled(newConnectionButton);
        newConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IRemoteUIConnectionManager connectionManager = RemoteToolsCIndexServiceProviderContributer.this.getUIConnectionManager();
                if (connectionManager != null) {
                    connectionManager.newConnection(container.getShell());
                }
                RemoteToolsCIndexServiceProviderContributer.this.populateConnectionCombo(connectionCombo);
            }
        });
        providerCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = providerCombo.getSelectionIndex();
                RemoteToolsCIndexServiceProviderContributer.this.fSelectedServices = (IRemoteServices)RemoteToolsCIndexServiceProviderContributer.this.fComboIndexToRemoteServicesProviderMap.get(selectionIndex);
                RemoteToolsCIndexServiceProviderContributer.this.populateConnectionCombo(connectionCombo);
                RemoteToolsCIndexServiceProviderContributer.this.updateNewConnectionButtonEnabled(newConnectionButton);
                RemoteToolsCIndexServiceProviderContributer.this.fServerWidget.setConnection(RemoteToolsCIndexServiceProviderContributer.this.fSelectedConnection);
            }
        });
        connectionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = connectionCombo.getSelectionIndex();
                RemoteToolsCIndexServiceProviderContributer.this.fSelectedConnection = (IRemoteConnection)RemoteToolsCIndexServiceProviderContributer.this.fComboIndexToRemoteConnectionMap.get(selectionIndex);
                RemoteToolsCIndexServiceProviderContributer.this.updateNewConnectionButtonEnabled(newConnectionButton);
                RemoteToolsCIndexServiceProviderContributer.this.fProvider.setConnection(RemoteToolsCIndexServiceProviderContributer.this.fSelectedConnection);
                RemoteToolsCIndexServiceProviderContributer.this.fServerWidget.setConnection(RemoteToolsCIndexServiceProviderContributer.this.fSelectedConnection);
            }
        });
        this.fServerWidget = new DStoreServerWidget(container, 0);
        data = new GridData(4, 4, true, false);
        data.horizontalSpan = 3;
        this.fServerWidget.setLayoutData(data);
        this.fServerWidget.setConnection(this.fSelectedConnection);
        this.fServerWidget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (e.data == DStoreServerWidget.FieldModifier.VALUE_INDEX_LOCATION) {
                    RemoteToolsCIndexServiceProviderContributer.this.fConfigPath = RemoteToolsCIndexServiceProviderContributer.this.fServerWidget.getIndexLocation();
                    RemoteToolsCIndexServiceProviderContributer.this.fProvider.setIndexLocation(RemoteToolsCIndexServiceProviderContributer.this.fConfigPath);
                }
            }
        });
        this.fServerWidget.setIndexLocation(this.fProvider.getIndexLocation());
    }

    public IWizard getWizard(IServiceProvider provider, IWizardPage page) {
        return null;
    }

    public WizardPage[] getWizardPages(IWizard wizard, IServiceProvider provider) {
        return null;
    }

    private IRemoteUIConnectionManager getUIConnectionManager() {
        IRemoteUIConnectionManager connectionManager = PTPRemoteUIPlugin.getDefault().getRemoteUIServices(this.fSelectedServices).getUIConnectionManager();
        return connectionManager;
    }

    private void populateConnectionCombo(Combo connectionCombo) {
        IRemoteServices providerSelected;
        connectionCombo.removeAll();
        IRemoteConnection connectionSelected = null;
        if (this.fProvider.getServiceId() != null && (providerSelected = PTPRemoteCorePlugin.getDefault().getRemoteServices(this.fProvider.getServiceId())) != null && this.fProvider.getConnectionName() != null) {
            connectionSelected = providerSelected.getConnectionManager().getConnection(this.fProvider.getConnectionName());
        }
        IRemoteConnection[] connections = this.fSelectedServices.getConnectionManager().getConnections();
        int toSelect = 0;
        int k = 0;
        while (k < connections.length) {
            connectionCombo.add(connections[k].getName(), k);
            this.fComboIndexToRemoteConnectionMap.put(k, connections[k]);
            if (connectionSelected != null && connectionSelected.getName().equals(connections[k].getName())) {
                toSelect = k;
            }
            ++k;
        }
        connectionCombo.select(toSelect);
        this.fSelectedConnection = this.fComboIndexToRemoteConnectionMap.get(toSelect);
    }

    private void populateProviderCombo(Combo providerCombo) {
        IRemoteServices providerSelected = null;
        if (this.fProvider.getServiceId() != null) {
            providerSelected = PTPRemoteCorePlugin.getDefault().getRemoteServices(this.fProvider.getServiceId());
        }
        IRemoteServices[] providers = PTPRemoteCorePlugin.getDefault().getAllRemoteServices();
        int toSelect = 0;
        int k = 0;
        while (k < providers.length) {
            providerCombo.add(providers[k].getName(), k);
            this.fComboIndexToRemoteServicesProviderMap.put(k, providers[k]);
            if (providerSelected != null && providerSelected.getId().compareTo(providers[k].getId()) == 0) {
                toSelect = k;
            }
            ++k;
        }
        providerCombo.select(toSelect);
        this.fSelectedServices = this.fComboIndexToRemoteServicesProviderMap.get(toSelect);
    }

    private void updateNewConnectionButtonEnabled(Button button) {
        IRemoteUIConnectionManager connectionManager = this.getUIConnectionManager();
        button.setEnabled(connectionManager != null);
    }
}

