/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.lexer.FileOrIFile;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.lexer.TokenList;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.parser.IASTVisitor;
import org.eclipse.photran.internal.core.util.IterableWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FortranAST
implements IFortranAST {
    private IFile file;
    private ASTExecutableProgramNode root;
    private TokenList tokenList;

    public FortranAST(IFile file, ASTExecutableProgramNode root, TokenList tokenList) {
        this.file = file;
        this.root = root;
        this.tokenList = tokenList;
        FileOrIFile f = new FileOrIFile(file);
        for (Token token : new IterableWrapper((Object)tokenList)) {
            if (token.getPhysicalFile() == null) {
                token.setPhysicalFile(f);
            }
            token.setLogicalFile(file);
        }
    }

    @Override
    public void accept(IASTVisitor visitor) {
        this.root.accept(visitor);
    }

    @Override
    public IFile getFile() {
        return this.file;
    }

    @Override
    public ASTExecutableProgramNode getRoot() {
        return this.root;
    }

    @Override
    public Iterator<Token> iterator() {
        return this.tokenList.iterator();
    }

    @Override
    public Token findTokenByStreamOffsetLength(int offset, int length) {
        return (Token)this.tokenList.findStreamOffsetLength(offset, length);
    }

    @Override
    public Token findTokenByFileOffsetLength(IFile file, int offset, int length) {
        int i = 0;
        while (i < this.tokenList.size()) {
            Token token = (Token)this.tokenList.get(i);
            FileOrIFile physicalFile = token.getPhysicalFile();
            if (physicalFile != null && physicalFile.getIFile() != null && physicalFile.getIFile().hashCode() == file.hashCode() && physicalFile.getIFile().equals((Object)file) && token.getFileOffset() == offset && token.getLength() == length) {
                return token;
            }
            ++i;
        }
        return null;
    }

    @Override
    public Token findFirstTokenOnLine(int line) {
        return (Token)this.tokenList.findFirstTokenOnLine(line);
    }

    @Override
    public Token findLastTokenOnLine(int line) {
        return (Token)this.tokenList.findLastTokenOnLine(line);
    }
}

