/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.internal.ssh;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.remotetools.core.IRemoteCopyTools;
import org.eclipse.ptp.remotetools.core.IRemoteFileEnumeration;
import org.eclipse.ptp.remotetools.core.IRemoteFileTools;
import org.eclipse.ptp.remotetools.core.IRemoteItem;
import org.eclipse.ptp.remotetools.core.IRemotePathTools;
import org.eclipse.ptp.remotetools.core.messages.Messages;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.exception.RemoteException;
import org.eclipse.ptp.remotetools.exception.RemoteExecutionException;
import org.eclipse.ptp.remotetools.exception.RemoteOperationException;
import org.eclipse.ptp.remotetools.internal.ssh.ExecutionManager;
import org.eclipse.ptp.remotetools.internal.ssh.RemoteFileAttributes;
import org.eclipse.ptp.remotetools.internal.ssh.RemoteFileEnumeration;
import org.eclipse.ptp.remotetools.internal.ssh.RemoteFileRecursiveEnumeration;
import org.eclipse.ptp.remotetools.internal.ssh.RemoteItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTools
implements IRemoteFileTools {
    private static ExecutorService fPool = Executors.newSingleThreadExecutor();
    protected ExecutionManager manager;
    private int cachedUserID;
    private Set<Integer> cachedGroupIDSet;
    private String fOSName = null;

    protected FileTools(ExecutionManager manager) {
        this.manager = manager;
    }

    public String addTrailingSlash(String path) {
        if (path.endsWith("/")) {
            return path;
        }
        return String.valueOf(path) + "/";
    }

    @Override
    public void assureDirectory(String directory, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(directory);
        if (!this.hasDirectory(directory, monitor)) {
            this.createDirectory(directory, monitor);
        }
    }

    @Override
    public boolean canExecute(String remotePath) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(remotePath);
        RemoteItem item = (RemoteItem)this.getItem(remotePath);
        return item.isExecutable();
    }

    @Override
    public boolean canRead(String remotePath) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(remotePath);
        RemoteItem item = (RemoteItem)this.getItem(remotePath);
        return item.isReadable();
    }

    @Override
    public boolean canWrite(String remotePath) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(remotePath);
        RemoteItem item = (RemoteItem)this.getItem(remotePath);
        return item.isWritable();
    }

    public void chmod(final int permissions, final String path, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException {
        try {
            this.test();
            this.validateRemotePath(path);
            SftpCallable<Integer> c = new SftpCallable<Integer>(){

                @Override
                public Integer call() throws SftpException {
                    this.getChannel().chmod(permissions, path);
                    return 0;
                }
            };
            ((SftpCallable)c).syncCmdInThread(Messages.FileTools_2, monitor);
        }
        catch (IOException e) {
            throw new RemoteOperationException(e);
        }
        catch (SftpException e) {
            throw new RemoteOperationException(e);
        }
    }

    public String concatenateRemotePath(String p1, String p2) {
        if (p1.endsWith("/")) {
            return String.valueOf(p1) + p2;
        }
        return String.valueOf(p1) + "/" + p2;
    }

    @Override
    public void copyFile(String from, String to, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(from);
        this.validateRemotePath(to);
        IRemotePathTools pathTool = this.manager.getRemotePathTools();
        try {
            this.executeCommand("cp -f " + pathTool.quote(from, true) + " " + pathTool.quote(to, true));
        }
        catch (RemoteExecutionException e) {
            throw new RemoteOperationException(e);
        }
    }

    @Override
    public void createDirectory(String directory, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.validateRemotePath(directory);
        IRemotePathTools pathTool = this.manager.getRemotePathTools();
        final String path = pathTool.quote(directory, true);
        String parent = pathTool.parent(path);
        RemoteFileAttributes attrs = this.fetchRemoteAttr(parent, monitor);
        if (attrs == null) {
            this.createDirectory(parent, monitor);
        }
        try {
            SftpCallable<Integer> c = new SftpCallable<Integer>(){

                @Override
                public Integer call() throws SftpException {
                    this.getChannel().mkdir(path);
                    return 0;
                }
            };
            ((SftpCallable)c).syncCmdInThread(Messages.FileTools_3, monitor);
        }
        catch (IOException e) {
            throw new RemoteOperationException(e);
        }
        catch (SftpException e) {
            throw new RemoteOperationException(e);
        }
    }

    @Override
    public void createFile(String file, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(file);
        IRemotePathTools pathTool = this.manager.getRemotePathTools();
        final String path = pathTool.quote(file, true);
        try {
            SftpCallable<Integer> c = new SftpCallable<Integer>(){

                @Override
                public Integer call() throws SftpException, IOException {
                    OutputStream os = this.getChannel().put(path);
                    os.close();
                    return 0;
                }
            };
            ((SftpCallable)c).syncCmdInThread(Messages.FileTools_4, monitor);
        }
        catch (IOException e) {
            throw new RemoteOperationException(e);
        }
        catch (SftpException e) {
            throw new RemoteOperationException(e);
        }
    }

    @Override
    public IRemoteFileEnumeration createFileEnumeration(String path) throws RemoteOperationException, RemoteConnectionException, CancelException {
        return new RemoteFileEnumeration(this, path);
    }

    @Override
    public IRemoteFileEnumeration createRecursiveFileEnumeration(String path) throws RemoteOperationException, RemoteConnectionException, CancelException {
        return new RemoteFileRecursiveEnumeration(this, path);
    }

    public void downloadIntoOutputStream(final String remotePath, final OutputStream sink, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException {
        try {
            this.test();
            this.validateRemotePath(remotePath);
            SftpCallable<Integer> c = new SftpCallable<Integer>(){

                @Override
                public Integer call() throws SftpException {
                    this.getChannel().get(remotePath, sink);
                    return 0;
                }
            };
            ((SftpCallable)c).syncCmdInThread(Messages.FileTools_5, monitor);
        }
        catch (IOException e) {
            throw new RemoteOperationException(e);
        }
        catch (SftpException e) {
            throw new RemoteOperationException(e);
        }
    }

    public Set<Integer> getCachedGroupIDSet() {
        return this.cachedGroupIDSet;
    }

    public int getCachedUserID() {
        return this.cachedUserID;
    }

    @Override
    public IRemoteItem getDirectory(String directoryPath, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException, RemoteOperationException {
        this.test();
        this.validateRemotePath(directoryPath);
        directoryPath = this.removeTrailingSlash(directoryPath);
        this.cacheUserData();
        RemoteItem remfile = new RemoteItem(this, directoryPath);
        remfile.refreshAttributes(monitor);
        if (!remfile.isDirectory()) {
            throw new RemoteOperationException(Messages.FileTools_6);
        }
        return remfile;
    }

    @Override
    public IRemoteItem getFile(String filePath, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException, RemoteOperationException {
        this.test();
        this.validateRemotePath(filePath);
        filePath = this.removeTrailingSlash(filePath);
        this.cacheUserData();
        RemoteItem remfile = new RemoteItem(this, filePath);
        remfile.refreshAttributes(monitor);
        if (remfile.isDirectory()) {
            throw new RemoteOperationException(Messages.FileTools_7);
        }
        return remfile;
    }

    @Override
    public InputStream getInputStream(String file, IProgressMonitor m) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(file);
        IRemotePathTools pathTool = this.manager.getRemotePathTools();
        final String path = pathTool.quote(file, true);
        IProgressMonitor monitor = m == null ? new NullProgressMonitor() : m;
        final FileToolsProgressMonitor sftpMonitor = new FileToolsProgressMonitor(monitor);
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            SftpCallable<Integer> c = new SftpCallable<Integer>(){

                @Override
                public Integer call() throws SftpException, IOException {
                    this.getChannel().get(path, (OutputStream)out, sftpMonitor);
                    out.close();
                    return 0;
                }
            };
            ((SftpCallable)c).syncCmdInThread(Messages.FileTools_8, monitor);
            return new ByteArrayInputStream(out.toByteArray());
        }
        catch (IOException e) {
            throw new RemoteOperationException(e);
        }
        catch (SftpException e) {
            throw new RemoteOperationException(e);
        }
    }

    @Override
    public IRemoteItem getItem(String path) throws RemoteConnectionException, RemoteOperationException, CancelException, RemoteOperationException {
        this.test();
        this.validateRemotePath(path);
        path = this.removeTrailingSlash(path);
        this.cacheUserData();
        return new RemoteItem(this, path);
    }

    @Override
    public OutputStream getOutputStream(String file, int options, IProgressMonitor m) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(file);
        IRemotePathTools pathTool = this.manager.getRemotePathTools();
        final String path = pathTool.quote(file, true);
        final IProgressMonitor monitor = m == null ? new NullProgressMonitor() : m;
        final FileToolsProgressMonitor sftpMonitor = new FileToolsProgressMonitor(monitor);
        final int mode = (options & 1) == 0 ? 0 : 2;
        return new ByteArrayOutputStream(){

            public void close() throws IOException {
                super.close();
                final ByteArrayInputStream is = new ByteArrayInputStream(this.toByteArray());
                try {
                    SftpCallable<Integer> c = new SftpCallable<Integer>(FileTools.this){

                        @Override
                        public Integer call() throws SftpException, IOException {
                            this.getChannel().put(is, path, sftpMonitor, mode);
                            is.close();
                            return 0;
                        }
                    };
                    ((SftpCallable)c).syncCmdInThread(Messages.FileTools_9, monitor);
                }
                catch (SftpException e) {
                    throw new IOException(e.getMessage());
                }
                catch (RemoteException e) {
                    throw new IOException(e.getMessage());
                }
                catch (CancelException e) {
                    throw new IOException(e.getMessage());
                }
            }
        };
    }

    @Override
    public IRemoteCopyTools getRemoteCopyTools() throws RemoteConnectionException {
        return this.manager.getRemoteCopyTools();
    }

    @Override
    public boolean hasDirectory(String directory, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(directory);
        RemoteItem item = (RemoteItem)this.getItem(directory);
        item.refreshAttributes(monitor);
        if (!item.exists()) {
            return false;
        }
        return item.isDirectory();
    }

    @Override
    public boolean hasFile(String file, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(file);
        IRemoteItem item = this.getItem(file);
        item.refreshAttributes(monitor);
        if (!item.exists()) {
            return false;
        }
        return !item.isDirectory();
    }

    @Override
    public IRemoteItem[] listItems(final String root, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException {
        Vector files;
        this.validateRemotePath(root);
        try {
            SftpCallable<Vector<ChannelSftp.LsEntry>> c = new SftpCallable<Vector<ChannelSftp.LsEntry>>(){

                @Override
                public Vector<ChannelSftp.LsEntry> call() throws SftpException {
                    return this.getChannel().ls(root);
                }
            };
            files = (Vector)((SftpCallable)c).syncCmdInThread(Messages.FileTools_10, monitor);
        }
        catch (IOException e) {
            throw new RemoteOperationException(e);
        }
        catch (SftpException e) {
            throw new RemoteOperationException(e);
        }
        this.cacheUserData();
        ArrayList<RemoteItem> result = new ArrayList<RemoteItem>();
        Enumeration enumeration = files.elements();
        while (enumeration.hasMoreElements()) {
            ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)enumeration.nextElement();
            String fileName = entry.getFilename();
            String pathName = this.concatenateRemotePath(root, fileName);
            if (fileName.equals(".") || fileName.equals("..")) continue;
            result.add(new RemoteItem(this, pathName, entry.getAttrs()));
        }
        IRemoteItem[] resultArray = new IRemoteItem[result.size()];
        result.toArray(resultArray);
        return resultArray;
    }

    @Override
    public void moveFile(String from, String to, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(from);
        this.validateRemotePath(to);
        IRemotePathTools pathTool = this.manager.getRemotePathTools();
        try {
            this.executeCommand("mv -f " + pathTool.quote(from, true) + " " + pathTool.quote(to, true));
        }
        catch (RemoteExecutionException e) {
            throw new RemoteOperationException(e);
        }
    }

    public String parentOfRemotePath(String path) {
        int index = (path = this.removeTrailingSlash(path)).lastIndexOf(47);
        if (index == -1) {
            return null;
        }
        return this.removeTrailingSlash(path.substring(0, index));
    }

    @Override
    public void removeDirectory(String dir, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(dir);
        IRemotePathTools pathTool = this.manager.getRemotePathTools();
        final String path = pathTool.quote(dir, true);
        try {
            SftpCallable<Integer> c = new SftpCallable<Integer>(){

                @Override
                public Integer call() throws SftpException {
                    this.getChannel().rmdir(path);
                    return 0;
                }
            };
            ((SftpCallable)c).syncCmdInThread(Messages.FileTools_11, monitor);
        }
        catch (IOException e) {
            throw new RemoteOperationException(e);
        }
        catch (SftpException e) {
            throw new RemoteOperationException(e);
        }
    }

    @Override
    public void removeFile(String file, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(file);
        IRemotePathTools pathTool = this.manager.getRemotePathTools();
        final String path = pathTool.quote(file, true);
        try {
            SftpCallable<Integer> c = new SftpCallable<Integer>(){

                @Override
                public Integer call() throws SftpException {
                    this.getChannel().rm(path);
                    return 0;
                }
            };
            ((SftpCallable)c).syncCmdInThread(Messages.FileTools_12, monitor);
        }
        catch (IOException e) {
            throw new RemoteOperationException(e);
        }
        catch (SftpException e) {
            throw new RemoteOperationException(e);
        }
    }

    public String removeTrailingSlash(String path) {
        if (!path.equals("/") && path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public void setMtime(final String path, final int mtime, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException {
        try {
            this.test();
            this.validateRemotePath(path);
            SftpCallable<Integer> c = new SftpCallable<Integer>(){

                @Override
                public Integer call() throws SftpException {
                    this.getChannel().setMtime(path, mtime);
                    return 0;
                }
            };
            ((SftpCallable)c).syncCmdInThread(Messages.FileTools_13, monitor);
        }
        catch (IOException e) {
            throw new RemoteOperationException(e);
        }
        catch (SftpException e) {
            throw new RemoteOperationException(e);
        }
    }

    public String suffixOfRemotePath(String path) {
        int index = (path = this.removeTrailingSlash(path)).lastIndexOf(47);
        if (index == -1) {
            return null;
        }
        return this.removeTrailingSlash(path.substring(index + 1));
    }

    public void uploadFromInputStream(final InputStream source, final String remotePath, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException {
        try {
            this.test();
            this.validateRemotePath(remotePath);
            SftpCallable<Integer> c = new SftpCallable<Integer>(){

                @Override
                public Integer call() throws SftpException {
                    this.getChannel().put(source, remotePath);
                    return 0;
                }
            };
            ((SftpCallable)c).syncCmdInThread(Messages.FileTools_14, monitor);
        }
        catch (IOException e) {
            throw new RemoteOperationException(e);
        }
        catch (SftpException e) {
            throw new RemoteOperationException(e);
        }
    }

    public void uploadPermissions(File file, String remoteFilePath) throws RemoteConnectionException, RemoteOperationException, CancelException {
        IRemoteItem item = this.getItem(remoteFilePath);
        item.setReadable(file.canRead());
        item.setWriteable(file.canWrite());
        item.commitAttributes(null);
    }

    public void validateRemotePath(String path) throws RemoteOperationException {
        if (!path.startsWith("/")) {
            throw new RemoteOperationException(String.valueOf(path) + Messages.RemoteFileTools_ValidateRemotePath_NotValid);
        }
    }

    private void cacheUserData() throws RemoteConnectionException, RemoteOperationException, CancelException {
        if (this.cachedGroupIDSet == null) {
            this.cachedGroupIDSet = this.manager.getRemoteStatusTools().getGroupIDSet();
            this.cachedUserID = this.manager.getRemoteStatusTools().getUserID();
        }
    }

    private boolean checkOSName(String name) {
        if (this.fOSName == null) {
            try {
                this.fOSName = this.manager.getExecutionTools().executeWithOutput("uname").trim();
            }
            catch (RemoteExecutionException remoteExecutionException) {
                return false;
            }
            catch (RemoteConnectionException remoteConnectionException) {
                return false;
            }
            catch (CancelException cancelException) {
                return false;
            }
        }
        return this.fOSName.equals(name);
    }

    private ChannelSftp getSFTPChannel() throws RemoteConnectionException {
        return this.manager.connection.getSFTPChannel();
    }

    private void releaseSFTPChannel(ChannelSftp sftp) {
        this.manager.connection.releaseSFTPChannel(sftp);
    }

    protected void executeCommand(String command) throws RemoteConnectionException, RemoteExecutionException, CancelException {
        this.manager.executionTools.executeBashCommand(command);
    }

    protected RemoteFileAttributes fetchRemoteAttr(final String path, IProgressMonitor monitor) throws RemoteOperationException, CancelException, RemoteConnectionException {
        this.validateRemotePath(path);
        try {
            this.test();
            SftpCallable<SftpATTRS> c = new SftpCallable<SftpATTRS>(){

                @Override
                public SftpATTRS call() throws SftpException {
                    return this.getChannel().stat(path);
                }
            };
            SftpATTRS attrs = (SftpATTRS)((SftpCallable)c).syncCmdInThread(Messages.FileTools_15, monitor);
            return RemoteFileAttributes.getAttributes(attrs);
        }
        catch (SftpException e) {
            if (e.id == 2) {
                return null;
            }
            throw new RemoteOperationException(e);
        }
        catch (IOException e) {
            throw new RemoteOperationException(e);
        }
    }

    protected void test() throws RemoteConnectionException, CancelException {
        this.manager.test();
        this.manager.testCancel();
    }

    public static class FileToolsProgressMonitor
    implements SftpProgressMonitor {
        private IProgressMonitor fMonitor;
        private long fWorkToDate;

        public FileToolsProgressMonitor(IProgressMonitor monitor) {
            this.fMonitor = monitor;
        }

        public boolean count(long count) {
            this.fWorkToDate += count;
            return !this.fMonitor.isCanceled();
        }

        public void end() {
        }

        public void init(int op, String src, String dest, long max) {
            String srcFile;
            this.fWorkToDate = 0L;
            String desc = srcFile = new Path(src).lastSegment();
            this.fMonitor.beginTask(desc, (int)max);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class SftpCallable<T>
    implements Callable<T> {
        private ChannelSftp fSftpChannel = null;

        private SftpCallable() {
        }

        @Override
        public abstract T call() throws SftpException, IOException;

        public ChannelSftp getChannel() {
            return this.fSftpChannel;
        }

        public void setChannel(ChannelSftp channel) {
            this.fSftpChannel = channel;
        }

        private Future<T> asyncCmdInThread(String jobName, IProgressMonitor monitor) throws SftpException, IOException, RemoteConnectionException {
            if (monitor != null) {
                monitor.beginTask(jobName, 1);
            }
            this.setChannel(FileTools.this.getSFTPChannel());
            return fPool.submit(this);
        }

        private void finalizeCmdInThread(IProgressMonitor monitor) {
            FileTools.this.releaseSFTPChannel(this.getChannel());
            this.setChannel(null);
            if (monitor != null) {
                monitor.done();
            }
        }

        private T syncCmdInThread(String jobName, IProgressMonitor monitor) throws RemoteConnectionException, SftpException, IOException, RemoteOperationException, CancelException {
            Future<T> future = null;
            try {
                future = this.asyncCmdInThread(jobName, monitor);
                T t = this.waitCmdInThread(future, monitor);
                return t;
            }
            finally {
                this.finalizeCmdInThread(monitor);
            }
        }

        private T waitCmdInThread(Future<T> future, IProgressMonitor monitor) throws IOException, CancelException, SftpException, RemoteOperationException {
            T ret = null;
            boolean bInterrupted = Thread.interrupted();
            while (ret == null) {
                if (monitor != null && monitor.isCanceled()) {
                    future.cancel(true);
                    this.getChannel().quit();
                    throw new CancelException();
                }
                try {
                    ret = future.get(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    bInterrupted = true;
                }
                catch (TimeoutException timeoutException) {
                }
                catch (ExecutionException e) {
                    this.getChannel().quit();
                    if (e.getCause() instanceof IOException) {
                        throw (IOException)e.getCause();
                    }
                    if (e.getCause() instanceof SftpException) {
                        throw (SftpException)e.getCause();
                    }
                    throw new RemoteOperationException(e);
                }
            }
            if (bInterrupted) {
                Thread.currentThread().interrupt();
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            return ret;
        }
    }
}

