/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTypeParameter;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInstanceCache;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.IPDOMCPPTemplateParameter;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.IPDOMCPPTemplateParameterOwner;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPClassType;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMInstanceCache;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMTemplateParameterArray;
import org.eclipse.core.runtime.CoreException;

public class PDOMCPPClassTemplate
extends PDOMCPPClassType
implements ICPPClassTemplate,
ICPPInstanceCache,
IPDOMCPPTemplateParameterOwner {
    private static final int PARAMETERS = 42;
    private static final short RELEVANT_PARAMETERS = 46;
    private static final int FIRST_PARTIAL = 48;
    protected static final int RECORD_SIZE = 52;
    private ICPPTemplateParameter[] params;

    public PDOMCPPClassTemplate(PDOMCPPLinkage linkage, PDOMNode parent, ICPPClassTemplate template) throws CoreException, DOMException {
        super((PDOMLinkage)linkage, parent, template);
        Database db = this.getDB();
        ICPPTemplateParameter[] origParams = template.getTemplateParameters();
        IPDOMCPPTemplateParameter[] params = PDOMTemplateParameterArray.createPDOMTemplateParameters(linkage, this, origParams);
        long rec = PDOMTemplateParameterArray.putArray(db, params);
        db.putRecPtr(this.record + 42L, rec);
        db.putShort(this.record + 46L, (short)params.length);
        PDOMCPPLinkage pDOMCPPLinkage = linkage;
        pDOMCPPLinkage.getClass();
        new PDOMCPPLinkage.ConfigureTemplateParameters(pDOMCPPLinkage, origParams, params);
    }

    public PDOMCPPClassTemplate(PDOMLinkage linkage, long bindingRecord) {
        super(linkage, bindingRecord);
    }

    protected int getRecordSize() {
        return 52;
    }

    public int getNodeType() {
        return 24;
    }

    public ICPPTemplateParameter[] getTemplateParameters() {
        if (this.params == null) {
            try {
                Database db = this.getDB();
                long rec = db.getRecPtr(this.record + 42L);
                int count = Math.max(0, db.getShort(this.record + 46L));
                if (rec == 0L || count == 0) {
                    this.params = ICPPTemplateParameter.EMPTY_TEMPLATE_PARAMETER_ARRAY;
                } else {
                    IPDOMCPPTemplateParameter[] allParams = PDOMTemplateParameterArray.getArray(this, rec);
                    if ((count = Math.min(count, allParams.length)) == allParams.length) {
                        this.params = allParams;
                    } else {
                        this.params = new ICPPTemplateParameter[count];
                        System.arraycopy(allParams, 0, this.params, 0, count);
                    }
                }
            }
            catch (CoreException e) {
                CCorePlugin.log((Throwable)e);
                this.params = ICPPTemplateParameter.EMPTY_TEMPLATE_PARAMETER_ARRAY;
            }
        }
        return this.params;
    }

    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        super.update(linkage, newBinding);
        if (newBinding instanceof ICPPClassTemplate) {
            ICPPClassTemplate ct = (ICPPClassTemplate)newBinding;
            try {
                this.updateTemplateParameters(linkage, ct.getTemplateParameters());
            }
            catch (DOMException e) {
                CCorePlugin.log((Throwable)e);
            }
        }
    }

    private void updateTemplateParameters(PDOMLinkage linkage, ICPPTemplateParameter[] newParams) throws CoreException, DOMException {
        Database db = this.getDB();
        long rec = db.getRecPtr(this.record + 42L);
        IPDOMCPPTemplateParameter[] allParams = rec == 0L ? IPDOMCPPTemplateParameter.EMPTY_ARRAY : PDOMTemplateParameterArray.getArray(this, rec);
        int newParamLength = newParams.length;
        int[] props = new int[allParams.length];
        int[] result = new int[newParamLength];
        int additionalPars = 0;
        boolean reorder = false;
        int i = 0;
        while (i < props.length) {
            IPDOMCPPTemplateParameter par = allParams[i];
            props[i] = this.getProperty(par);
            ++i;
        }
        i = 0;
        while (i < newParamLength) {
            block12: {
                ICPPTemplateParameter newPar = newParams[i];
                int prop = this.getProperty(newPar);
                int j = 0;
                while (j < props.length) {
                    if (props[j] == prop) {
                        result[i] = j;
                        props[j] = -1;
                        allParams[j].update(linkage, newPar);
                        if (j != i) {
                            reorder = true;
                        }
                        break block12;
                    }
                    ++j;
                }
                result[i] = -1;
                ++additionalPars;
            }
            ++i;
        }
        if (additionalPars > 0 || reorder) {
            this.params = null;
            IPDOMCPPTemplateParameter[] newAllParams = new IPDOMCPPTemplateParameter[allParams.length + additionalPars];
            int j = 0;
            while (j < newParamLength) {
                int idx = result[j];
                if (idx >= 0) {
                    newAllParams[j] = allParams[idx];
                    allParams[idx] = null;
                } else {
                    newAllParams[j] = PDOMTemplateParameterArray.createPDOMTemplateParameter((PDOMLinkage)this.getLinkage(), this, newParams[j]);
                }
                ++j;
            }
            int pos = newParamLength;
            int j2 = 0;
            while (j2 < allParams.length) {
                IPDOMCPPTemplateParameter unused = allParams[j2];
                if (unused != null) {
                    newAllParams[pos++] = unused;
                }
                ++j2;
            }
            if (rec != 0L) {
                db.free(rec);
            }
            rec = PDOMTemplateParameterArray.putArray(db, newAllParams);
            db.putRecPtr(this.record + 42L, rec);
        }
        db.putShort(this.record + 46L, (short)newParamLength);
    }

    private int getProperty(ICPPTemplateParameter par) {
        int result = par.getParameterPosition() & 0xFFFF;
        if (par instanceof ICPPTemplateTypeParameter) {
            return result;
        }
        if (par instanceof ICPPTemplateNonTypeParameter) {
            return result | 0x10000;
        }
        return result | 0x20000;
    }

    private PDOMCPPClassTemplatePartialSpecialization getFirstPartial() throws CoreException {
        long value = this.getDB().getRecPtr(this.record + 48L);
        return value != 0L ? new PDOMCPPClassTemplatePartialSpecialization((PDOMLinkage)this.getLinkage(), value) : null;
    }

    public void addPartial(PDOMCPPClassTemplatePartialSpecialization partial) throws CoreException {
        PDOMCPPClassTemplatePartialSpecialization first = this.getFirstPartial();
        partial.setNextPartial(first);
        this.getDB().putRecPtr(this.record + 48L, partial.getRecord());
    }

    public ICPPClassTemplatePartialSpecialization[] getPartialSpecializations() throws DOMException {
        try {
            ArrayList<PDOMCPPClassTemplatePartialSpecialization> partials = new ArrayList<PDOMCPPClassTemplatePartialSpecialization>();
            PDOMCPPClassTemplatePartialSpecialization partial = this.getFirstPartial();
            while (partial != null) {
                partials.add(partial);
                partial = partial.getNextPartial();
            }
            return partials.toArray(new ICPPClassTemplatePartialSpecialization[partials.size()]);
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return new ICPPClassTemplatePartialSpecialization[0];
        }
    }

    public boolean isSameType(IType type) {
        ICPPClassType ctype;
        block10: {
            block9: {
                PDOMNode node;
                if (type instanceof ITypedef) {
                    return type.isSameType(this);
                }
                if (type instanceof PDOMNode && (node = (PDOMNode)((Object)type)).getPDOM() == this.getPDOM()) {
                    return node.getRecord() == this.getRecord();
                }
                if (!(type instanceof ICPPClassTemplate) || type instanceof ProblemBinding) {
                    return false;
                }
                if (type instanceof ICPPClassTemplatePartialSpecialization || type instanceof ICPPTemplateTemplateParameter || type instanceof ICPPClassSpecialization) {
                    return false;
                }
                try {
                    ctype = (ICPPClassType)type;
                    if (ctype.getKey() == this.getKey()) break block9;
                    return false;
                }
                catch (DOMException dOMException) {
                    return false;
                }
            }
            char[] nchars = ctype.getNameCharArray();
            if (nchars.length == 0) {
                nchars = ASTTypeUtil.createNameForAnonymous(ctype);
            }
            if (nchars != null && CharArrayUtils.equals(nchars, this.getNameCharArray())) break block10;
            return false;
        }
        return SemanticUtil.isSameOwner(this.getOwner(), ctype.getOwner());
    }

    public ICPPTemplateInstance getInstance(ICPPTemplateArgument[] arguments) {
        return PDOMInstanceCache.getCache(this).getInstance(arguments);
    }

    public void addInstance(ICPPTemplateArgument[] arguments, ICPPTemplateInstance instance) {
        PDOMInstanceCache.getCache(this).addInstance(arguments, instance);
    }

    public ICPPTemplateInstance[] getAllInstances() {
        return PDOMInstanceCache.getCache(this).getAllInstances();
    }

    public ICPPTemplateParameter adaptTemplateParameter(ICPPTemplateParameter param) {
        short pos = param.getParameterPosition();
        ICPPTemplateParameter[] pars = this.getTemplateParameters();
        if (pars == null || pos >= pars.length) {
            return null;
        }
        ICPPTemplateParameter result = pars[pos];
        if (param instanceof ICPPTemplateTypeParameter ? result instanceof ICPPTemplateTypeParameter : (param instanceof ICPPTemplateNonTypeParameter ? result instanceof ICPPTemplateNonTypeParameter : param instanceof ICPPTemplateTemplateParameter && result instanceof ICPPTemplateTemplateParameter)) {
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICPPDeferredClassInstance asDeferredInstance() throws DOMException {
        PDOMInstanceCache cache;
        PDOMInstanceCache pDOMInstanceCache = cache = PDOMInstanceCache.getCache(this);
        synchronized (pDOMInstanceCache) {
            ICPPDeferredClassInstance dci = cache.getDeferredInstance();
            if (dci == null) {
                dci = this.createDeferredInstance();
                cache.putDeferredInstance(dci);
            }
            return dci;
        }
    }

    protected ICPPDeferredClassInstance createDeferredInstance() throws DOMException {
        ICPPTemplateArgument[] args = CPPTemplates.templateParametersAsArguments(this.getTemplateParameters());
        return new CPPDeferredClassInstance(this, args, this.getCompositeScope());
    }
}

