/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.utils.core;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.ptp.utils.core.ICopier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisjointBitSets<K>
implements Iterable<Entry<K>> {
    private final Map<K, BitSet> bitSetMap = new HashMap<K, BitSet>();
    private final BitSet unionOfBitSets;
    private ICopier<K> keyCopier;

    public DisjointBitSets() {
        this((ICopier<K>)null);
    }

    public DisjointBitSets(DisjointBitSets<K> other) {
        this.keyCopier = other.keyCopier;
        this.unionOfBitSets = (BitSet)other.unionOfBitSets.clone();
        for (Map.Entry<K, BitSet> entry : other.bitSetMap.entrySet()) {
            K key = entry.getKey();
            this.bitSetMap.put(key, (BitSet)entry.getValue().clone());
        }
    }

    public DisjointBitSets(ICopier<K> keyCopier) {
        this.keyCopier = keyCopier;
        this.unionOfBitSets = new BitSet();
    }

    public DisjointBitSets(int nBits) {
        this(nBits, null);
    }

    public DisjointBitSets(int nBits, ICopier<K> keyCopier) {
        this.keyCopier = keyCopier;
        this.unionOfBitSets = new BitSet(nBits);
    }

    public void andNot(BitSet set) {
        if (set == null) {
            throw new NullPointerException("set may not be null");
        }
        this.unionOfBitSets.andNot(set);
        boolean foundEmpties = false;
        for (Map.Entry<K, BitSet> entry : this.bitSetMap.entrySet()) {
            BitSet indicesForAttr = entry.getValue();
            indicesForAttr.andNot(set);
            boolean bl = foundEmpties = foundEmpties || indicesForAttr.isEmpty();
        }
        if (foundEmpties) {
            this.removeEmptyBitSets();
        }
    }

    public void andNot(K key, BitSet set) {
        if (key == null) {
            throw new NullPointerException("key may not be null");
        }
        if (set == null) {
            throw new NullPointerException("set may not be null");
        }
        BitSet bitset = this.bitSetMap.get(key);
        if (bitset == null) {
            return;
        }
        this.unionOfBitSets.andNot(bitset);
        bitset.andNot(set);
        if (bitset.isEmpty()) {
            this.bitSetMap.remove(key);
        } else {
            this.unionOfBitSets.or(bitset);
        }
    }

    public void clear() {
        this.unionOfBitSets.clear();
        this.bitSetMap.clear();
    }

    public DisjointBitSets<K> copy() {
        return new DisjointBitSets<K>(this);
    }

    public BitSet getBitSet(K key) {
        if (key == null) {
            throw new NullPointerException("key may not be null");
        }
        BitSet bitSet = this.bitSetMap.get(key);
        if (bitSet == null) {
            return new BitSet();
        }
        return (BitSet)bitSet.clone();
    }

    public K getKey(int bitIndex) {
        for (Map.Entry<K, BitSet> entry : this.bitSetMap.entrySet()) {
            BitSet bitSetForEntry = entry.getValue();
            if (!bitSetForEntry.get(bitIndex)) continue;
            K entryKey = entry.getKey();
            return this.copyKey(entryKey);
        }
        return null;
    }

    public ICopier<K> getKeyCopier() {
        return this.keyCopier;
    }

    public Set<K> getKeys() {
        HashSet<K> keySet = new HashSet<K>();
        for (K key : this.bitSetMap.keySet()) {
            keySet.add(this.copyKey(key));
        }
        return keySet;
    }

    public DisjointBitSets<K> getSubset(BitSet bitset) {
        if (bitset == null) {
            throw new NullPointerException("bitset may not be null");
        }
        DisjointBitSets<K> subSet = new DisjointBitSets<K>(bitset.size(), this.keyCopier);
        subSet.unionOfBitSets.or(this.unionOfBitSets);
        subSet.unionOfBitSets.and(bitset);
        if (subSet.unionOfBitSets.isEmpty()) {
            return subSet;
        }
        for (Map.Entry<K, BitSet> entry : this.bitSetMap.entrySet()) {
            BitSet bitSetForEntry = (BitSet)entry.getValue().clone();
            bitSetForEntry.and(bitset);
            if (bitSetForEntry.isEmpty()) continue;
            K entryKey = entry.getKey();
            subSet.bitSetMap.put(entryKey, bitSetForEntry);
        }
        return subSet;
    }

    public BitSet getUnion() {
        return (BitSet)this.unionOfBitSets.clone();
    }

    public boolean intersects(BitSet bitset) {
        if (bitset == null) {
            throw new NullPointerException("bitset may not be null");
        }
        return this.unionOfBitSets.intersects(bitset);
    }

    public boolean isEmpty() {
        return this.unionOfBitSets.isEmpty();
    }

    @Override
    public Iterator<Entry<K>> iterator() {
        ArrayList<Entry<K>> copyList = new ArrayList<Entry<K>>(this.bitSetMap.size());
        for (Map.Entry<K, BitSet> entry : this.bitSetMap.entrySet()) {
            K copyEntryKey = this.copyKey(entry.getKey());
            BitSet copyEntryBitSet = (BitSet)entry.getValue().clone();
            copyList.add(new Entry<K>(copyEntryKey, copyEntryBitSet));
        }
        return copyList.iterator();
    }

    public void or(K key, BitSet bitset) {
        this.innerSetBitSet(key, bitset, false);
    }

    public void put(K key, BitSet bitset) {
        this.innerSetBitSet(key, bitset, true);
    }

    public void remove(K key) {
        if (key == null) {
            throw new NullPointerException("key may not be null");
        }
        BitSet bitset = this.bitSetMap.get(key);
        if (bitset == null) {
            return;
        }
        this.unionOfBitSets.andNot(bitset);
        this.bitSetMap.remove(key);
    }

    public void setKeyCopier(ICopier<K> keyCopier) {
        this.keyCopier = keyCopier;
    }

    public String toString() {
        return this.bitSetMap.toString();
    }

    private K copyKey(K key) {
        if (this.keyCopier == null) {
            return key;
        }
        return this.keyCopier.copy(key);
    }

    private void innerSetBitSet(K key, BitSet bitset, boolean setting) {
        BitSet oldAttrIndices;
        if (key == null) {
            throw new NullPointerException("key may not be null");
        }
        if (bitset == null) {
            throw new NullPointerException("bitset may not be null");
        }
        if (setting && (oldAttrIndices = this.bitSetMap.get(key)) != null) {
            this.unionOfBitSets.andNot(oldAttrIndices);
        }
        this.unionOfBitSets.or(bitset);
        boolean equalsCaseHandled = false;
        boolean foundEmpties = false;
        for (Map.Entry<K, BitSet> entry : this.bitSetMap.entrySet()) {
            K entryKey = entry.getKey();
            BitSet bitSetForEntry = entry.getValue();
            if (!key.equals(entryKey)) {
                bitSetForEntry.andNot(bitset);
            } else {
                if (setting) {
                    bitSetForEntry.clear();
                }
                bitSetForEntry.or(bitset);
                equalsCaseHandled = true;
            }
            boolean bl = foundEmpties = foundEmpties || bitSetForEntry.isEmpty();
        }
        if (!equalsCaseHandled) {
            this.bitSetMap.put(key, (BitSet)bitset.clone());
        }
        if (foundEmpties) {
            this.removeEmptyBitSets();
        }
    }

    private void removeEmptyBitSets() {
        ArrayList<Map.Entry<K, BitSet>> entryList = new ArrayList<Map.Entry<K, BitSet>>(this.bitSetMap.entrySet());
        for (Map.Entry entry : entryList) {
            BitSet indicesForEntry = (BitSet)entry.getValue();
            if (!indicesForEntry.isEmpty()) continue;
            Object key = entry.getKey();
            this.bitSetMap.remove(key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry<X>
    implements Map.Entry<X, BitSet> {
        private final BitSet bitSet;
        private final X x;

        public Entry(X x, BitSet bitSet) {
            this.x = x;
            this.bitSet = bitSet;
        }

        @Override
        public X getKey() {
            return this.x;
        }

        @Override
        public BitSet getValue() {
            return this.bitSet;
        }

        @Override
        public BitSet setValue(BitSet value) {
            throw new UnsupportedOperationException();
        }
    }
}

