/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.openmpi.core.rmsystem;

import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.ptp.rm.core.rmsystem.AbstractEffectiveToolRMConfiguration;
import org.eclipse.ptp.rm.core.rmsystem.IToolRMConfiguration;
import org.eclipse.ptp.rm.mpi.openmpi.core.OpenMPIPreferenceManager;
import org.eclipse.ptp.rm.mpi.openmpi.core.rmsystem.IOpenMPIResourceManagerConfiguration;

public class EffectiveOpenMPIResourceManagerConfiguration
extends AbstractEffectiveToolRMConfiguration {
    private static final String BINDIR = "bin";

    public EffectiveOpenMPIResourceManagerConfiguration(IToolRMConfiguration configuration) {
        super(configuration);
        IOpenMPIResourceManagerConfiguration conf = (IOpenMPIResourceManagerConfiguration)configuration;
        String launchCmd = null;
        String debugCmd = null;
        String discoverCmd = null;
        String remoteInstallPath = null;
        if (conf.getUseToolDefaults()) {
            String version = conf.getDetectedVersion();
            if (version.equals("0.0") && conf.getVersionId().equals("auto")) {
                Preferences preferences = OpenMPIPreferenceManager.getPreferences();
                discoverCmd = preferences.getString("openmpi-auto-discoverCmd");
            } else if (version.equals("1.2")) {
                Preferences preferences = OpenMPIPreferenceManager.getPreferences();
                launchCmd = preferences.getString("openmpi-1.2-launchCmd");
                debugCmd = preferences.getString("openmpi-1.2-debugCmd");
                discoverCmd = preferences.getString("openmpi-1.2-discoverCmd");
            } else if (version.equals("1.3")) {
                Preferences preferences = OpenMPIPreferenceManager.getPreferences();
                launchCmd = preferences.getString("openmpi-1.3-launchCmd");
                debugCmd = preferences.getString("openmpi-1.3-debugCmd");
                discoverCmd = preferences.getString("openmpi-1.3-discoverCmd");
            } else if (version.equals("1.4")) {
                Preferences preferences = OpenMPIPreferenceManager.getPreferences();
                launchCmd = preferences.getString("openmpi-1.4-launchCmd");
                debugCmd = preferences.getString("openmpi-1.4-debugCmd");
                discoverCmd = preferences.getString("openmpi-1.4-discoverCmd");
            } else assert (false);
        } else {
            launchCmd = conf.getLaunchCmd();
            debugCmd = conf.getDebugCmd();
            discoverCmd = conf.getDiscoverCmd();
        }
        remoteInstallPath = conf.getRemoteInstallPath();
        this.applyValues(launchCmd, debugCmd, discoverCmd, null, 0, null, remoteInstallPath);
    }

    protected String completeCommand(String command) {
        String prefix = this.getConfiguration().getRemoteInstallPath();
        if (prefix == null || prefix.length() == 0) {
            return command;
        }
        return new Path(prefix).append(BINDIR).append(command.trim()).toString();
    }
}

