/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.core;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.debug.core.IPDebugConstants;
import org.eclipse.ptp.debug.core.IPDebugger;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.event.PDebugEvent;
import org.eclipse.ptp.debug.core.event.PDebugRegisterInfo;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.debug.core.messages.Messages;
import org.eclipse.ptp.debug.core.model.IPAddressBreakpoint;
import org.eclipse.ptp.debug.core.model.IPBreakpoint;
import org.eclipse.ptp.debug.core.model.IPDebugTarget;
import org.eclipse.ptp.debug.core.model.IPFunctionBreakpoint;
import org.eclipse.ptp.debug.core.model.IPLineBreakpoint;
import org.eclipse.ptp.debug.core.model.IPWatchpoint;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.model.IPDITarget;
import org.eclipse.ptp.debug.internal.core.PSession;
import org.eclipse.ptp.debug.internal.core.PSessionManager;
import org.eclipse.ptp.debug.internal.core.breakpoint.PAddressBreakpoint;
import org.eclipse.ptp.debug.internal.core.breakpoint.PFunctionBreakpoint;
import org.eclipse.ptp.debug.internal.core.breakpoint.PLineBreakpoint;
import org.eclipse.ptp.debug.internal.core.breakpoint.PWatchpoint;
import org.eclipse.ptp.debug.internal.core.model.PDebugTarget;

public class PDebugModel {
    private final PSessionManager sessionMgr = new PSessionManager();

    public static IPAddressBreakpoint createAddressBreakpoint(String module, String sourceHandle, IResource resource, BigInteger address, boolean enabled, int ignoreCount, String condition, boolean register, String set_id, String job_id, String jobName) throws CoreException {
        return PDebugModel.createAddressBreakpoint(module, sourceHandle, resource, -1, address, enabled, ignoreCount, condition, register, set_id, job_id, jobName);
    }

    public static IPAddressBreakpoint createAddressBreakpoint(String module, String sourceHandle, IResource resource, int lineNumber, BigInteger address, boolean enabled, int ignoreCount, String condition, boolean register, String set_id, String job_id, String jobName) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("org.eclipse.debug.core.id", PDebugModel.getPluginIdentifier());
        attributes.put("charStart", new Integer(-1));
        attributes.put("charEnd", new Integer(-1));
        attributes.put("lineNumber", new Integer(lineNumber));
        attributes.put("org.eclipse.debug.core.enabled", enabled);
        attributes.put("org.eclipse.ptp.debug.core.address", address.toString(10));
        attributes.put("org.eclipse.ptp.debug.core.sourceHandle", sourceHandle);
        attributes.put("org.eclipse.ptp.debug.core.ignoreCount", new Integer(ignoreCount));
        attributes.put("org.eclipse.ptp.debug.core.condition", condition);
        attributes.put("org.eclipse.ptp.debug.core.setid", set_id);
        attributes.put("org.eclipse.ptp.debug.core.cursetid", set_id);
        attributes.put("org.eclipse.ptp.debug.core.jobid", job_id);
        attributes.put("org.eclipse.ptp.debug.core.jobname", jobName);
        return new PAddressBreakpoint(resource, attributes, register);
    }

    public static IPFunctionBreakpoint createFunctionBreakpoint(String sourceHandle, IResource resource, String function, int charStart, int charEnd, int lineNumber, boolean enabled, int ignoreCount, String condition, boolean register, String set_id, String job_id, String jobName) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("org.eclipse.debug.core.id", PDebugModel.getPluginIdentifier());
        attributes.put("charStart", new Integer(charStart));
        attributes.put("charEnd", new Integer(charEnd));
        attributes.put("lineNumber", new Integer(lineNumber));
        attributes.put("org.eclipse.debug.core.enabled", enabled);
        attributes.put("org.eclipse.ptp.debug.core.function", function);
        attributes.put("org.eclipse.ptp.debug.core.sourceHandle", sourceHandle);
        attributes.put("org.eclipse.ptp.debug.core.ignoreCount", new Integer(ignoreCount));
        attributes.put("org.eclipse.ptp.debug.core.condition", condition);
        return new PFunctionBreakpoint(resource, attributes, register);
    }

    public static IPLineBreakpoint createLineBreakpoint(String sourceHandle, IResource resource, int lineNumber, boolean enabled, int ignoreCount, String condition, boolean register, String set_id, IPJob job) throws CoreException {
        IPSession session;
        String job_id = IPBreakpoint.GLOBAL;
        String jobName = IPBreakpoint.GLOBAL;
        if (job != null && job.getState() != JobAttributes.State.COMPLETED && (session = PTPDebugCorePlugin.getDebugModel().getSession(job)) != null) {
            job_id = job.getID();
            jobName = job.getName();
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("org.eclipse.debug.core.id", PDebugModel.getPluginIdentifier());
        attributes.put("lineNumber", new Integer(lineNumber));
        attributes.put("org.eclipse.debug.core.enabled", new Boolean(enabled));
        attributes.put("org.eclipse.ptp.debug.core.sourceHandle", sourceHandle);
        attributes.put("org.eclipse.ptp.debug.core.ignoreCount", new Integer(ignoreCount));
        attributes.put("org.eclipse.ptp.debug.core.condition", condition);
        attributes.put("org.eclipse.ptp.debug.core.setid", set_id);
        attributes.put("org.eclipse.ptp.debug.core.cursetid", set_id);
        attributes.put("org.eclipse.ptp.debug.core.jobid", job_id);
        attributes.put("org.eclipse.ptp.debug.core.jobname", jobName);
        return new PLineBreakpoint(resource, attributes, register);
    }

    public static IPWatchpoint createWatchpoint(String sourceHandle, IResource resource, boolean writeAccess, boolean readAccess, String expression, boolean enabled, int ignoreCount, String condition, boolean register, String set_id, String job_id, String jobName) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("org.eclipse.debug.core.id", PDebugModel.getPluginIdentifier());
        attributes.put("org.eclipse.debug.core.enabled", enabled);
        attributes.put("org.eclipse.ptp.debug.core.sourceHandle", sourceHandle);
        attributes.put("org.eclipse.ptp.debug.core.ignoreCount", new Integer(ignoreCount));
        attributes.put("org.eclipse.ptp.debug.core.condition", condition);
        attributes.put("org.eclipse.ptp.debug.core.expression", expression);
        attributes.put("org.eclipse.ptp.debug.core.read", readAccess);
        attributes.put("org.eclipse.ptp.debug.core.write", writeAccess);
        return new PWatchpoint(resource, attributes, register);
    }

    public static IPWatchpoint createWatchpoint(String sourceHandle, IResource resource, int charStart, int charEnd, int lineNumber, boolean writeAccess, boolean readAccess, String expression, boolean enabled, int ignoreCount, String condition, boolean register, String set_id, String job_id, String jobName) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("org.eclipse.debug.core.id", PDebugModel.getPluginIdentifier());
        attributes.put("charStart", new Integer(charStart));
        attributes.put("charEnd", new Integer(charEnd));
        attributes.put("lineNumber", new Integer(lineNumber));
        attributes.put("org.eclipse.debug.core.enabled", enabled);
        attributes.put("org.eclipse.ptp.debug.core.sourceHandle", sourceHandle);
        attributes.put("org.eclipse.ptp.debug.core.ignoreCount", new Integer(ignoreCount));
        attributes.put("org.eclipse.ptp.debug.core.condition", condition);
        attributes.put("org.eclipse.ptp.debug.core.expression", expression);
        attributes.put("org.eclipse.ptp.debug.core.read", readAccess);
        attributes.put("org.eclipse.ptp.debug.core.write", writeAccess);
        return new PWatchpoint(resource, attributes, register);
    }

    public static void deletePBreakpoint(String job_id) throws CoreException {
        IBreakpoint[] breakpoints = PDebugModel.findPBreakpoints(job_id, false);
        if (breakpoints.length > 0) {
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpoints(breakpoints, true);
        }
    }

    public static void deletePBreakpoint(String job_id, String set_id) throws CoreException {
        IBreakpoint[] breakpoints = PDebugModel.findPBreakpoints(job_id, set_id);
        if (breakpoints.length > 0) {
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpoints(breakpoints, true);
        }
    }

    public static IPBreakpoint[] findPBreakpoints(String job_id, boolean includeGlobal) throws CoreException {
        IBreakpoint[] breakpoints;
        ArrayList<IPBreakpoint> bptList = new ArrayList<IPBreakpoint>();
        IBreakpoint[] iBreakpointArray = breakpoints = PDebugModel.getPBreakpoints();
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IPBreakpoint breakpoint;
            String bp_job_id;
            IBreakpoint bpt = iBreakpointArray[n2];
            if (bpt instanceof IPBreakpoint && ((bp_job_id = (breakpoint = (IPBreakpoint)bpt).getJobId()).equals(job_id) || includeGlobal && bp_job_id.equals(IPBreakpoint.GLOBAL))) {
                bptList.add(breakpoint);
            }
            ++n2;
        }
        return bptList.toArray(new IPBreakpoint[bptList.size()]);
    }

    public static IPBreakpoint[] findPBreakpoints(String job_id, String set_id) throws CoreException {
        IBreakpoint[] breakpoints;
        ArrayList<IPBreakpoint> bptList = new ArrayList<IPBreakpoint>();
        IBreakpoint[] iBreakpointArray = breakpoints = PDebugModel.getPBreakpoints();
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IPBreakpoint breakpoint;
            IBreakpoint bpt = iBreakpointArray[n2];
            if (bpt instanceof IPBreakpoint && (breakpoint = (IPBreakpoint)bpt).getJobId().equals(job_id) && breakpoint.getSetId().equals(set_id)) {
                bptList.add(breakpoint);
            }
            ++n2;
        }
        return bptList.toArray(new IPBreakpoint[0]);
    }

    public static IPFunctionBreakpoint[] functionBreakpointExists(String sourceHandle, IResource resource, String function) throws CoreException {
        IBreakpoint[] breakpoints = PDebugModel.getPBreakpoints();
        ArrayList<IPFunctionBreakpoint> foundBreakpoints = new ArrayList<IPFunctionBreakpoint>(0);
        String markerType = PFunctionBreakpoint.getMarkerType();
        int i = 0;
        while (i < breakpoints.length) {
            IPFunctionBreakpoint breakpoint;
            if (breakpoints[i] instanceof IPFunctionBreakpoint && (breakpoint = (IPFunctionBreakpoint)breakpoints[i]).getMarker().getType().equals(markerType) && PDebugModel.sameSourceHandle(sourceHandle, breakpoint.getSourceHandle()) && breakpoint.getMarker().getResource().equals((Object)resource) && breakpoint.getFunction() != null && breakpoint.getFunction().equals(function)) {
                foundBreakpoints.add(breakpoint);
            }
            ++i;
        }
        return foundBreakpoints.toArray(new IPFunctionBreakpoint[0]);
    }

    public static IBreakpoint[] getPBreakpoints() {
        return DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(PDebugModel.getPluginIdentifier());
    }

    public static String getPluginIdentifier() {
        return PTPDebugCorePlugin.getUniqueIdentifier();
    }

    public static IPLineBreakpoint lineBreakpointExists(IPLineBreakpoint[] breakpoints, IPJob job) throws CoreException {
        int i = 0;
        while (i < breakpoints.length) {
            String bpt_job_id = breakpoints[i].getJobId();
            if (bpt_job_id.equals(IPBreakpoint.GLOBAL) || job != null && bpt_job_id.equals(job.getID())) {
                return breakpoints[i];
            }
            ++i;
        }
        return null;
    }

    public static IPLineBreakpoint[] lineBreakpointsExists(String sourceHandle, IResource resource, int lineNumber) throws CoreException {
        IBreakpoint[] breakpoints = PDebugModel.getPBreakpoints();
        ArrayList<IPLineBreakpoint> foundBreakpoints = new ArrayList<IPLineBreakpoint>(0);
        int i = 0;
        while (i < breakpoints.length) {
            IPLineBreakpoint breakpoint;
            if (breakpoints[i] instanceof IPLineBreakpoint && PDebugModel.sameSourceHandle(sourceHandle, (breakpoint = (IPLineBreakpoint)breakpoints[i]).getSourceHandle()) && breakpoint.getMarker().getResource().equals((Object)resource) && breakpoint.getLineNumber() == lineNumber) {
                foundBreakpoints.add(breakpoint);
            }
            ++i;
        }
        return foundBreakpoints.toArray(new IPLineBreakpoint[0]);
    }

    public static void updatePBreakpoints(String set_id, IProgressMonitor monitor) throws CoreException {
        try {
            IBreakpoint[] breakpoints = PDebugModel.getPBreakpoints();
            monitor.beginTask(Messages.PDebugModel_0, breakpoints.length);
            IBreakpoint[] iBreakpointArray = breakpoints;
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint bpt = iBreakpointArray[n2];
                if (bpt instanceof IPBreakpoint) {
                    ((IPBreakpoint)bpt).setCurSetId(set_id);
                    monitor.worked(1);
                }
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    public static IPWatchpoint[] watchpointExists(String sourceHandle, IResource resource, String expression) throws CoreException {
        IBreakpoint[] breakpoints = PDebugModel.getPBreakpoints();
        ArrayList<IPWatchpoint> foundBreakpoints = new ArrayList<IPWatchpoint>(0);
        String markerType = PWatchpoint.getMarkerType();
        int i = 0;
        while (i < breakpoints.length) {
            IPWatchpoint breakpoint;
            if (breakpoints[i] instanceof IPWatchpoint && (breakpoint = (IPWatchpoint)breakpoints[i]).getMarker().getType().equals(markerType) && PDebugModel.sameSourceHandle(sourceHandle, breakpoint.getSourceHandle()) && breakpoint.getMarker().getResource().equals((Object)resource) && breakpoint.getExpression().equals(expression)) {
                foundBreakpoints.add(breakpoint);
            }
            ++i;
        }
        return foundBreakpoints.toArray(new IPWatchpoint[0]);
    }

    private static boolean sameSourceHandle(String handle1, String handle2) {
        if (handle1 == null || handle2 == null) {
            return false;
        }
        Path path1 = new Path(handle1);
        Path path2 = new Path(handle2);
        if (path1.isValidPath(handle1) && path2.isValidPath(handle2)) {
            return path1.equals((Object)path2);
        }
        return handle1.equals(handle2);
    }

    public void addNewDebugTargets(final IPLaunch launch, final TaskSet tasks, final IPDITarget[] pdiTargets, final boolean refresh, final boolean resumeTarget) {
        WorkspaceJob aJob = new WorkspaceJob(Messages.PDebugModel_1){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                boolean allowTerminate = true;
                boolean allowDisconnect = false;
                IPSession session = PDebugModel.this.getSession(launch.getPJob());
                if (session == null) {
                    return Status.CANCEL_STATUS;
                }
                IPDITarget[] iPDITargetArray = pdiTargets;
                int n = pdiTargets.length;
                int n2 = 0;
                while (n2 < n) {
                    IPDITarget pdiTarget = iPDITargetArray[n2];
                    PDebugTarget target = new PDebugTarget(session, pdiTarget, allowTerminate, allowDisconnect);
                    if (resumeTarget) {
                        try {
                            session.getPDISession().resume(target.getTasks(), false);
                        }
                        catch (PDIException e) {
                            PTPDebugCorePlugin.log(e);
                        }
                    }
                    launch.addDebugTarget(target);
                    ++n2;
                }
                PDebugModel.this.fireRegisterEvent(launch.getPJob(), tasks, refresh);
                return Status.OK_STATUS;
            }
        };
        aJob.setSystem(true);
        aJob.schedule();
    }

    public void addTasks(IPSession session, String set_id, TaskSet tasks) {
        TaskSet curSetTasks = this.getTasks(session, set_id);
        session.getSetManager().addTasks(set_id, tasks);
        tasks.andNot(curSetTasks);
        try {
            IPBreakpoint[] breakpoints = PDebugModel.findPBreakpoints(session.getJob().getID(), set_id);
            session.getBreakpointManager().addSetBreakpoints(tasks, breakpoints);
        }
        catch (CoreException e) {
            PTPDebugCorePlugin.log(e);
        }
    }

    public IPSession createDebugSession(IPDebugger debugger, IPLaunch launch, IProject project, IPath coreFile) throws CoreException {
        long timeout = PTPDebugCorePlugin.getDefault().getPluginPreferences().getLong(IPDebugConstants.PREF_PTP_DEBUG_COMM_TIMEOUT);
        IPDISession pdiSession = debugger.createDebugSession(timeout, launch, coreFile);
        PSession session = new PSession(pdiSession, launch, project);
        this.sessionMgr.addSession(launch.getPJob(), session);
        return session;
    }

    public void createSet(IPSession session, String set_id, TaskSet tasks) {
        session.getSetManager().createSet(set_id, tasks);
    }

    public void deleteSet(IPSession session, String set_id) {
        try {
            PDebugModel.deletePBreakpoint(session.getJob().getID(), set_id);
        }
        catch (CoreException e) {
            PTPDebugCorePlugin.log(e);
        }
        session.getSetManager().deleteSets(set_id);
    }

    public void fireRegisterEvent(IPJob job, TaskSet tasks, boolean refresh) {
        IPSession session;
        if (!tasks.isEmpty() && (session = this.getSession(job)) != null) {
            PDebugRegisterInfo info = new PDebugRegisterInfo(job, tasks, null, null, refresh);
            PTPDebugCorePlugin.getDefault().fireDebugEvent(new PDebugEvent(session, 4, 2048, info));
        }
    }

    public void fireUnregisterEvent(IPJob job, TaskSet tasks, boolean refresh) {
        IPSession session;
        if (!tasks.isEmpty() && (session = this.getSession(job)) != null) {
            PDebugRegisterInfo info = new PDebugRegisterInfo(job, tasks, null, null, refresh);
            PTPDebugCorePlugin.getDefault().fireDebugEvent(new PDebugEvent(session, 8, 2048, info));
        }
    }

    public IPSession getSession(IPJob job) {
        return this.sessionMgr.getSession(job);
    }

    public TaskSet getTasks(IPSession session, String set_id) {
        TaskSet tasks = session.getSetManager().getTasks(set_id);
        if (tasks != null) {
            return tasks.copy();
        }
        return null;
    }

    public void removeDebugTarget(final IPLaunch launch, final TaskSet tasks, final boolean refresh) {
        WorkspaceJob aJob = new WorkspaceJob(Messages.PDebugModel_2){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                int[] taskArray;
                int[] nArray = taskArray = tasks.toArray();
                int n = taskArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int task = nArray[n2];
                    IPDebugTarget target = launch.getDebugTarget(task);
                    if (target != null) {
                        target.dispose();
                        launch.removeDebugTarget(target);
                    }
                    ++n2;
                }
                PDebugModel.this.fireUnregisterEvent(launch.getPJob(), tasks, refresh);
                return Status.OK_STATUS;
            }
        };
        aJob.setSystem(true);
        aJob.schedule();
    }

    public void removeTasks(IPSession session, String set_id, TaskSet tasks) {
        TaskSet curSetTasks = this.getTasks(session, set_id);
        session.getSetManager().removeTasks(set_id, tasks);
        tasks.and(curSetTasks);
        try {
            IPBreakpoint[] breakpoints = PDebugModel.findPBreakpoints(session.getJob().getID(), set_id);
            session.getBreakpointManager().deleteSetBreakpoints(tasks, breakpoints);
        }
        catch (CoreException e) {
            PTPDebugCorePlugin.log(e);
        }
    }

    public void shutdown() {
        IPSession[] iPSessionArray = this.sessionMgr.getSessions();
        int n = iPSessionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPSession session = iPSessionArray[n2];
            this.shutdownSession(session);
            ++n2;
        }
        this.sessionMgr.shutdown();
    }

    public void shutdownSession(IPSession session) {
        if (session != null) {
            try {
                PDebugModel.deletePBreakpoint(session.getJob().getID());
            }
            catch (CoreException e) {
                PTPDebugCorePlugin.log(e);
            }
            session.dispose();
        }
    }

    public void shutdownSession(IPJob job) {
        if (job != null) {
            this.shutdownSession(this.getSession(job));
        }
    }
}

