/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.server.dstore.core;

import org.eclipse.dstore.core.client.ClientConnection;
import org.eclipse.dstore.core.client.ConnectionStatus;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.ptp.rdt.server.dstore.internal.core.DebugUtil;
import org.eclipse.ptp.rdt.server.dstore.messages.Messages;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.remote.launch.core.AbstractRemoteServerRunner;

public class DStoreServer
extends AbstractRemoteServerRunner {
    public static String SERVER_ID = "org.eclipse.ptp.rdt.server.dstore.RemoteToolsDStoreServer";
    private DStoreState fState = DStoreState.STARTING;
    private ClientConnection fDStoreConnection = null;
    private int fDStorePort = 0;
    private static final String SUCCESS_STRING = "Server Started Successfully";

    public DStoreServer() {
        super(Messages.DStoreServer_0);
    }

    public DataStore getDataStore() {
        if (this.fDStoreConnection == null) {
            this.fDStoreConnection = new ClientConnection(this.getRemoteConnection().getName());
        }
        return this.fDStoreConnection.getDataStore();
    }

    protected void doFinishServer() {
        if (this.fDStoreConnection != null) {
            this.fDStoreConnection.disconnect();
            this.fDStoreConnection = null;
        }
    }

    protected boolean doRestartServer() {
        this.fState = DStoreState.STARTING;
        return true;
    }

    protected boolean doStartServer() {
        int port;
        try {
            port = this.getRemoteConnection().forwardLocalPort("localhost", this.fDStorePort, null);
        }
        catch (RemoteConnectionException e) {
            if (DebugUtil.SERVER_TRACING) {
                System.err.println(String.valueOf(Messages.DStoreServer_1) + e.getLocalizedMessage());
            }
            return false;
        }
        this.fDStoreConnection.setHost("localhost");
        this.fDStoreConnection.setPort(Integer.toString(port));
        if (DebugUtil.SERVER_TRACING) {
            System.out.println(Messages.DStoreServer_2);
        }
        ConnectionStatus status = this.fDStoreConnection.connect(null, 0);
        DataStore dataStore = this.fDStoreConnection.getDataStore();
        dataStore.showTicket(null);
        dataStore.registerLocalClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        if (DebugUtil.SERVER_TRACING) {
            System.out.println(Messages.DStoreServer_3);
        }
        return status.isConnected();
    }

    protected boolean doVerifyServerRunningFromStderr(String output) {
        switch (this.fState) {
            case STARTING: {
                if (!output.startsWith(SUCCESS_STRING)) break;
                this.fState = DStoreState.WAITING;
                break;
            }
            case WAITING: {
                if (!output.matches("^[0-9]+$")) break;
                this.fDStorePort = Integer.parseInt(output);
                this.fState = DStoreState.STARTED;
                break;
            }
            case STARTED: {
                return true;
            }
        }
        return false;
    }

    protected boolean doVerifyServerRunningFromStdout(String output) {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DStoreState {
        STARTING,
        WAITING,
        STARTED;

    }
}

