/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.pbs.ui.wizards;

import java.io.IOException;
import java.io.OutputStreamWriter;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.ptp.rm.pbs.ui.PBSServiceProvider;
import org.eclipse.ptp.rm.pbs.ui.data.PBSBatchScriptTemplate;
import org.eclipse.ptp.rm.pbs.ui.dialogs.ComboEntryDialog;
import org.eclipse.ptp.rm.pbs.ui.dialogs.ScrollingEditableMessageDialog;
import org.eclipse.ptp.rm.pbs.ui.managers.PBSBatchScriptTemplateManager;
import org.eclipse.ptp.rm.pbs.ui.messages.Messages;
import org.eclipse.ptp.rm.pbs.ui.providers.AttributeContentProvider;
import org.eclipse.ptp.rm.pbs.ui.providers.AttributeLabelProvider;
import org.eclipse.ptp.rm.pbs.ui.utils.WidgetUtils;
import org.eclipse.ptp.ui.wizards.IRMConfigurationWizard;
import org.eclipse.ptp.ui.wizards.RMConfigurationWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class PBSBatchScriptTemplateWizardPage
extends RMConfigurationWizardPage {
    private boolean isValid;
    private ConfigurationChangeListener listener;
    private final PBSServiceProvider provider;
    private TableViewer readOnlyView;
    private final PBSBatchScriptTemplateManager templateManager;
    private Combo templates;

    public PBSBatchScriptTemplateWizardPage(IRMConfigurationWizard wizard) throws Throwable {
        super(wizard, Messages.PBSConfigurationWizardPage_name);
        this.setTitle(Messages.PBSConfigurationWizardPage_title);
        this.setDescription(Messages.PBSConfigurationWizardPage_description);
        this.templateManager = new PBSBatchScriptTemplateManager();
        this.provider = (PBSServiceProvider)wizard.getConfiguration();
        this.setValid(true);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        composite.setLayout((Layout)topLayout);
        this.createContents(composite);
        String last = this.provider.getDefaultTemplateName();
        String[] items = this.templates.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(last)) {
                this.templates.select(i);
                break;
            }
            ++i;
        }
        if (i == items.length) {
            this.templates.select(0);
        }
        this.setControl((Control)composite);
    }

    public void fireModifyTemplateChoice(String choice) {
        this.templateManager.loadTemplate(choice, null);
        this.provider.setDefaultTemplateName(choice);
        this.updateSettings();
    }

    private void createContents(Composite parent) {
        Group templateContainer = WidgetUtils.createFillingGroup(parent, Messages.PBSRMLaunchConfigGroup0_title, 2, 1, false);
        this.listener = new ConfigurationChangeListener();
        String[] available = this.templateManager.findAvailableTemplates();
        this.templates = WidgetUtils.createItemCombo((Composite)templateContainer, Messages.PBSRMLaunchConfigTemplate_title, available, available[0], Messages.PBSRMLaunchConfigTemplate_message, true, this.listener, 1);
        WidgetUtils.createButton((Composite)templateContainer, Messages.PBSRMLaunchConfigEditButton_title, null, 8, 1, true, new EditConfigurationSelectionAdapter());
        WidgetUtils.createButton((Composite)templateContainer, Messages.PBSRMLaunchConfigDeleteButton_title, null, 8, 1, true, new DeleteConfigurationSelectionAdapter());
        Group preferencesContainer = WidgetUtils.createFillingGroup(parent, Messages.PBSRMLaunchConfigPreferences_message, 1, 1, false);
        Table t = WidgetUtils.createFillingTable((Composite)preferencesContainer, 3, 500, 1, 65538);
        this.readOnlyView = new TableViewer(t);
        this.readOnlyView.setContentProvider((IContentProvider)new AttributeContentProvider());
        this.readOnlyView.setLabelProvider((IBaseLabelProvider)new AttributeLabelProvider());
        WidgetUtils.addTableColumn(this.readOnlyView, Messages.PBSRMLaunchConfigPreferences_column_0, 16384, null);
        WidgetUtils.addTableColumn(this.readOnlyView, Messages.PBSRMLaunchConfigPreferences_column_1, 16384, null);
        WidgetUtils.addTableColumn(this.readOnlyView, Messages.PBSRMLaunchConfigPreferences_column_2, 16384, null);
        this.readOnlyView.getTable().setHeaderVisible(true);
    }

    private void setValid(boolean b) {
        this.isValid = b;
        this.setPageComplete(this.isValid);
    }

    private void updateSettings() {
        PBSBatchScriptTemplate o = this.templateManager.getCurrent();
        if (o == null) {
            this.readOnlyView.setInput((Object)this);
        } else {
            this.readOnlyView.setInput((Object)o);
        }
    }

    private void updateTemplates() {
        this.listener.toggleIgnore();
        String text = this.templates.getText();
        this.templates.setItems(this.templateManager.findAvailableTemplates());
        this.templates.setText(text);
        this.listener.toggleIgnore();
    }

    private class ConfigurationChangeListener
    implements ModifyListener,
    SelectionListener,
    ISelectionChangedListener {
        private boolean ignore = false;

        private ConfigurationChangeListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (!this.ignore() && e.getSource() == PBSBatchScriptTemplateWizardPage.this.templates) {
                String choice = PBSBatchScriptTemplateWizardPage.this.templates.getText();
                PBSBatchScriptTemplateWizardPage.this.fireModifyTemplateChoice(choice);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSource() == PBSBatchScriptTemplateWizardPage.this.readOnlyView) {
                PBSBatchScriptTemplateWizardPage.this.updateSettings();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
        }

        private synchronized boolean ignore() {
            return this.ignore;
        }

        private synchronized void toggleIgnore() {
            this.ignore = !this.ignore;
        }
    }

    private class DeleteConfigurationSelectionAdapter
    implements SelectionListener {
        private DeleteConfigurationSelectionAdapter() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            try {
                Shell shell = PBSBatchScriptTemplateWizardPage.this.getShell();
                String[] availableTemplates = PBSBatchScriptTemplateWizardPage.this.templateManager.findAvailableTemplates();
                ComboEntryDialog comboDialog = new ComboEntryDialog(shell, Messages.PBSRMLaunchConfigDeleteChoose_message, availableTemplates);
                if (comboDialog.open() == 1) {
                    return;
                }
                String name = comboDialog.getChoice();
                PBSBatchScriptTemplateWizardPage.this.templateManager.removeTemplate(name);
                PBSBatchScriptTemplateWizardPage.this.updateTemplates();
                if (name.equals(PBSBatchScriptTemplateWizardPage.this.templates.getText())) {
                    PBSBatchScriptTemplateWizardPage.this.templates.deselectAll();
                    PBSBatchScriptTemplateWizardPage.this.fireModifyTemplateChoice("");
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                WidgetUtils.errorMessage(PBSBatchScriptTemplateWizardPage.this.getShell(), t, Messages.PBSRMLaunchConfigDeleteError_message, Messages.PBSRMLaunchConfigDeleteError_title, false);
            }
        }
    }

    private class EditConfigurationSelectionAdapter
    implements SelectionListener {
        private EditConfigurationSelectionAdapter() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            OutputStreamWriter fw = null;
            try {
                Shell shell = PBSBatchScriptTemplateWizardPage.this.getShell();
                String newName = null;
                String oldName = null;
                String[] availableTemplates = PBSBatchScriptTemplateWizardPage.this.templateManager.findAvailableTemplates();
                ComboEntryDialog comboDialog = new ComboEntryDialog(shell, Messages.PBSRMLaunchConfigEditChoose_message, availableTemplates);
                if (comboDialog.open() == 1) {
                    return;
                }
                oldName = comboDialog.getChoice();
                InputDialog nameDialog = new InputDialog(shell, String.valueOf(Messages.PBSRMLaunchConfigEditChoose_new) + "?", Messages.PBSRMLaunchConfigEditChoose_new_name, null, null);
                newName = nameDialog.open() == 1 ? oldName : nameDialog.getValue();
                newName = PBSBatchScriptTemplateWizardPage.this.templateManager.validateTemplateNameForEdit(newName);
                PBSBatchScriptTemplate template = PBSBatchScriptTemplateWizardPage.this.templateManager.loadTemplate(oldName, null);
                ScrollingEditableMessageDialog dialog = new ScrollingEditableMessageDialog(PBSBatchScriptTemplateWizardPage.this.getShell(), Messages.PBSRMLaunchConfigEditChoose_message, template.getText());
                if (dialog.open() == 1) {
                    return;
                }
                try {
                    String edited = dialog.getValue();
                    PBSBatchScriptTemplateWizardPage.this.templateManager.storeTemplate(edited, newName);
                    PBSBatchScriptTemplateWizardPage.this.updateTemplates();
                    if (newName.equals(PBSBatchScriptTemplateWizardPage.this.templates.getText())) {
                        PBSBatchScriptTemplateWizardPage.this.fireModifyTemplateChoice(newName);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    WidgetUtils.errorMessage(PBSBatchScriptTemplateWizardPage.this.getShell(), t, Messages.PBSRMLaunchConfigEditError_message, Messages.PBSRMLaunchConfigEditError_title, false);
                }
            }
            finally {
                if (fw != null) {
                    try {
                        fw.close();
                    }
                    catch (IOException t) {
                        t.printStackTrace();
                    }
                }
            }
        }
    }
}

