/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ptp.core.IModelManager;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.elementcontrols.IPUniverseControl;
import org.eclipse.ptp.core.elementcontrols.IResourceManagerControl;
import org.eclipse.ptp.core.elements.IPUniverse;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.attributes.ResourceManagerAttributes;
import org.eclipse.ptp.core.elements.events.IResourceManagerErrorEvent;
import org.eclipse.ptp.core.listeners.IModelManagerChildListener;
import org.eclipse.ptp.core.messages.Messages;
import org.eclipse.ptp.internal.core.elements.PUniverse;
import org.eclipse.ptp.internal.core.events.ChangedResourceManagerEvent;
import org.eclipse.ptp.internal.core.events.NewResourceManagerEvent;
import org.eclipse.ptp.internal.core.events.RemoveResourceManagerEvent;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceModelEvent;
import org.eclipse.ptp.services.core.IServiceModelEventListener;
import org.eclipse.ptp.services.core.IServiceModelManager;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.ServiceModelManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelManager
implements IModelManager {
    private IServiceModelEventListener fServiceEventListener = new IServiceModelEventListener(){

        public void handleEvent(IServiceModelEvent event) {
            switch (event.getType()) {
                case 1: {
                    IServiceProvider provider = ((IServiceConfiguration)event.getSource()).getServiceProvider(ModelManager.this.fLaunchService);
                    if (provider == null || !(provider instanceof IResourceManagerConfiguration)) break;
                    ModelManager.this.addResourceManager(((IResourceManagerConfiguration)provider).createResourceManager());
                    break;
                }
                case 2: {
                    IResourceManagerControl rm;
                    IServiceProvider provider = ((IServiceConfiguration)event.getSource()).getServiceProvider(ModelManager.this.fLaunchService);
                    if (provider == null || !(provider instanceof IResourceManagerConfiguration) || (rm = (IResourceManagerControl)ModelManager.this.getResourceManagerFromUniqueName(((IResourceManagerConfiguration)provider).getUniqueName())) == null) break;
                    ModelManager.this.removeResourceManager(rm);
                    break;
                }
                case 4: {
                    IResourceManagerControl rm;
                    IServiceProvider newProvider;
                    IServiceConfiguration config = (IServiceConfiguration)event.getSource();
                    IServiceProvider oldProvider = event.getOldProvider();
                    if (oldProvider == null || !(oldProvider instanceof IResourceManagerConfiguration) || (newProvider = config.getServiceProvider(ModelManager.this.fLaunchService)) == null || !(newProvider instanceof IResourceManagerConfiguration) || (rm = (IResourceManagerControl)ModelManager.this.getResourceManagerFromUniqueName(((IResourceManagerConfiguration)oldProvider).getUniqueName())) == null) break;
                    rm.setConfiguration((IResourceManagerConfiguration)newProvider);
                    break;
                }
                case 64: {
                    IResourceManager rm;
                    IServiceProvider provider = (IServiceProvider)event.getSource();
                    if (provider == null || !(provider instanceof IResourceManagerConfiguration) || (rm = ModelManager.this.getResourceManagerFromUniqueName(((IResourceManagerConfiguration)provider).getUniqueName())) == null) break;
                    ModelManager.this.updateResourceManager(rm);
                }
            }
        }
    };
    private final ListenerList resourceManagerListeners = new ListenerList();
    protected final IServiceModelManager fServiceManager = ServiceModelManager.getInstance();
    protected IService fLaunchService = this.fServiceManager.getService("org.eclipse.ptp.core.LaunchService");
    protected IPUniverseControl universe = new PUniverse();

    public ModelManager() {
        this.fServiceManager.addEventListener(this.fServiceEventListener, 71);
    }

    @Override
    public void addListener(IModelManagerChildListener listener) {
        this.resourceManagerListeners.add((Object)listener);
    }

    @Override
    public synchronized void addResourceManager(IResourceManagerControl rm) {
        this.universe.addResourceManager(rm);
        this.fireNewResourceManager(rm);
    }

    @Override
    public synchronized void addResourceManagers(IResourceManagerControl[] rms) {
        IResourceManagerControl[] iResourceManagerControlArray = rms;
        int n = rms.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceManagerControl rm = iResourceManagerControlArray[n2];
            this.addResourceManager(rm);
            ++n2;
        }
    }

    @Override
    public IResourceManager getResourceManagerFromUniqueName(String rmUniqueName) {
        IPUniverse universe = this.getUniverse();
        if (universe != null) {
            IResourceManager[] rms;
            IResourceManager[] iResourceManagerArray = rms = universe.getResourceManagers();
            int n = rms.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceManager rm = iResourceManagerArray[n2];
                if (rm.getUniqueName().equals(rmUniqueName)) {
                    return rm;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public IResourceManager[] getStartedResourceManagers(IPUniverse universe) {
        IResourceManager[] rms = universe.getResourceManagers();
        ArrayList<IResourceManager> startedRMs = new ArrayList<IResourceManager>(rms.length);
        IResourceManager[] iResourceManagerArray = rms;
        int n = rms.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceManager rm = iResourceManagerArray[n2];
            if (rm.getState() == ResourceManagerAttributes.State.STARTED) {
                startedRMs.add(rm);
            }
            ++n2;
        }
        return startedRMs.toArray(new IResourceManager[startedRMs.size()]);
    }

    @Override
    public IPUniverse getUniverse() {
        return this.universe;
    }

    public void handleEvent(IResourceManagerErrorEvent e) {
    }

    @Override
    public void loadResourceManagers() throws CoreException {
        HashSet<IResourceManagerControl> rmsNeedStarting = new HashSet<IResourceManagerControl>();
        this.fServiceManager.getActiveConfiguration();
        IResourceManager[] iResourceManagerArray = this.getUniverse().getResourceManagers();
        int n = iResourceManagerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceManager rm = iResourceManagerArray[n2];
            IResourceManagerControl rmControl = (IResourceManagerControl)rm;
            if (rmControl.getConfiguration().getAutoStart()) {
                rmsNeedStarting.add(rmControl);
            }
            ++n2;
        }
        if (PTPCorePlugin.getDefault().getPluginPreferences().getBoolean("autoStartRMs")) {
            this.startResourceManagers(rmsNeedStarting.toArray(new IResourceManagerControl[0]));
        }
    }

    @Override
    public void removeListener(IModelManagerChildListener listener) {
        this.resourceManagerListeners.remove((Object)listener);
    }

    @Override
    public synchronized void removeResourceManager(IResourceManagerControl rm) {
        this.universe.removeResourceManager(rm);
        this.fireRemoveResourceManager(rm);
    }

    @Override
    public synchronized void removeResourceManagers(IResourceManagerControl[] rms) {
        IResourceManagerControl[] iResourceManagerControlArray = rms;
        int n = rms.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceManagerControl rm = iResourceManagerControlArray[n2];
            this.removeResourceManager(rm);
            ++n2;
        }
    }

    @Override
    public void saveResourceManagers() {
    }

    @Override
    public void shutdown() throws CoreException {
        this.saveResourceManagers();
        this.stopResourceManagers();
        this.shutdownResourceManagers();
        this.resourceManagerListeners.clear();
    }

    @Override
    public void start() throws CoreException {
        this.loadResourceManagers();
    }

    @Override
    public void stopResourceManagers() throws CoreException {
        IResourceManager[] resourceManagers = this.universe.getResourceManagers();
        int i = 0;
        while (i < resourceManagers.length) {
            resourceManagers[i].shutdown();
            ++i;
        }
    }

    @Override
    public void updateResourceManager(IResourceManager rm) {
        this.fireChangedResourceManager(Arrays.asList(rm));
    }

    private void fireChangedResourceManager(Collection<IResourceManager> rms) {
        ChangedResourceManagerEvent event = new ChangedResourceManagerEvent(this, rms);
        Object[] objectArray = this.resourceManagerListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IModelManagerChildListener)listener).handleEvent(event);
            ++n2;
        }
    }

    private void fireNewResourceManager(IResourceManager rm) {
        NewResourceManagerEvent event = new NewResourceManagerEvent(this, rm);
        Object[] objectArray = this.resourceManagerListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IModelManagerChildListener)listener).handleEvent(event);
            ++n2;
        }
    }

    private void fireRemoveResourceManager(IResourceManager rm) {
        RemoveResourceManagerEvent event = new RemoveResourceManagerEvent(this, rm);
        Object[] objectArray = this.resourceManagerListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IModelManagerChildListener)listener).handleEvent(event);
            ++n2;
        }
    }

    private synchronized void shutdownResourceManagers() {
        IResourceManagerControl[] resourceManagers = this.universe.getResourceManagerControls();
        int i = 0;
        while (i < resourceManagers.length) {
            resourceManagers[i].dispose();
            ++i;
        }
    }

    private void startResourceManagers(IResourceManagerControl[] rmsNeedStarting) throws CoreException {
        IResourceManagerControl[] iResourceManagerControlArray = rmsNeedStarting;
        int n = rmsNeedStarting.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceManagerControl rm = iResourceManagerControlArray[n2];
            RMStartupJob job = new RMStartupJob(rm);
            job.schedule();
            ++n2;
        }
    }

    private class RMStartupJob
    extends Job {
        private IResourceManagerControl resourceManager;

        public RMStartupJob(IResourceManagerControl rm) {
            super(String.valueOf(Messages.ModelManager_0) + rm.getName());
            this.resourceManager = rm;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                try {
                    monitor.beginTask(Messages.ModelManager_1, 100);
                    this.resourceManager.startUp((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                }
                catch (CoreException e) {
                    IStatus iStatus = e.getStatus();
                    monitor.done();
                    return iStatus;
                }
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                monitor.done();
            }
        }
    }
}

