/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.analysis.types.Type;
import org.eclipse.photran.internal.core.analysis.types.TypeChecker;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTAssignmentStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEntityDeclNode;
import org.eclipse.photran.internal.core.parser.ASTTypeDeclarationStmtNode;
import org.eclipse.photran.internal.core.parser.ASTUseStmtNode;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.IActionStmt;
import org.eclipse.photran.internal.core.parser.IBodyConstruct;
import org.eclipse.photran.internal.core.parser.IExpr;
import org.eclipse.photran.internal.core.parser.ISpecificationPartConstruct;
import org.eclipse.photran.internal.core.parser.ISpecificationStmt;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranEditorRefactoring;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranResourceRefactoring;
import org.eclipse.photran.internal.core.refactoring.infrastructure.Reindenter;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractLocalVariableRefactoring
extends FortranEditorRefactoring {
    private IExpr selectedExpr;
    private IActionStmt enclosingStmt;
    private IASTListNode enclosingStmtList;
    private ScopingNode enclosingScope;
    private String decl = null;
    private ASTTypeDeclarationStmtNode declToInsert = null;
    private String name;

    public String getName() {
        return "Extract Local Variable";
    }

    public void setDecl(String decl) {
        assert (decl != null);
        this.decl = decl;
    }

    public String getDecl() {
        assert (this.decl != null);
        return this.decl;
    }

    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        Type exprType;
        this.ensureProjectHasRefactoringEnabled(status);
        IASTNode selection = ExtractLocalVariableRefactoring.findEnclosingNode(this.astOfFileInEditor, this.selectedRegionInEditor);
        if (selection == null || !(selection instanceof IExpr)) {
            this.fail("Please select an expression to extract.");
        }
        if (!ExtractLocalVariableRefactoring.nodeExactlyEnclosesRegion(selection, this.astOfFileInEditor, this.selectedRegionInEditor)) {
            this.fail("You have selected part of an expression, but either (1) the part you have selected is not an expression by itself, or (2) extracting that portion of the expression could change the meaning of the larger expression, due to a change in associativity or precedence.");
        }
        this.selectedExpr = (IExpr)selection;
        this.enclosingStmt = this.selectedExpr.findNearestAncestor(IActionStmt.class);
        if (this.enclosingStmt == null) {
            this.fail("Variables can only be extracted from action statements (e.g., assignments, print statements, etc.).");
        }
        if (!(this.enclosingStmt.getParent() instanceof IASTListNode)) {
            this.fail("The selected expression is not located in a statement from which a variable can be extracted.");
        }
        this.enclosingStmtList = (IASTListNode)this.enclosingStmt.getParent();
        this.enclosingScope = this.enclosingStmt.findNearestAncestor(ScopingNode.class);
        if (this.enclosingScope == null) {
            this.fail("Variables can only be extracted from action statements inside functions, subroutines, and main programs.");
        }
        if ((exprType = TypeChecker.getTypeOf(this.selectedExpr)) == Type.TYPE_ERROR) {
            status.addWarning("The type of the expression could not be determined automatically.");
            this.decl = "real :: newName";
        } else {
            this.decl = String.valueOf(exprType.toString()) + " :: newName";
        }
    }

    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        IBodyConstruct decl;
        assert (this.decl != null);
        status.addWarning("If any functions in the original or extracted expression have side effects, this refactoring may not preserve behavior.");
        if (this.decl.trim().equals("")) {
            this.fail("Please enter a declaration for the extracted variable.");
        }
        if ((decl = ExtractLocalVariableRefactoring.parseLiteralStatementNoFail(this.decl)) == null || !(decl instanceof ASTTypeDeclarationStmtNode)) {
            this.fail("The text entered (\"" + this.decl + "\") is not a valid type declaration statement.");
        }
        this.declToInsert = (ASTTypeDeclarationStmtNode)decl;
        if (this.declToInsert.getEntityDeclList() == null || this.declToInsert.getEntityDeclList().size() != 1) {
            this.fail("The declaration entered does not declare a single variable.");
        }
        this.name = ((ASTEntityDeclNode)this.declToInsert.getEntityDeclList().get(0)).getObjectName().getObjectName().getText();
        if (((ASTEntityDeclNode)this.declToInsert.getEntityDeclList().get(0)).getInitialization() != null) {
            this.fail("The declaration must not contain an initialization.");
        }
        this.checkForConflictingBindings(pm, status);
    }

    private void checkForConflictingBindings(IProgressMonitor pm, RefactoringStatus status) {
        Definition def = this.arbitraryDefinitionInScope();
        if (def == null) {
            return;
        }
        ExtractLocalVariableRefactoring.checkForConflictingBindings(pm, (FortranResourceRefactoring.IConflictingBindingCallback)new ConflictingBindingErrorHandler(status), def, Collections.<PhotranTokenRef>emptyList(), this.name);
    }

    private Definition arbitraryDefinitionInScope() {
        List<Definition> allDefs = this.enclosingScope.getAllDefinitions();
        if (allDefs.isEmpty()) {
            return null;
        }
        return allDefs.get(0);
    }

    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        assert (this.declToInsert != null);
        try {
            this.insertDeclaration();
            this.insertAssignment();
            this.replaceExpression();
            this.addChangeFromModifiedAST(this.fileInEditor, pm);
        }
        finally {
            ((PhotranVPG)this.vpg).releaseAllASTs();
        }
    }

    private void insertDeclaration() {
        IASTListNode<? extends IASTNode> body = this.enclosingScope.getBody();
        body.add(this.findIndexToInsertDeclarationIn(body), this.declToInsert);
        Reindenter.reindent(this.declToInsert, this.astOfFileInEditor);
    }

    private int findIndexToInsertDeclarationIn(IASTListNode<? extends IASTNode> body) {
        int lastTypeDeclStmt = -1;
        int lastSpecStmt = -1;
        int lastUseStmt = -1;
        int i = 0;
        while (i < body.size()) {
            IASTNode thisStmt = (IASTNode)body.get(i);
            if (thisStmt instanceof ASTTypeDeclarationStmtNode) {
                lastTypeDeclStmt = i;
            }
            if (thisStmt instanceof ISpecificationPartConstruct || thisStmt instanceof ISpecificationStmt) {
                lastSpecStmt = i;
            }
            if (thisStmt instanceof ASTUseStmtNode) {
                lastUseStmt = i;
            }
            ++i;
        }
        if (lastTypeDeclStmt >= 0) {
            return lastTypeDeclStmt + 1;
        }
        if (lastSpecStmt >= 0) {
            return lastSpecStmt + 1;
        }
        if (lastUseStmt >= 0) {
            return lastUseStmt + 1;
        }
        return 0;
    }

    private void insertAssignment() {
        IExpr expr = (IExpr)this.selectedExpr.clone();
        expr.findFirstToken().setWhiteBefore("");
        ASTAssignmentStmtNode assignmentStmt = (ASTAssignmentStmtNode)ExtractLocalVariableRefactoring.parseLiteralStatement(String.valueOf(this.name) + " = " + expr);
        this.enclosingStmtList.insertBefore(this.enclosingStmt, assignmentStmt);
        Reindenter.reindent(assignmentStmt, this.astOfFileInEditor);
    }

    private void replaceExpression() {
        IExpr variable = ExtractLocalVariableRefactoring.parseLiteralExpression(this.name.trim());
        variable.findFirstToken().setWhiteBefore(this.selectedExpr.findFirstToken().getWhiteBefore());
        this.selectedExpr.replaceWith(variable);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ConflictingBindingErrorHandler
    implements FortranResourceRefactoring.IConflictingBindingCallback {
        private final RefactoringStatus status;

        private ConflictingBindingErrorHandler(RefactoringStatus status) {
            this.status = status;
        }

        @Override
        public void addConflictError(List<FortranResourceRefactoring.Conflict> conflictingDef) {
            FortranResourceRefactoring.Conflict conflict = conflictingDef.get(0);
            String msg = "The name \"" + conflict.name + "\" conflicts with " + ((PhotranVPG)ExtractLocalVariableRefactoring.this.vpg).getDefinitionFor(conflict.tokenRef);
            RefactoringStatusContext context = ExtractLocalVariableRefactoring.this.createContext(conflict.tokenRef);
            this.status.addError(msg, context);
        }

        @Override
        public void addConflictWarning(List<FortranResourceRefactoring.Conflict> conflictingDef) {
            FortranResourceRefactoring.Conflict conflict = conflictingDef.get(0);
            String msg = "The name \"" + conflict.name + "\" might conflict with the name of an invoked subprogram";
            RefactoringStatusContext context = ExtractLocalVariableRefactoring.this.createContext(conflict.tokenRef);
            this.status.addWarning(msg, context);
        }

        @Override
        public void addReferenceWillChangeError(String newName, Token reference) {
            throw new IllegalStateException();
        }
    }
}

