/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer;

import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.core.dom.IPDOMIndexer;
import org.eclipse.cdt.core.model.ICProject;

public abstract class AbstractPDOMIndexer
implements IPDOMIndexer {
    protected ICProject project;
    protected Properties fProperties = new Properties();

    public AbstractPDOMIndexer() {
        this.fProperties.put("indexAllFiles", String.valueOf(true));
        this.fProperties.put("indexUnusedHeadersWithDefaultLang", String.valueOf(false));
        this.fProperties.put("indexUnusedHeadersWithAlternateLang", String.valueOf(false));
        this.fProperties.put("indexAllFiles", String.valueOf(false));
        this.fProperties.put("useHeuristicIncludeResolution", String.valueOf(true));
        this.fProperties.put("skipFilesLargerThanMB", String.valueOf(8));
        this.fProperties.put("filesToParseUpFront", "");
        this.fProperties.put("skipReferences", String.valueOf(false));
        this.fProperties.put("skipImplicitReferences", String.valueOf(false));
        this.fProperties.put("skipTypeReferences", String.valueOf(false));
        this.fProperties.put("skipMacroReferences", String.valueOf(false));
    }

    public ICProject getProject() {
        return this.project;
    }

    public void setProject(ICProject project) {
        this.project = project;
    }

    public String getProperty(String key) {
        return this.fProperties.getProperty(key);
    }

    public boolean needsToRebuildForProperties(Properties props) {
        for (Map.Entry<Object, Object> entry : this.fProperties.entrySet()) {
            String v2;
            String key = (String)entry.getKey();
            String myval = (String)entry.getValue();
            if (myval == null || (v2 = (String)props.get(key)) == null || myval.equals(v2)) continue;
            return true;
        }
        return false;
    }

    public Properties getProperties() {
        return this.fProperties;
    }

    public void setProperties(Properties props) {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            if (val == null || this.fProperties.get(key) == null) continue;
            this.fProperties.put(key, val);
        }
    }

    public String[] getFilesToParseUpFront() {
        String prefSetting = this.getProperty("filesToParseUpFront");
        if (prefSetting != null && (prefSetting = prefSetting.trim()).length() > 0) {
            return prefSetting.split(",");
        }
        return new String[0];
    }
}

