/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.core.rtsystem;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.util.DebugUtil;
import org.eclipse.ptp.proxy.runtime.client.AbstractProxyRuntimeClient;
import org.eclipse.ptp.proxy.runtime.command.IProxyRuntimeCommandFactory;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeEventFactory;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.rm.core.messages.Messages;
import org.eclipse.ptp.rm.core.rmsystem.IRemoteResourceManagerConfiguration;

public abstract class AbstractRemoteProxyRuntimeClient
extends AbstractProxyRuntimeClient {
    private IRemoteConnection connection = null;
    private IProgressMonitor startupMonitor = null;
    private IRemoteResourceManagerConfiguration config;

    public AbstractRemoteProxyRuntimeClient(IRemoteResourceManagerConfiguration config, int baseModelId) {
        super(config.getName(), baseModelId);
        this.config = config;
        this.initDebugOptions();
    }

    public AbstractRemoteProxyRuntimeClient(IRemoteResourceManagerConfiguration config, int baseModelId, IProxyRuntimeCommandFactory cmdFactory, IProxyRuntimeEventFactory eventFactory) {
        super(config.getName(), baseModelId, cmdFactory, eventFactory);
        this.config = config;
        this.initDebugOptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws IOException {
        super.shutdown();
        try {
            this.sessionFinish();
        }
        catch (IOException e) {
            PTPCorePlugin.log((Throwable)e);
        }
        AbstractRemoteProxyRuntimeClient abstractRemoteProxyRuntimeClient = this;
        synchronized (abstractRemoteProxyRuntimeClient) {
            if (this.startupMonitor != null) {
                this.startupMonitor.setCanceled(true);
            }
        }
        if (this.connection != null && this.connection.isOpen()) {
            this.connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void startup(IProgressMonitor monitor) throws IOException {
        block47: {
            block46: {
                block45: {
                    block49: {
                        subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)12);
                        if (this.getDebugOptions().CLIENT_TRACING) {
                            System.out.println(String.valueOf(this.toString()) + " - firing up proxy, waiting for connection.  Please wait!  This can take a minute . . .");
                            System.out.println("PROXY_SERVER path = '" + this.config.getName() + "'");
                        }
                        var3_3 = this;
                        synchronized (var3_3) {
                            this.startupMonitor = monitor;
                        }
                        monitor.subTask(Messages.AbstractRemoteProxyRuntimeClient_1);
                        remoteServices = PTPRemoteCorePlugin.getDefault().getRemoteServices(this.config.getRemoteServicesId());
                        if (remoteServices == null) {
                            throw new IOException(NLS.bind((String)Messages.AbstractRemoteProxyRuntimeClient_10, (Object)this.config.getRemoteServicesId()));
                        }
                        monitor.worked(5);
                        if (!this.config.testOption(4)) break block49;
                        monitor.subTask(Messages.AbstractRemoteProxyRuntimeClient_2);
                        this.sessionCreate();
                        monitor.worked(5);
                        args = new ArrayList<String>();
                        args.add(this.config.getProxyServerPath());
                        args.add("--proxy=tcp");
                        if (this.config.testOption(2)) {
                            args.add("--host=localhost");
                        } else {
                            args.add("--host=" + this.config.getLocalAddress());
                        }
                        args.add("--port=" + this.getSessionPort());
                        if (this.getDebugOptions().SERVER_DEBUG_LEVEL > 0) {
                            args.add("--debug=" + this.getDebugOptions().SERVER_DEBUG_LEVEL);
                        }
                        args.addAll(this.config.getInvocationOptions());
                        if (this.getDebugOptions().CLIENT_TRACING) {
                            System.out.println("Launch command: " + args.toString());
                        }
                        msg = NLS.bind((String)Messages.AbstractRemoteProxyRuntimeClient_3, (Object)args.toString());
                        monitor.subTask(msg);
                        info = new Status(1, PTPCorePlugin.getUniqueIdentifier(), 1, msg, null);
                        PTPCorePlugin.log((IStatus)info);
                        ** GOTO lbl144
                    }
                    connMgr = remoteServices.getConnectionManager();
                    this.connection = connMgr.getConnection(this.config.getConnectionName());
                    if (this.connection == null) {
                        throw new IOException(NLS.bind((String)Messages.AbstractRemoteProxyRuntimeClient_11, (Object)this.config.getConnectionName()));
                    }
                    monitor.subTask(Messages.AbstractRemoteProxyRuntimeClient_4);
                    if (!this.connection.isOpen()) {
                        this.connection.open((IProgressMonitor)subMon.newChild(4));
                    }
                    if (!monitor.isCanceled()) break block45;
                    this.connection.close();
                    var13_13 = this;
                    synchronized (var13_13) {
                        this.startupMonitor = null;
                    }
                    return;
                }
                monitor.subTask(Messages.AbstractRemoteProxyRuntimeClient_5);
                fileManager = remoteServices.getFileManager(this.connection);
                if (fileManager == null) {
                    throw new IOException(Messages.AbstractRemoteProxyRuntimeClient_9);
                }
                res = fileManager.getResource(this.config.getProxyServerPath());
                try {
                    if (!res.fetchInfo(0, (IProgressMonitor)subMon.newChild(2)).exists()) {
                        throw new IOException(NLS.bind((String)Messages.AbstractRemoteProxyRuntimeClient_12, (Object)this.config.getProxyServerPath()));
                    }
                }
                catch (CoreException v2) {
                    throw new IOException(NLS.bind((String)Messages.AbstractRemoteProxyRuntimeClient_12, (Object)this.config.getProxyServerPath()));
                }
                if (!monitor.isCanceled()) break block46;
                this.connection.close();
                var13_14 = this;
                synchronized (var13_14) {
                    this.startupMonitor = null;
                }
                return;
            }
            monitor.subTask(Messages.AbstractRemoteProxyRuntimeClient_6);
            this.sessionCreate();
            monitor.worked(1);
            args = new ArrayList<String>();
            args.add(this.config.getProxyServerPath());
            args.add("--proxy=tcp");
            if (!this.config.testOption(2)) ** GOTO lbl122
            try {
                remotePort = this.connection.forwardRemotePort("localhost", this.getSessionPort(), (IProgressMonitor)subMon.newChild(1));
            }
            catch (RemoteConnectionException e) {
                throw new IOException(e.getMessage());
            }
            if (!monitor.isCanceled()) break block47;
            this.sessionFinish();
            var13_15 = this;
            synchronized (var13_15) {
                this.startupMonitor = null;
            }
            return;
        }
        try {
            try {
                block50: {
                    args.add("--host=localhost");
                    args.add("--port=" + remotePort);
                    break block50;
lbl122:
                    // 1 sources

                    args.add("--host=" + this.config.getLocalAddress());
                    args.add("--port=" + this.getSessionPort());
                }
                if (this.getDebugOptions().SERVER_DEBUG_LEVEL > 0) {
                    args.add("--debug=" + this.getDebugOptions().SERVER_DEBUG_LEVEL);
                }
                args.addAll(this.config.getInvocationOptions());
                if (this.getDebugOptions().CLIENT_TRACING) {
                    System.out.println("Launch command: " + args.toString());
                }
                monitor.subTask(Messages.AbstractRemoteProxyRuntimeClient_7);
                processBuilder = remoteServices.getProcessBuilder(this.connection, args);
                process = processBuilder.start();
                monitor.worked(2);
                err_reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                out_reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            String output;
                            while ((output = out_reader.readLine()) != null) {
                                System.out.println(String.valueOf(AbstractRemoteProxyRuntimeClient.this.config.getName()) + ": " + output);
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }, Messages.AbstractRemoteProxyRuntimeClient_15).start();
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            String line;
                            while ((line = err_reader.readLine()) != null) {
                                System.err.println(String.valueOf(AbstractRemoteProxyRuntimeClient.this.config.getName()) + ": " + line);
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }, Messages.AbstractRemoteProxyRuntimeClient_14).start();
                if (this.getDebugOptions().CLIENT_TRACING) {
                    System.out.println(String.valueOf(this.toString()) + ": Waiting on accept.");
                }
lbl144:
                // 4 sources

                monitor.subTask(Messages.AbstractRemoteProxyRuntimeClient_8);
                super.startup();
                monitor.worked(2);
            }
            catch (IOException e) {
                try {
                    this.sessionFinish();
                }
                catch (IOException e1) {
                    PTPCorePlugin.log((Throwable)e1);
                }
                throw new IOException(NLS.bind((String)Messages.AbstractRemoteProxyRuntimeClient_13, (Object)e.getMessage()));
            }
            catch (RemoteConnectionException e) {
                throw new IOException(NLS.bind((String)Messages.AbstractRemoteProxyRuntimeClient_13, (Object)e.getMessage()));
            }
        }
        catch (Throwable var12_25) {
            var13_16 = this;
            synchronized (var13_16) {
                this.startupMonitor = null;
            }
            throw var12_25;
        }
        var13_17 = this;
        synchronized (var13_17) {
            this.startupMonitor = null;
        }
    }

    private void initDebugOptions() {
        this.getDebugOptions().PROTOCOL_TRACING = DebugUtil.PROTOCOL_TRACING;
        this.getDebugOptions().CLIENT_TRACING = DebugUtil.PROXY_CLIENT_TRACING;
        this.getDebugOptions().SERVER_DEBUG_LEVEL = DebugUtil.PROXY_SERVER_DEBUG_LEVEL;
    }
}

