/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.search;

import java.util.List;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.internal.rdt.core.model.Scope;
import org.eclipse.ptp.internal.rdt.core.search.RemoteSearchMatch;
import org.eclipse.ptp.internal.rdt.core.search.RemoteSearchQuery;
import org.eclipse.ptp.internal.rdt.core.subsystems.ICIndexSubsystem;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchMatchAdapter;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchResult;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;

public class RemoteSearchQueryAdapter
implements ISearchQuery {
    protected ICIndexSubsystem fSubsystem;
    protected RemoteSearchQuery fQuery;
    protected RemoteSearchResult fResult;
    protected Scope fScope;

    public RemoteSearchQueryAdapter(ICIndexSubsystem subsystem, Scope scope, RemoteSearchQuery query) {
        this.fSubsystem = subsystem;
        this.fScope = scope;
        this.fQuery = query;
        this.fResult = new RemoteSearchResult(this);
    }

    public boolean canRerun() {
        return this.fQuery.canRerun();
    }

    public boolean canRunInBackground() {
        return this.fQuery.canRunInBackground();
    }

    public String getLabel() {
        String type = (this.fQuery.getFlags() & 4) != 0 ? CSearchMessages.PDOMSearchQuery_refs_label : ((this.fQuery.getFlags() & 1) != 0 ? CSearchMessages.PDOMSearchQuery_decls_label : CSearchMessages.PDOMSearchQuery_defs_label);
        return type;
    }

    public ISearchResult getSearchResult() {
        return this.fResult;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        this.fSubsystem.checkAllProjects(monitor);
        RemoteSearchResult result = (RemoteSearchResult)this.getSearchResult();
        result.removeAll();
        List results = this.fSubsystem.runQuery(this.fScope, this.fQuery, monitor);
        if (results.size() > 0) {
            Match[] matches = new Match[results.size()];
            int i = 0;
            try {
                for (RemoteSearchMatch match : results) {
                    matches[i] = new RemoteSearchMatchAdapter(match);
                    ++i;
                }
                this.fResult.addMatches(matches);
            }
            catch (CoreException e) {
                CUIPlugin.log((Throwable)e);
            }
            return new Status(0, "org.eclipse.ptp.rdt.ui", "");
        }
        return new Status(0, "org.eclipse.ptp.rdt.ui", "");
    }

    public RemoteSearchQuery getQuery() {
        return this.fQuery;
    }

    public ICProject[] getProjects() {
        return new ICProject[0];
    }
}

