/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.internal.ssh;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ptp.remotetools.core.IRemoteCopyTools;
import org.eclipse.ptp.remotetools.core.IRemoteFileEnumeration;
import org.eclipse.ptp.remotetools.core.IRemoteFileTools;
import org.eclipse.ptp.remotetools.core.IRemoteItem;
import org.eclipse.ptp.remotetools.core.IRemotePathTools;
import org.eclipse.ptp.remotetools.core.messages.Messages;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.exception.RemoteException;
import org.eclipse.ptp.remotetools.exception.RemoteExecutionException;
import org.eclipse.ptp.remotetools.exception.RemoteOperationException;
import org.eclipse.ptp.remotetools.internal.ssh.ExecutionManager;
import org.eclipse.ptp.remotetools.internal.ssh.RemoteFileAttributes;
import org.eclipse.ptp.remotetools.internal.ssh.RemoteFileEnumeration;
import org.eclipse.ptp.remotetools.internal.ssh.RemoteFileRecursiveEnumeration;
import org.eclipse.ptp.remotetools.internal.ssh.RemoteItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTools
implements IRemoteFileTools {
    private static ExecutorService fPool = Executors.newSingleThreadExecutor();
    protected ExecutionManager manager;
    private int cachedUserID;
    private Set<Integer> cachedGroupIDSet;
    private String fOSName = null;

    protected FileTools(ExecutionManager manager) {
        this.manager = manager;
    }

    public String addTrailingSlash(String path) {
        if (path.endsWith("/")) {
            return path;
        }
        return String.valueOf(path) + "/";
    }

    @Override
    public void assureDirectory(String directory, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            this.test();
            this.validateRemotePath(directory);
            if (!this.hasDirectory(directory, (IProgressMonitor)subMon.newChild(5))) {
                this.createDirectory(directory, (IProgressMonitor)subMon.newChild(5));
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Override
    public boolean canExecute(String remotePath) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(remotePath);
        RemoteItem item = (RemoteItem)this.getItem(remotePath);
        return item.isExecutable();
    }

    @Override
    public boolean canRead(String remotePath) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(remotePath);
        RemoteItem item = (RemoteItem)this.getItem(remotePath);
        return item.isReadable();
    }

    @Override
    public boolean canWrite(String remotePath) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(remotePath);
        RemoteItem item = (RemoteItem)this.getItem(remotePath);
        return item.isWritable();
    }

    public void chmod(final int permissions, final String path, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            try {
                this.test();
                this.validateRemotePath(path);
                SftpCallable<Integer> c = new SftpCallable<Integer>(){

                    @Override
                    public Integer call() throws SftpException {
                        this.getChannel().chmod(permissions, path);
                        return 0;
                    }
                };
                c.syncCmdInThread(Messages.FileTools_2, (IProgressMonitor)subMon.newChild(10));
            }
            catch (IOException e) {
                throw new RemoteOperationException(e);
            }
            catch (SftpException e) {
                throw new RemoteOperationException(e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public String concatenateRemotePath(String p1, String p2) {
        if (p1.endsWith("/")) {
            return String.valueOf(p1) + p2;
        }
        return String.valueOf(p1) + "/" + p2;
    }

    @Override
    public void copyFile(String from, String to, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException {
        try {
            this.test();
            this.validateRemotePath(from);
            this.validateRemotePath(to);
            IRemotePathTools pathTool = this.manager.getRemotePathTools();
            try {
                this.executeCommand("cp -f " + pathTool.quote(from, true) + " " + pathTool.quote(to, true));
            }
            catch (RemoteExecutionException e) {
                throw new RemoteOperationException(e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Override
    public void createDirectory(String directory, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            this.test();
            this.validateRemotePath(directory);
            IRemotePathTools pathTool = this.manager.getRemotePathTools();
            final String path = pathTool.quote(directory, true);
            String parent = pathTool.parent(path);
            RemoteFileAttributes attrs = this.fetchRemoteAttr(parent, (IProgressMonitor)subMon.newChild(5));
            if (attrs == null) {
                this.createDirectory(parent, monitor);
            }
            try {
                SftpCallable<Integer> c = new SftpCallable<Integer>(){

                    @Override
                    public Integer call() throws SftpException {
                        this.getChannel().mkdir(path);
                        return 0;
                    }
                };
                c.syncCmdInThread(Messages.FileTools_3, (IProgressMonitor)subMon.newChild(5));
            }
            catch (IOException e) {
                throw new RemoteOperationException(e);
            }
            catch (SftpException e) {
                throw new RemoteOperationException(e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Override
    public void createFile(String file, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            this.test();
            this.validateRemotePath(file);
            IRemotePathTools pathTool = this.manager.getRemotePathTools();
            final String path = pathTool.quote(file, true);
            try {
                SftpCallable<Integer> c = new SftpCallable<Integer>(){

                    @Override
                    public Integer call() throws SftpException, IOException {
                        OutputStream os = this.getChannel().put(path);
                        os.close();
                        return 0;
                    }
                };
                c.syncCmdInThread(Messages.FileTools_4, (IProgressMonitor)subMon.newChild(10));
            }
            catch (IOException e) {
                throw new RemoteOperationException(e);
            }
            catch (SftpException e) {
                throw new RemoteOperationException(e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Override
    public IRemoteFileEnumeration createFileEnumeration(String path) throws RemoteOperationException, RemoteConnectionException, CancelException {
        return new RemoteFileEnumeration(this, path);
    }

    @Override
    public IRemoteFileEnumeration createRecursiveFileEnumeration(String path) throws RemoteOperationException, RemoteConnectionException, CancelException {
        return new RemoteFileRecursiveEnumeration(this, path);
    }

    public void downloadIntoOutputStream(final String remotePath, final OutputStream sink, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            try {
                this.test();
                this.validateRemotePath(remotePath);
                SftpCallable<Integer> c = new SftpCallable<Integer>(){

                    @Override
                    public Integer call() throws SftpException {
                        this.getChannel().get(remotePath, sink);
                        return 0;
                    }
                };
                c.syncCmdInThread(Messages.FileTools_5, (IProgressMonitor)subMon.newChild(10));
            }
            catch (IOException e) {
                throw new RemoteOperationException(e);
            }
            catch (SftpException e) {
                throw new RemoteOperationException(e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public Set<Integer> getCachedGroupIDSet() {
        return this.cachedGroupIDSet;
    }

    public int getCachedUserID() {
        return this.cachedUserID;
    }

    @Override
    public IRemoteItem getDirectory(String directoryPath, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException, RemoteOperationException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            this.test();
            this.validateRemotePath(directoryPath);
            directoryPath = this.removeTrailingSlash(directoryPath);
            this.cacheUserData();
            RemoteItem remfile = new RemoteItem(this, directoryPath);
            remfile.refreshAttributes((IProgressMonitor)subMon.newChild(10));
            if (!remfile.isDirectory()) {
                throw new RemoteOperationException(Messages.FileTools_6);
            }
            RemoteItem remoteItem = remfile;
            return remoteItem;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Override
    public IRemoteItem getFile(String filePath, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException, RemoteOperationException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            this.test();
            this.validateRemotePath(filePath);
            filePath = this.removeTrailingSlash(filePath);
            this.cacheUserData();
            RemoteItem remfile = new RemoteItem(this, filePath);
            remfile.refreshAttributes((IProgressMonitor)subMon.newChild(10));
            if (remfile.isDirectory()) {
                throw new RemoteOperationException(Messages.FileTools_7);
            }
            RemoteItem remoteItem = remfile;
            return remoteItem;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public InputStream getInputStream(String file, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public IRemoteItem getItem(String path) throws RemoteConnectionException, RemoteOperationException, CancelException, RemoteOperationException {
        this.test();
        this.validateRemotePath(path);
        path = this.removeTrailingSlash(path);
        this.cacheUserData();
        return new RemoteItem(this, path);
    }

    @Override
    public OutputStream getOutputStream(String file, int options, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException {
        final SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            this.test();
            this.validateRemotePath(file);
            IRemotePathTools pathTool = this.manager.getRemotePathTools();
            final String path = pathTool.quote(file, true);
            final int mode = (options & 1) == 0 ? 0 : 2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(){

                public void close() throws IOException {
                    super.close();
                    final ByteArrayInputStream is = new ByteArrayInputStream(this.toByteArray());
                    try {
                        SftpCallable<Integer> c = new SftpCallable<Integer>(FileTools.this){

                            @Override
                            public Integer call() throws SftpException, IOException {
                                SubMonitor mon = SubMonitor.convert((IProgressMonitor)this.getProgressMonitor(), (int)10);
                                this.getChannel().put(is, path, (SftpProgressMonitor)new FileToolsProgressMonitor((IProgressMonitor)mon.newChild(10)), mode);
                                is.close();
                                return 0;
                            }
                        };
                        c.syncCmdInThread(Messages.FileTools_9, (IProgressMonitor)subMon.newChild(10));
                    }
                    catch (SftpException e) {
                        throw new IOException(e.getMessage());
                    }
                    catch (RemoteException e) {
                        throw new IOException(e.getMessage());
                    }
                    catch (CancelException e) {
                        throw new IOException(e.getMessage());
                    }
                }
            };
            return byteArrayOutputStream;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Override
    public IRemoteCopyTools getRemoteCopyTools() throws RemoteConnectionException {
        return this.manager.getRemoteCopyTools();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasDirectory(String directory, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            this.test();
            this.validateRemotePath(directory);
            RemoteItem item = (RemoteItem)this.getItem(directory);
            item.refreshAttributes((IProgressMonitor)subMon.newChild(10));
            if (!item.exists()) {
                return false;
            }
            if (item.isDirectory()) return true;
            return false;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasFile(String file, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            this.test();
            this.validateRemotePath(file);
            IRemoteItem item = this.getItem(file);
            item.refreshAttributes((IProgressMonitor)subMon.newChild(10));
            if (!item.exists()) {
                return false;
            }
            if (!item.isDirectory()) return true;
            return false;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Override
    public IRemoteItem[] listItems(final String root, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            Vector files;
            this.validateRemotePath(root);
            try {
                SftpCallable<Vector<ChannelSftp.LsEntry>> c = new SftpCallable<Vector<ChannelSftp.LsEntry>>(){

                    @Override
                    public Vector<ChannelSftp.LsEntry> call() throws SftpException {
                        return this.getChannel().ls(root);
                    }
                };
                files = (Vector)c.syncCmdInThread(Messages.FileTools_10, (IProgressMonitor)subMon.newChild(10));
            }
            catch (IOException e) {
                throw new RemoteOperationException(e);
            }
            catch (SftpException e) {
                throw new RemoteOperationException(e);
            }
            this.cacheUserData();
            ArrayList<RemoteItem> result = new ArrayList<RemoteItem>();
            Enumeration enumeration = files.elements();
            while (enumeration.hasMoreElements()) {
                ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)enumeration.nextElement();
                String fileName = entry.getFilename();
                String pathName = this.concatenateRemotePath(root, fileName);
                if (fileName.equals(".") || fileName.equals("..")) continue;
                result.add(new RemoteItem(this, pathName, entry.getAttrs()));
            }
            IRemoteItem[] resultArray = new IRemoteItem[result.size()];
            result.toArray(resultArray);
            IRemoteItem[] iRemoteItemArray = resultArray;
            return iRemoteItemArray;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Override
    public void moveFile(String from, String to, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException {
        try {
            this.test();
            this.validateRemotePath(from);
            this.validateRemotePath(to);
            IRemotePathTools pathTool = this.manager.getRemotePathTools();
            try {
                this.executeCommand("mv -f " + pathTool.quote(from, true) + " " + pathTool.quote(to, true));
            }
            catch (RemoteExecutionException e) {
                throw new RemoteOperationException(e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public String parentOfRemotePath(String path) {
        int index = (path = this.removeTrailingSlash(path)).lastIndexOf(47);
        if (index == -1) {
            return null;
        }
        return this.removeTrailingSlash(path.substring(0, index));
    }

    @Override
    public void removeDirectory(String dir, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            this.test();
            this.validateRemotePath(dir);
            IRemotePathTools pathTool = this.manager.getRemotePathTools();
            final String path = pathTool.quote(dir, true);
            try {
                SftpCallable<Integer> c = new SftpCallable<Integer>(){

                    @Override
                    public Integer call() throws SftpException {
                        this.getChannel().rmdir(path);
                        return 0;
                    }
                };
                c.syncCmdInThread(Messages.FileTools_11, (IProgressMonitor)subMon.newChild(10));
            }
            catch (IOException e) {
                throw new RemoteOperationException(e);
            }
            catch (SftpException e) {
                throw new RemoteOperationException(e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Override
    public void removeFile(String file, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            this.test();
            this.validateRemotePath(file);
            IRemotePathTools pathTool = this.manager.getRemotePathTools();
            final String path = pathTool.quote(file, true);
            try {
                SftpCallable<Integer> c = new SftpCallable<Integer>(){

                    @Override
                    public Integer call() throws SftpException {
                        this.getChannel().rm(path);
                        return 0;
                    }
                };
                c.syncCmdInThread(Messages.FileTools_12, (IProgressMonitor)subMon.newChild(10));
            }
            catch (IOException e) {
                throw new RemoteOperationException(e);
            }
            catch (SftpException e) {
                throw new RemoteOperationException(e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public String removeTrailingSlash(String path) {
        if (!path.equals("/") && path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public void setMtime(final String path, final int mtime, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            try {
                this.test();
                this.validateRemotePath(path);
                SftpCallable<Integer> c = new SftpCallable<Integer>(){

                    @Override
                    public Integer call() throws SftpException {
                        this.getChannel().setMtime(path, mtime);
                        return 0;
                    }
                };
                c.syncCmdInThread(Messages.FileTools_13, (IProgressMonitor)subMon.newChild(10));
            }
            catch (IOException e) {
                throw new RemoteOperationException(e);
            }
            catch (SftpException e) {
                throw new RemoteOperationException(e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public String suffixOfRemotePath(String path) {
        int index = (path = this.removeTrailingSlash(path)).lastIndexOf(47);
        if (index == -1) {
            return null;
        }
        return this.removeTrailingSlash(path.substring(index + 1));
    }

    public void uploadFromInputStream(final InputStream source, final String remotePath, IProgressMonitor monitor) throws RemoteOperationException, RemoteConnectionException, CancelException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            try {
                this.test();
                this.validateRemotePath(remotePath);
                SftpCallable<Integer> c = new SftpCallable<Integer>(){

                    @Override
                    public Integer call() throws SftpException {
                        this.getChannel().put(source, remotePath);
                        return 0;
                    }
                };
                c.syncCmdInThread(Messages.FileTools_14, (IProgressMonitor)subMon.newChild(10));
            }
            catch (IOException e) {
                throw new RemoteOperationException(e);
            }
            catch (SftpException e) {
                throw new RemoteOperationException(e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Deprecated
    public void uploadPermissions(File file, String remoteFilePath) throws RemoteConnectionException, RemoteOperationException, CancelException {
        IRemoteItem item = this.getItem(remoteFilePath);
        item.setReadable(file.canRead());
        item.setWriteable(file.canWrite());
        item.commitAttributes(null);
    }

    public void validateRemotePath(String path) throws RemoteOperationException {
        if (!path.startsWith("/")) {
            throw new RemoteOperationException(String.valueOf(path) + Messages.RemoteFileTools_ValidateRemotePath_NotValid);
        }
    }

    private void cacheUserData() throws RemoteConnectionException, RemoteOperationException, CancelException {
        if (this.cachedGroupIDSet == null) {
            this.cachedGroupIDSet = this.manager.getRemoteStatusTools().getGroupIDSet();
            this.cachedUserID = this.manager.getRemoteStatusTools().getUserID();
        }
    }

    private boolean checkOSName(String name) {
        if (this.fOSName == null) {
            try {
                this.fOSName = this.manager.getExecutionTools().executeWithOutput("uname").trim();
            }
            catch (RemoteExecutionException remoteExecutionException) {
                return false;
            }
            catch (RemoteConnectionException remoteConnectionException) {
                return false;
            }
            catch (CancelException cancelException) {
                return false;
            }
        }
        return this.fOSName.equals(name);
    }

    private ChannelSftp getSFTPChannel() throws RemoteConnectionException {
        return this.manager.connection.getSFTPChannel();
    }

    private void releaseSFTPChannel(ChannelSftp sftp) {
        this.manager.connection.releaseSFTPChannel(sftp);
    }

    protected void executeCommand(String command) throws RemoteConnectionException, RemoteExecutionException, CancelException {
        this.manager.executionTools.executeBashCommand(command);
    }

    protected RemoteFileAttributes fetchRemoteAttr(final String path, IProgressMonitor monitor) throws RemoteOperationException, CancelException, RemoteConnectionException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            this.test();
            this.validateRemotePath(path);
            SftpCallable<SftpATTRS> c = new SftpCallable<SftpATTRS>(){

                @Override
                public SftpATTRS call() throws SftpException {
                    return this.getChannel().stat(path);
                }
            };
            SftpATTRS attrs = (SftpATTRS)c.syncCmdInThread(Messages.FileTools_15, (IProgressMonitor)subMon.newChild(10));
            RemoteFileAttributes remoteFileAttributes = RemoteFileAttributes.getAttributes(attrs);
            return remoteFileAttributes;
        }
        catch (SftpException e) {
            if (e.id == 2) {
                return null;
            }
            throw new RemoteOperationException(e);
        }
        catch (IOException e) {
            throw new RemoteOperationException(e);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected void test() throws RemoteConnectionException, CancelException {
        this.manager.test();
        this.manager.testCancel();
    }

    public static class FileToolsProgressMonitor
    implements SftpProgressMonitor {
        private final IProgressMonitor fMonitor;

        public FileToolsProgressMonitor(IProgressMonitor monitor) {
            this.fMonitor = monitor;
        }

        public boolean count(long count) {
            this.fMonitor.worked((int)count);
            return !this.fMonitor.isCanceled();
        }

        public void end() {
            this.fMonitor.done();
        }

        public void init(int op, String src, String dest, long max) {
            String srcFile;
            String desc = srcFile = new Path(src).lastSegment();
            this.fMonitor.beginTask(desc, (int)max);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class SftpCallable<T>
    implements Callable<T> {
        private ChannelSftp fSftpChannel = null;
        private IProgressMonitor fProgressMonitor = null;

        private SftpCallable() {
        }

        @Override
        public abstract T call() throws SftpException, IOException;

        public ChannelSftp getChannel() {
            return this.fSftpChannel;
        }

        public void setChannel(ChannelSftp channel) {
            this.fSftpChannel = channel;
        }

        public IProgressMonitor getProgressMonitor() {
            return this.fProgressMonitor;
        }

        private Future<T> asyncCmdInThread(String jobName) throws SftpException, IOException, RemoteConnectionException {
            this.getProgressMonitor().subTask(jobName);
            this.setChannel(FileTools.this.getSFTPChannel());
            return fPool.submit(this);
        }

        private void finalizeCmdInThread() {
            FileTools.this.releaseSFTPChannel(this.getChannel());
            this.setChannel(null);
        }

        public T syncCmdInThread(String jobName, IProgressMonitor monitor) throws RemoteConnectionException, SftpException, IOException, RemoteOperationException, CancelException {
            Future<T> future = null;
            this.fProgressMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
            try {
                future = this.asyncCmdInThread(jobName);
                T t = this.waitCmdInThread(future);
                return t;
            }
            finally {
                this.finalizeCmdInThread();
                if (monitor != null) {
                    monitor.done();
                }
            }
        }

        private T waitCmdInThread(Future<T> future) throws IOException, CancelException, SftpException, RemoteOperationException {
            T ret = null;
            boolean bInterrupted = Thread.interrupted();
            while (ret == null) {
                if (this.getProgressMonitor().isCanceled()) {
                    future.cancel(true);
                    this.getChannel().quit();
                    throw new CancelException();
                }
                try {
                    ret = future.get(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    bInterrupted = true;
                }
                catch (TimeoutException timeoutException) {
                }
                catch (ExecutionException e) {
                    this.getChannel().quit();
                    if (e.getCause() instanceof IOException) {
                        throw (IOException)e.getCause();
                    }
                    if (e.getCause() instanceof SftpException) {
                        throw (SftpException)e.getCause();
                    }
                    throw new RemoteOperationException(e);
                }
                this.getProgressMonitor().worked(1);
            }
            if (bInterrupted) {
                Thread.currentThread().interrupt();
            }
            return ret;
        }
    }
}

