/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.pdi.manager;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.pdi.IPDIAddressLocation;
import org.eclipse.ptp.debug.core.pdi.IPDICondition;
import org.eclipse.ptp.debug.core.pdi.IPDIFunctionLocation;
import org.eclipse.ptp.debug.core.pdi.IPDILineLocation;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.PDILocationFactory;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIBreakpointManager;
import org.eclipse.ptp.debug.core.pdi.messages.Messages;
import org.eclipse.ptp.debug.core.pdi.model.IPDIAddressBreakpoint;
import org.eclipse.ptp.debug.core.pdi.model.IPDIBreakpoint;
import org.eclipse.ptp.debug.core.pdi.model.IPDIExceptionpoint;
import org.eclipse.ptp.debug.core.pdi.model.IPDIFunctionBreakpoint;
import org.eclipse.ptp.debug.core.pdi.model.IPDILineBreakpoint;
import org.eclipse.ptp.debug.core.pdi.model.IPDILocationBreakpoint;
import org.eclipse.ptp.debug.core.pdi.model.IPDIWatchpoint;
import org.eclipse.ptp.debug.core.pdi.request.IPDIBreakpointRequest;
import org.eclipse.ptp.debug.internal.core.pdi.manager.AbstractPDIManager;

public class BreakpointManager
extends AbstractPDIManager
implements IPDIBreakpointManager {
    public static IPDIBreakpoint[] EMPTY_BREAKPOINTS = new IPDIBreakpoint[0];
    private static final String[] EXCEPTION_FUNCS = new String[]{"__cxa_throw", "__cxa_begin_catch"};
    private List<IPDIBreakpoint> breakList = Collections.synchronizedList(new ArrayList());
    private IPDIBreakpoint[] exceptionBps = new IPDIBreakpoint[2];
    private final int EXCEPTION_THROW_IDX = 0;
    private final int EXCEPTION_CATCH_IDX = 1;

    public BreakpointManager(IPDISession session) {
        super(session, false);
    }

    public void addSetBreakpoint(TaskSet tasks, IPDIBreakpoint breakpoint) throws PDIException {
        if (!this.isValid(breakpoint.getBreakpointID())) {
            throw new PDIException(tasks, Messages.BreakpointManager_0);
        }
        breakpoint.getTasks().or(tasks);
        breakpoint.getPendingTasks().or(tasks);
        this.setPendingBreakpoint(breakpoint);
    }

    public IPDIAddressLocation createAddressLocation(BigInteger address) {
        return PDILocationFactory.newAddressLocation(address);
    }

    public IPDICondition createCondition(int ignoreCount, String expression, String[] tids) {
        return this.session.getModelFactory().newCondition(ignoreCount, expression, tids);
    }

    public IPDIFunctionLocation createFunctionLocation(String file, String function) {
        return PDILocationFactory.newFunctionLocation(file, function);
    }

    public IPDILineLocation createLineLocation(String file, int line) {
        return PDILocationFactory.newLineLocation(file, line);
    }

    public void deleteAllBreakpoints() throws PDIException {
        IPDIBreakpoint[] pdiBreakpoints;
        IPDIBreakpoint[] iPDIBreakpointArray = pdiBreakpoints = this.getAllPDIBreakpoints();
        int n = pdiBreakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IPDIBreakpoint pdiBpt = iPDIBreakpointArray[n2];
            this.deleteBreakpoint(this.session.getTasks(), pdiBpt);
            ++n2;
        }
    }

    public void deleteAllBreakpoints(TaskSet tasks) throws PDIException {
        IPDIBreakpoint[] pdiBreakpoints;
        IPDIBreakpoint[] iPDIBreakpointArray = pdiBreakpoints = this.getAllPDIBreakpoints();
        int n = pdiBreakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IPDIBreakpoint pdiBpt = iPDIBreakpointArray[n2];
            if (pdiBpt.getTasks().intersects(tasks)) {
                this.deleteBreakpoint(tasks, pdiBpt);
            }
            ++n2;
        }
    }

    public void deleteBreakpoint(TaskSet tasks, IPDIBreakpoint breakpoint) throws PDIException {
        if (!this.isValid(breakpoint.getBreakpointID())) {
            throw new PDIException(tasks, Messages.BreakpointManager_0);
        }
        breakpoint.setDeleted();
        this.deletePendingBreakpoint(breakpoint, true);
    }

    public void deleteSetBreakpoint(TaskSet tasks, IPDIBreakpoint breakpoint) throws PDIException {
        if (!this.isValid(breakpoint.getBreakpointID())) {
            throw new PDIException(tasks, Messages.BreakpointManager_0);
        }
        breakpoint.getTasks().andNot(tasks);
        breakpoint.getPendingTasks().andNot(tasks);
        breakpoint.setDeleted();
        this.deletePendingBreakpoint(breakpoint, false);
    }

    public void disableBreakpoint(TaskSet tasks, IPDIBreakpoint breakpoint) throws PDIException {
        if (!this.isValid(breakpoint.getBreakpointID())) {
            throw new PDIException(tasks, Messages.BreakpointManager_0);
        }
        breakpoint.setEnabled(false);
        this.getSession().getEventRequestManager().addEventRequest(this.session.getRequestFactory().getDisableBreakpointRequest(tasks, breakpoint));
    }

    public void enableBreakpoint(TaskSet tasks, IPDIBreakpoint breakpoint) throws PDIException {
        if (!this.isValid(breakpoint.getBreakpointID())) {
            throw new PDIException(tasks, Messages.BreakpointManager_0);
        }
        breakpoint.setEnabled(true);
        this.getSession().getEventRequestManager().addEventRequest(this.session.getRequestFactory().getEnableBreakpointRequest(tasks, breakpoint));
    }

    public IPDIBreakpoint getBreakpoint(int id) {
        IPDIBreakpoint[] pdiBreakpoints;
        IPDIBreakpoint[] iPDIBreakpointArray = pdiBreakpoints = this.getAllPDIBreakpoints();
        int n = pdiBreakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IPDIBreakpoint pdiBreakpoint = iPDIBreakpointArray[n2];
            if (pdiBreakpoint.getBreakpointID() == id) {
                return pdiBreakpoint;
            }
            ++n2;
        }
        return null;
    }

    public IPDIAddressBreakpoint setAddressBreakpoint(TaskSet tasks, int type, IPDIAddressLocation location, IPDICondition condition, boolean deferred, boolean enabled) throws PDIException {
        IPDIAddressBreakpoint bkpt = this.session.getModelFactory().newAddressBreakpoint(this.session, tasks, type, location, condition, enabled);
        this.setNewLocationBreakpoint(bkpt, deferred);
        return bkpt;
    }

    public void setCondition(TaskSet tasks, IPDIBreakpoint breakpoint, IPDICondition newCondition) throws PDIException {
        this.deleteBreakpoint(tasks, breakpoint);
        breakpoint.setCondition(newCondition);
        if (breakpoint instanceof IPDILocationBreakpoint) {
            this.setLocationBreakpoint((IPDILocationBreakpoint)breakpoint);
        } else if (breakpoint instanceof IPDIWatchpoint) {
            this.setWatchpoint((IPDIWatchpoint)breakpoint);
        } else {
            throw new PDIException(tasks, Messages.BreakpointManager_0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public IPDIExceptionpoint setExceptionpoint(TaskSet tasks, String clazz, boolean stopOnThrow, boolean stopOnCatch, boolean enabled) throws PDIException {
        IPDIFunctionBreakpoint bp;
        IPDIFunctionLocation location;
        int id;
        IPDIBreakpoint[] iPDIBreakpointArray;
        if (!stopOnThrow && !stopOnCatch) {
            throw new PDIException(tasks, Messages.BreakpointManager_1);
        }
        ArrayList<IPDIFunctionBreakpoint> funcBptList = new ArrayList<IPDIFunctionBreakpoint>(2);
        if (stopOnThrow) {
            iPDIBreakpointArray = this.exceptionBps;
            // MONITORENTER : this.exceptionBps
            id = 0;
            if (this.exceptionBps[0] == null) {
                location = PDILocationFactory.newFunctionLocation(null, EXCEPTION_FUNCS[id]);
                bp = this.session.getModelFactory().newFunctionBreakpoint(this.session, tasks, 0, location, null, enabled);
                this.setLocationBreakpoint(bp);
                this.exceptionBps[id] = bp;
                funcBptList.add(bp);
            }
            // MONITOREXIT : iPDIBreakpointArray
        }
        if (stopOnCatch) {
            iPDIBreakpointArray = this.exceptionBps;
            // MONITORENTER : this.exceptionBps
            id = 0;
            if (this.exceptionBps[id] == null) {
                location = PDILocationFactory.newFunctionLocation(null, EXCEPTION_FUNCS[id]);
                bp = this.session.getModelFactory().newFunctionBreakpoint(this.session, tasks, 0, location, null, enabled);
                this.setLocationBreakpoint(bp);
                this.exceptionBps[id] = bp;
                funcBptList.add(bp);
            }
            // MONITOREXIT : iPDIBreakpointArray
        }
        IPDIExceptionpoint excp = this.session.getModelFactory().newExceptionpoint(this.session, tasks, clazz, stopOnThrow, stopOnCatch, null, enabled, funcBptList.toArray(new IPDIFunctionBreakpoint[0]));
        this.addBreakpoint(excp);
        return excp;
    }

    public IPDIFunctionBreakpoint setFunctionBreakpoint(TaskSet tasks, int type, IPDIFunctionLocation location, IPDICondition condition, boolean deferred, boolean enabled) throws PDIException {
        IPDIFunctionBreakpoint bkpt = this.session.getModelFactory().newFunctionBreakpoint(this.session, tasks, type, location, condition, enabled);
        this.setNewLocationBreakpoint(bkpt, deferred);
        return bkpt;
    }

    public IPDILineBreakpoint setLineBreakpoint(TaskSet tasks, int type, IPDILineLocation location, IPDICondition condition, boolean deferred, boolean enabled) throws PDIException {
        IPDILineBreakpoint bkpt = this.session.getModelFactory().newLineBreakpoint(this.session, tasks, type, location, condition, enabled);
        this.setNewLocationBreakpoint(bkpt, deferred);
        return bkpt;
    }

    public IPDIWatchpoint setWatchpoint(TaskSet tasks, int type, int watchType, String expression, IPDICondition condition, boolean enabled) throws PDIException {
        IPDIWatchpoint bkpt = this.session.getModelFactory().newWatchpoint(this.session, tasks, type, expression, watchType, condition, enabled);
        this.setWatchpoint(bkpt);
        this.addBreakpoint(bkpt);
        return bkpt;
    }

    public void shutdown() {
    }

    public void update(TaskSet tasks) throws PDIException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBreakpoint(IPDIBreakpoint breakpoint) {
        List<IPDIBreakpoint> list = this.breakList;
        synchronized (list) {
            if (!breakpoint.isTemporary()) {
                this.breakList.add(breakpoint);
            }
        }
    }

    private void deleteBreakpoint(int id) {
        IPDIBreakpoint[] pdiBreakpoints = this.getAllPDIBreakpoints();
        int i = 0;
        while (i < pdiBreakpoints.length) {
            if (pdiBreakpoints[i].getBreakpointID() == id) {
                this.breakList.remove(i);
                break;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPDIBreakpoint[] getAllPDIBreakpoints() {
        List<IPDIBreakpoint> list = this.breakList;
        synchronized (list) {
            return this.breakList.toArray(new IPDIBreakpoint[0]);
        }
    }

    private boolean isValid(int id) {
        return this.getBreakpoint(id) != null;
    }

    public void updatePendingBreakpoints() throws PDIException {
        IPDIBreakpoint[] iPDIBreakpointArray = this.getAllPDIBreakpoints();
        int n = iPDIBreakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPDIBreakpoint bp = iPDIBreakpointArray[n2];
            if (!bp.getPendingTasks().isEmpty()) {
                if (!bp.isDeleted()) {
                    this.setPendingBreakpoint(bp);
                } else {
                    this.deletePendingBreakpoint(bp, true);
                }
            }
            ++n2;
        }
    }

    public void setPendingBreakpoint(IPDIBreakpoint bp) throws PDIException {
        TaskSet suspendedTasks = bp.getPendingTasks().copy();
        if (this.session.getStatus() == 3) {
            this.getSession().getTaskManager().getSuspendedTasks(suspendedTasks);
        }
        if (!suspendedTasks.isEmpty()) {
            IPDIBreakpointRequest request = null;
            if (bp instanceof IPDIFunctionBreakpoint) {
                request = this.session.getRequestFactory().getSetFunctionBreakpointRequest(suspendedTasks, (IPDIFunctionBreakpoint)bp, true);
            } else if (bp instanceof IPDIAddressBreakpoint) {
                request = this.session.getRequestFactory().getSetAddressBreakpointRequest(suspendedTasks, (IPDIAddressBreakpoint)bp, true);
            } else if (bp instanceof IPDILineBreakpoint) {
                request = this.session.getRequestFactory().getSetLineBreakpointRequest(suspendedTasks, (IPDILineBreakpoint)bp, true);
            } else if (bp instanceof IPDIWatchpoint) {
                request = this.session.getRequestFactory().getSetWatchpointRequest(suspendedTasks, (IPDIWatchpoint)bp, true);
            } else {
                throw new PDIException(bp.getTasks(), Messages.BreakpointManager_2);
            }
            bp.getPendingTasks().andNot(suspendedTasks);
            this.getSession().getEventRequestManager().addEventRequest(request);
        }
    }

    public void deletePendingBreakpoint(IPDIBreakpoint bp, boolean allowUpdate) throws PDIException {
        TaskSet suspendedTasks = bp.getPendingTasks().copy();
        if (this.session.getStatus() == 3) {
            this.getSession().getTaskManager().getSuspendedTasks(suspendedTasks);
        }
        if (!suspendedTasks.isEmpty()) {
            this.getSession().getEventRequestManager().addEventRequest(this.session.getRequestFactory().getDeleteBreakpointRequest(suspendedTasks, bp, allowUpdate));
            bp.getPendingTasks().andNot(suspendedTasks);
            if (bp.getPendingTasks().isEmpty() && allowUpdate) {
                this.deleteBreakpoint(bp.getBreakpointID());
            }
        }
    }

    private void setLocationBreakpoint(IPDILocationBreakpoint bkpt) throws PDIException {
        this.setPendingBreakpoint(bkpt);
        if (!bkpt.isEnabled()) {
            this.disableBreakpoint(bkpt.getTasks(), bkpt);
        }
    }

    private void setWatchpoint(IPDIWatchpoint watchpoint) throws PDIException {
        this.setPendingBreakpoint(watchpoint);
    }

    protected void setNewLocationBreakpoint(IPDILocationBreakpoint bkpt, boolean deferred) throws PDIException {
        this.setLocationBreakpoint(bkpt);
        this.addBreakpoint(bkpt);
    }
}

