/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.upc.analysis;

import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.ptp.pldt.common.ScanReturn;
import org.eclipse.ptp.pldt.common.analysis.PldtAstVisitor;
import org.eclipse.ptp.pldt.upc.messages.Messages;

public class UPCCASTVisitor
extends PldtAstVisitor {
    private static final String PREFIX = "upc_";

    public UPCCASTVisitor(List upcIncludes, String fileName, ScanReturn msr) {
        super(upcIncludes, fileName, msr);
        this.shouldVisitExpressions = true;
        this.shouldVisitStatements = true;
        this.shouldVisitDeclarations = true;
        this.shouldVisitTranslationUnit = true;
        ARTIFACT_CALL = Messages.UPCCASTVisitor_upc_call;
        ARTIFACT_CONSTANT = Messages.UPCCASTVisitor_upc_constant;
    }

    public int visit(IASTExpression expression) {
        if (expression instanceof IASTFunctionCallExpression) {
            IASTExpression astExpr = ((IASTFunctionCallExpression)expression).getFunctionNameExpression();
            String signature = astExpr.getRawSignature();
            if (signature.startsWith(PREFIX) && astExpr instanceof IASTIdExpression) {
                IASTName funcName = ((IASTIdExpression)astExpr).getName();
                this.processFuncName(funcName, astExpr);
            }
        } else if (expression instanceof IASTLiteralExpression) {
            this.processMacroLiteral((IASTLiteralExpression)expression);
        }
        return 3;
    }
}

