/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.launch.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.RemoteVariableManager;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.remote.core.messages.Messages;
import org.eclipse.ptp.remote.internal.core.DebugUtil;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRemoteServerRunner
extends Job {
    private final boolean DEBUG = true;
    private final Map<String, String> fEnv = new HashMap<String, String>();
    private IRemoteConnection fRemoteConnection;
    private Bundle fBundle;
    private final String fServerName;
    private String fLaunchCommand;
    private String fWorkDir = null;
    private ServerState fServerState = ServerState.STARTING;
    private IRemoteProcess fRemoteProcess;

    public AbstractRemoteServerRunner(String name) {
        super(name);
        this.fServerName = name;
        this.setPriority(30);
        this.setSystem(false);
    }

    public Map<String, String> getEnv() {
        return this.fEnv;
    }

    public String getLaunchCommand() {
        return this.fLaunchCommand;
    }

    public String getPayload() {
        return RemoteVariableManager.getInstance().getVariable("payload");
    }

    public IRemoteConnection getRemoteConnection() {
        return this.fRemoteConnection;
    }

    public synchronized ServerState getServerState() {
        return this.fServerState;
    }

    public String getVariable(String name) {
        return RemoteVariableManager.getInstance().getVariable(name);
    }

    public String getWorkingDir() {
        return this.fWorkDir;
    }

    public void setBundleId(String id) {
        this.fBundle = Platform.getBundle((String)id);
    }

    public void setEnv(String env) {
        if (env != null) {
            String[] stringArray = env.split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String vars = stringArray[n2];
                String[] envVar = vars.split("=");
                if (envVar.length == 2) {
                    this.fEnv.put(envVar[0], envVar[1]);
                }
                ++n2;
            }
        }
    }

    public void setLaunchCommand(String command) {
        this.fLaunchCommand = command;
    }

    public void setPayload(String file) {
        RemoteVariableManager.getInstance().setVariable("payload", file);
    }

    public void setRemoteConnection(IRemoteConnection conn) {
        this.fRemoteConnection = conn;
        this.setName(String.valueOf(this.fServerName) + " (" + conn.getName() + ")");
    }

    public void setVariable(String name, String value) {
        RemoteVariableManager.getInstance().setVariable(name, value);
    }

    public void setWorkDir(String workDir) {
        this.fWorkDir = workDir;
    }

    public synchronized void startServer(IProgressMonitor monitor) throws IOException {
        block16: {
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                if (this.fRemoteConnection == null || this.fServerState == ServerState.RUNNING) break block16;
                if (this.fServerState == ServerState.FINISHED) {
                    if (!this.doRestartServer((IProgressMonitor)subMon.newChild(10))) {
                        throw new IOException(Messages.AbstractRemoteServerRunner_6);
                    }
                    this.setServerState(ServerState.STARTING);
                }
                if (!this.fRemoteConnection.isOpen()) {
                    try {
                        this.fRemoteConnection.open((IProgressMonitor)subMon.newChild(10));
                    }
                    catch (RemoteConnectionException e) {
                        throw new IOException(e.getMessage());
                    }
                    if (!this.fRemoteConnection.isOpen()) {
                        throw new IOException(Messages.AbstractRemoteServerRunner_7);
                    }
                }
                subMon.setWorkRemaining(90);
                this.schedule();
                while (!subMon.isCanceled() && this.getServerState() == ServerState.STARTING) {
                    try {
                        ((Object)((Object)this)).wait(100L);
                    }
                    catch (InterruptedException e) {
                        if (!DebugUtil.SERVER_TRACING) continue;
                        System.err.println("SERVER RUNNER: InterruptedException " + e.getLocalizedMessage());
                    }
                }
                if (subMon.isCanceled()) {
                    this.terminateServer();
                }
                if (this.getServerState() != ServerState.RUNNING && !this.getResult().isOK()) {
                    throw new IOException(NLS.bind((String)Messages.AbstractRemoteServerRunner_8, (Object)this.getResult().getMessage()));
                }
                subMon.setWorkRemaining(10);
                if (!this.doStartServer((IProgressMonitor)subMon.newChild(10))) {
                    this.terminateServer();
                    throw new IOException(Messages.AbstractRemoteServerRunner_9);
                }
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
    }

    private IRemoteProcess launchServer(IRemoteConnection conn, IProgressMonitor monitor) throws IOException {
        try {
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            IRemoteFileManager fileManager = conn.getRemoteServices().getFileManager(conn);
            IFileStore directory = fileManager.getResource(this.getWorkingDir());
            directory.mkdir(0, (IProgressMonitor)subMon.newChild(10));
            IFileStore server = directory.getChild(this.getPayload());
            IFileInfo serverInfo = server.fetchInfo(0, (IProgressMonitor)subMon.newChild(10));
            IFileStore local = null;
            URL jarURL = FileLocator.find((Bundle)this.fBundle, (IPath)new Path(this.getPayload()), null);
            if (jarURL != null) {
                jarURL = FileLocator.toFileURL((URL)jarURL);
                local = EFS.getStore((URI)jarURL.toURI());
            }
            if (local == null) {
                return null;
            }
            IFileInfo localInfo = local.fetchInfo(0, (IProgressMonitor)subMon.newChild(10));
            if (!serverInfo.exists() || serverInfo.getLength() != localInfo.getLength()) {
                local.copy(server, 2, (IProgressMonitor)subMon.newChild(70));
            }
            subMon.subTask(Messages.AbstractRemoteServerRunner_5);
            String launchCmd = RemoteVariableManager.getInstance().performStringSubstitution(this.getLaunchCommand());
            List<String> launchArgs = Arrays.asList(launchCmd.split(" "));
            IRemoteProcessBuilder builder = conn.getRemoteServices().getProcessBuilder(conn, launchArgs);
            builder.directory(directory);
            builder.environment().putAll(this.getEnv());
            IRemoteProcess iRemoteProcess = builder.start();
            return iRemoteProcess;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected void canceling() {
        this.terminateServer();
    }

    protected abstract void doFinishServer(IProgressMonitor var1);

    protected abstract boolean doRestartServer(IProgressMonitor var1);

    protected abstract boolean doStartServer(IProgressMonitor var1);

    protected abstract boolean doVerifyServerRunningFromStderr(String var1);

    protected abstract boolean doVerifyServerRunningFromStdout(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected IStatus run(IProgressMonitor monitor) {
        AbstractRemoteServerRunner abstractRemoteServerRunner;
        IStatus iStatus;
        SubMonitor subMon;
        block50: {
            block49: {
                block48: {
                    assert (this.fLaunchCommand != null);
                    assert (this.fRemoteProcess == null);
                    subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    if (!subMon.isCanceled()) break block48;
                    IStatus iStatus2 = Status.CANCEL_STATUS;
                    AbstractRemoteServerRunner abstractRemoteServerRunner2 = this;
                    synchronized (abstractRemoteServerRunner2) {
                        this.fRemoteProcess = null;
                        this.doFinishServer((IProgressMonitor)subMon.newChild(1));
                    }
                    if (monitor != null) {
                        monitor.done();
                    }
                    return iStatus2;
                }
                this.fRemoteProcess = this.launchServer(this.fRemoteConnection, (IProgressMonitor)subMon.newChild(50));
                if (!subMon.isCanceled()) break block49;
                IStatus iStatus3 = Status.CANCEL_STATUS;
                AbstractRemoteServerRunner abstractRemoteServerRunner3 = this;
                synchronized (abstractRemoteServerRunner3) {
                    this.fRemoteProcess = null;
                    this.doFinishServer((IProgressMonitor)subMon.newChild(1));
                }
                if (monitor != null) {
                    monitor.done();
                }
                return iStatus3;
            }
            if (this.fRemoteProcess != null) break block50;
            this.setServerState(ServerState.FINISHED);
            Status status = new Status(4, "org.eclipse.ptp.remote.core", Messages.AbstractRemoteServerRunner_2, null);
            AbstractRemoteServerRunner abstractRemoteServerRunner4 = this;
            synchronized (abstractRemoteServerRunner4) {
                this.fRemoteProcess = null;
                this.doFinishServer((IProgressMonitor)subMon.newChild(1));
            }
            if (monitor != null) {
                monitor.done();
            }
            return status;
        }
        try {
            final BufferedReader stdout = new BufferedReader(new InputStreamReader(this.fRemoteProcess.getInputStream()));
            new Thread(new Runnable(){

                public void run() {
                    try {
                        String output;
                        while ((output = stdout.readLine()) != null) {
                            if (AbstractRemoteServerRunner.this.getServerState() == ServerState.STARTING && AbstractRemoteServerRunner.this.doVerifyServerRunningFromStdout(output)) {
                                AbstractRemoteServerRunner.this.setServerState(ServerState.RUNNING);
                            }
                            if (!DebugUtil.SERVER_TRACING) continue;
                            System.out.println("SERVER: " + output);
                        }
                    }
                    catch (IOException iOException) {}
                }
            }, "dstore server stdout").start();
            final BufferedReader stderr = new BufferedReader(new InputStreamReader(this.fRemoteProcess.getErrorStream()));
            new Thread(new Runnable(){

                public void run() {
                    try {
                        String output;
                        while ((output = stderr.readLine()) != null) {
                            if (AbstractRemoteServerRunner.this.getServerState() == ServerState.STARTING && AbstractRemoteServerRunner.this.doVerifyServerRunningFromStderr(output)) {
                                AbstractRemoteServerRunner.this.setServerState(ServerState.RUNNING);
                            }
                            if (!DebugUtil.SERVER_TRACING) continue;
                            System.err.println("SERVER: " + output);
                        }
                    }
                    catch (IOException iOException) {}
                }
            }, "dstore server stderr").start();
            subMon.worked(50);
            subMon.subTask(Messages.AbstractRemoteServerRunner_1);
            while (!this.fRemoteProcess.isCompleted() && !subMon.isCanceled()) {
                AbstractRemoteServerRunner abstractRemoteServerRunner5 = this;
                synchronized (abstractRemoteServerRunner5) {
                    try {
                        ((Object)((Object)this)).wait(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            try {
                this.fRemoteProcess.waitFor();
            }
            catch (InterruptedException interruptedException) {}
            this.setServerState(ServerState.FINISHED);
            if (this.fRemoteProcess.exitValue() != 0 && !subMon.isCanceled()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.remote.core", NLS.bind((String)Messages.AbstractRemoteServerRunner_3, (Object)this.fRemoteProcess.exitValue())));
            }
            iStatus = subMon.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
            abstractRemoteServerRunner = this;
        }
        catch (CoreException e) {
            this.setServerState(ServerState.FINISHED);
            IStatus iStatus4 = e.getStatus();
            AbstractRemoteServerRunner abstractRemoteServerRunner6 = this;
            synchronized (abstractRemoteServerRunner6) {
                this.fRemoteProcess = null;
                this.doFinishServer((IProgressMonitor)subMon.newChild(1));
            }
            if (monitor != null) {
                monitor.done();
            }
            return iStatus4;
        }
        catch (IOException e2) {
            this.setServerState(ServerState.FINISHED);
            Status status = new Status(4, "org.eclipse.ptp.remote.core", Messages.AbstractRemoteServerRunner_4, (Throwable)e2);
            AbstractRemoteServerRunner abstractRemoteServerRunner7 = this;
            {
                catch (Throwable throwable) {
                    AbstractRemoteServerRunner abstractRemoteServerRunner8 = this;
                    synchronized (abstractRemoteServerRunner8) {
                        this.fRemoteProcess = null;
                        this.doFinishServer((IProgressMonitor)subMon.newChild(1));
                    }
                    if (monitor != null) {
                        monitor.done();
                    }
                    throw throwable;
                }
            }
            synchronized (abstractRemoteServerRunner7) {
                this.fRemoteProcess = null;
                this.doFinishServer((IProgressMonitor)subMon.newChild(1));
            }
            if (monitor != null) {
                monitor.done();
            }
            return status;
        }
        synchronized (abstractRemoteServerRunner) {
            this.fRemoteProcess = null;
            this.doFinishServer((IProgressMonitor)subMon.newChild(1));
        }
        if (monitor != null) {
            monitor.done();
        }
        return iStatus;
    }

    protected synchronized void setServerState(ServerState state) {
        if (this.fServerState != state) {
            if (DebugUtil.SERVER_TRACING) {
                System.out.println("SERVER RUNNER: " + state.toString());
            }
            this.fServerState = state;
            ((Object)((Object)this)).notifyAll();
        }
    }

    protected synchronized void terminateServer() {
        if (this.fServerState == ServerState.RUNNING && this.fRemoteProcess != null) {
            this.fRemoteProcess.destroy();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ServerState {
        STARTING,
        RUNNING,
        FINISHED;

    }
}

