/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.model;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMember;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IVariableDeclaration;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.ptp.internal.rdt.core.model.CElementInfo;
import org.eclipse.ptp.internal.rdt.core.model.FieldInfo;
import org.eclipse.ptp.internal.rdt.core.model.Parent;
import org.eclipse.ptp.internal.rdt.core.model.VariableDeclaration;
import org.eclipse.ptp.rdt.core.RDTLog;

public class Field
extends VariableDeclaration
implements org.eclipse.cdt.core.model.IField {
    private static final long serialVersionUID = 1L;
    protected boolean fIsMutable;
    protected ASTAccessVisibility fVisibility;

    public Field(Parent parent, String variableName) {
        super(parent, 72, variableName);
        this.fIsMutable = true;
    }

    public Field(Parent parent, org.eclipse.cdt.core.model.IField element) throws CModelException {
        super(parent, (IVariableDeclaration)element);
        this.fIsMutable = element.isMutable();
        this.fVisibility = element.getVisibility();
    }

    public Field(Parent parent, IField binding) throws DOMException {
        super(parent, 72, (IVariable)binding);
        if (binding instanceof ICPPMember) {
            ICPPMember member = (ICPPMember)binding;
            try {
                switch (member.getVisibility()) {
                    case 3: {
                        this.fVisibility = ASTAccessVisibility.PRIVATE;
                        break;
                    }
                    case 2: {
                        this.fVisibility = ASTAccessVisibility.PROTECTED;
                        break;
                    }
                    case 1: {
                        this.fVisibility = ASTAccessVisibility.PUBLIC;
                    }
                }
            }
            catch (DOMException e) {
                RDTLog.logError((Throwable)e);
            }
        }
    }

    public boolean isMutable() throws CModelException {
        return this.fIsMutable;
    }

    public ASTAccessVisibility getVisibility() throws CModelException {
        return this.fVisibility;
    }

    public void setMutable(boolean mutable) {
        this.fIsMutable = mutable;
    }

    public CElementInfo getElementInfo() {
        if (this.fInfo == null) {
            this.fInfo = new FieldInfo(this);
        }
        return this.fInfo;
    }

    public void setVisibility(ASTAccessVisibility currentVisibility) {
        this.fVisibility = currentVisibility;
    }
}

