/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMember;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalUnknownScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.LookupData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BaseClassLookup {
    private final ICPPClassType fClassType;
    private IBinding[] fBindings;
    private List<BaseClassLookup> fChildren = Collections.emptyList();
    private BitSet fVirtual;
    private boolean fHiddenAsVirtualBase = false;
    private boolean fPropagationDone = false;
    private boolean fCollected;
    private boolean fCollectedAsRegularBase;

    public static void lookupInBaseClasses(LookupData data, ICPPClassScope classScope, IIndexFileSet fileSet) {
        if (classScope == null) {
            return;
        }
        ICPPClassType classType = classScope.getClassType();
        if (classType == null) {
            return;
        }
        HashMap<IScope, BaseClassLookup> infoMap = new HashMap<IScope, BaseClassLookup>();
        BaseClassLookup rootInfo = BaseClassLookup.lookupInBaseClass(data, null, false, classType, fileSet, infoMap, 0);
        if (data.contentAssist) {
            rootInfo.collectResultForContentAssist(data);
        } else {
            BaseClassLookup.hideVirtualBases(rootInfo, infoMap);
            IBinding[] result = rootInfo.collectResult(data, true, null);
            BaseClassLookup.verifyResult(data, result);
        }
    }

    private BaseClassLookup(ICPPClassType type) {
        this.fClassType = type;
    }

    ICPPClassType getClassType() {
        return this.fClassType;
    }

    IBinding[] getResult() {
        return this.fBindings;
    }

    boolean containsVirtualBase() {
        return this.fVirtual != null && this.fVirtual.nextSetBit(0) >= 0;
    }

    boolean hasMatches() {
        return this.fBindings != null && this.fBindings.length > 0 && this.fBindings[0] != null;
    }

    public void addBase(boolean virtual, BaseClassLookup baseInfo) {
        if (virtual && this.fHiddenAsVirtualBase) {
            return;
        }
        if (this.fChildren.isEmpty()) {
            this.fChildren = new ArrayList<BaseClassLookup>();
            this.fVirtual = new BitSet();
        }
        this.fVirtual.set(this.fChildren.size(), virtual);
        this.fChildren.add(baseInfo);
    }

    public void setResult(IBinding[] bindings) {
        this.fBindings = bindings;
    }

    public void setHiddenAsVirtualBase() {
        this.fHiddenAsVirtualBase = true;
    }

    public void propagateHiddenAsVirtual() {
        if (this.fPropagationDone) {
            return;
        }
        this.fPropagationDone = true;
        int i = 0;
        while (i < this.fChildren.size()) {
            BaseClassLookup child = this.fChildren.get(i);
            if (this.fVirtual.get(i)) {
                child.setHiddenAsVirtualBase();
            }
            child.propagateHiddenAsVirtual();
            ++i;
        }
    }

    public boolean containsNonStaticMember() {
        IBinding[] iBindingArray = this.fBindings;
        int n = this.fBindings.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding binding = iBindingArray[n2];
            if (binding == null) {
                return false;
            }
            if (binding instanceof ICPPMember) {
                try {
                    if (!((ICPPMember)binding).isStatic()) {
                        return true;
                    }
                }
                catch (DOMException dOMException) {}
            }
            ++n2;
        }
        return false;
    }

    static BaseClassLookup lookupInBaseClass(LookupData data, ICPPClassScope baseClassScope, boolean isVirtual, ICPPClassType root, IIndexFileSet fileSet, HashMap<IScope, BaseClassLookup> infoMap, int depth) {
        BaseClassLookup result;
        IBinding[] matches;
        block28: {
            BaseClassLookup info;
            if (depth++ > 16) {
                return null;
            }
            if (baseClassScope != null && (info = infoMap.get(baseClassScope)) != null) {
                if (info.getResult() == null) {
                    data.problem = new ProblemBinding(null, 6, root.getNameCharArray());
                    return null;
                }
                return info;
            }
            matches = IBinding.EMPTY_BINDING_ARRAY;
            if (baseClassScope == null) {
                result = new BaseClassLookup(root);
                try {
                    infoMap.put(root.getCompositeScope(), result);
                }
                catch (DOMException dOMException) {}
            } else {
                result = new BaseClassLookup(baseClassScope.getClassType());
                infoMap.put(baseClassScope, result);
                try {
                    IBinding[] members = CPPSemantics.getBindingsFromScope(baseClassScope, fileSet, data);
                    if (data.typesOnly) {
                        CPPSemantics.removeObjects(members);
                    }
                    if (members == null || members.length <= 0 || members[0] == null) break block28;
                    if (data.prefixLookup) {
                        matches = members;
                        break block28;
                    }
                    result.setResult(members);
                    return result;
                }
                catch (DOMException dOMException) {}
            }
        }
        ICPPClassType baseClass = result.getClassType();
        if (baseClass != null) {
            ICPPBase[] grandBases = null;
            try {
                grandBases = baseClass.getBases();
            }
            catch (DOMException dOMException) {}
            if (grandBases != null && grandBases.length > 0) {
                HashSet<ICPPClassType> grandBaseBindings = null;
                BitSet selectedBases = null;
                if (grandBases.length > 1) {
                    grandBaseBindings = new HashSet<ICPPClassType>();
                    selectedBases = BaseClassLookup.selectPreferredBases(data, grandBases);
                }
                int i = 0;
                while (i < grandBases.length) {
                    ICPPBase grandBase = grandBases[i];
                    if (!(grandBase instanceof IProblemBinding) && (selectedBases == null || selectedBases.get(i))) {
                        try {
                            IBinding grandBaseBinding = grandBase.getBaseClass();
                            if (!(grandBaseBinding instanceof ICPPClassType)) {
                                if (grandBaseBinding instanceof ICPPUnknownBinding && data.skippedScope == null) {
                                    data.skippedScope = root;
                                }
                            } else {
                                ICPPClassType grandBaseClass = (ICPPClassType)grandBaseBinding;
                                if (grandBaseBindings == null || grandBaseBindings.add(grandBaseClass)) {
                                    BaseClassLookup baseInfo;
                                    IScope grandBaseScope = grandBaseClass.getCompositeScope();
                                    if (grandBaseScope == null || grandBaseScope instanceof ICPPInternalUnknownScope) {
                                        if (data.skippedScope == null) {
                                            data.skippedScope = root;
                                        }
                                    } else if (grandBaseScope instanceof ICPPClassScope && (baseInfo = BaseClassLookup.lookupInBaseClass(data, (ICPPClassScope)grandBaseScope, grandBase.isVirtual(), root, fileSet, infoMap, depth)) != null) {
                                        result.addBase(grandBase.isVirtual(), baseInfo);
                                    }
                                }
                            }
                        }
                        catch (DOMException dOMException) {}
                    }
                    ++i;
                }
            }
        }
        result.setResult(matches);
        return result;
    }

    private static BitSet selectPreferredBases(LookupData data, ICPPBase[] grandBases) {
        if (data.contentAssist) {
            return null;
        }
        BitSet selectedBases = new BitSet(grandBases.length);
        IName baseName = null;
        int i = 0;
        while (i < grandBases.length) {
            ICPPBase nbase = grandBases[i];
            if (!(nbase instanceof IProblemBinding)) {
                int cmp;
                IName nbaseName = nbase.getBaseClassSpecifierName();
                int n = cmp = baseName == null ? -1 : CPPSemantics.compareByRelevance(data, baseName, nbaseName);
                if (cmp <= 0) {
                    if (cmp < 0) {
                        selectedBases.clear();
                        baseName = nbaseName;
                    }
                    selectedBases.set(i);
                }
            }
            ++i;
        }
        return selectedBases;
    }

    static void hideVirtualBases(BaseClassLookup rootInfo, HashMap<IScope, BaseClassLookup> infoMap) {
        BaseClassLookup info;
        BaseClassLookup[] allInfos;
        boolean containsVirtualBase = false;
        BaseClassLookup[] baseClassLookupArray = allInfos = infoMap.values().toArray(new BaseClassLookup[infoMap.size()]);
        int n = allInfos.length;
        int n2 = 0;
        while (n2 < n) {
            info = baseClassLookupArray[n2];
            if (info.containsVirtualBase()) {
                containsVirtualBase = true;
                break;
            }
            ++n2;
        }
        if (containsVirtualBase) {
            baseClassLookupArray = allInfos;
            n = allInfos.length;
            n2 = 0;
            while (n2 < n) {
                info = baseClassLookupArray[n2];
                if (info.hasMatches()) {
                    info.hideVirtualBases(infoMap, 0);
                }
                ++n2;
            }
        }
    }

    void hideVirtualBases(HashMap<IScope, BaseClassLookup> infoMap, int depth) {
        if (depth++ > 16) {
            return;
        }
        if (this.fClassType != null) {
            ICPPBase[] bases = null;
            try {
                bases = this.fClassType.getBases();
            }
            catch (DOMException dOMException) {}
            if (bases != null && bases.length > 0) {
                ICPPBase[] iCPPBaseArray = bases;
                int n = bases.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPBase base = iCPPBaseArray[n2];
                    if (!(base instanceof IProblemBinding)) {
                        try {
                            ICPPClassType baseClass;
                            IScope baseScope;
                            IBinding baseBinding = base.getBaseClass();
                            if (baseBinding instanceof ICPPClassType && (baseScope = (baseClass = (ICPPClassType)baseBinding).getCompositeScope()) instanceof ICPPClassScope) {
                                BaseClassLookup baseInfo = infoMap.get(baseScope);
                                if (baseInfo != null) {
                                    if (base.isVirtual()) {
                                        baseInfo.setHiddenAsVirtualBase();
                                    }
                                    baseInfo.propagateHiddenAsVirtual();
                                } else {
                                    baseInfo = new BaseClassLookup(baseClass);
                                    infoMap.put(baseScope, baseInfo);
                                    baseInfo.hideVirtualBases(infoMap, depth);
                                }
                            }
                        }
                        catch (DOMException dOMException) {}
                    }
                    ++n2;
                }
            }
        }
    }

    public void collectResultForContentAssist(LookupData data) {
        if (this.fCollected) {
            return;
        }
        this.fCollected = true;
        data.foundItems = CPPSemantics.mergePrefixResults((CharArrayObjectMap)data.foundItems, this.fBindings, true);
        int i = 0;
        while (i < this.fChildren.size()) {
            BaseClassLookup child = this.fChildren.get(i);
            child.collectResultForContentAssist(data);
            ++i;
        }
    }

    public IBinding[] collectResult(LookupData data, boolean asVirtualBase, IBinding[] result) {
        if (asVirtualBase) {
            if (this.fHiddenAsVirtualBase) {
                return result;
            }
        } else {
            if (this.fCollectedAsRegularBase && data.problem == null && this.containsNonStaticMember()) {
                data.problem = new ProblemBinding(data.astName, 4);
            }
            this.fCollectedAsRegularBase = true;
        }
        if (this.fCollected) {
            return result;
        }
        this.fCollected = true;
        result = (IBinding[])ArrayUtil.addAll(IBinding.class, result, this.fBindings);
        int i = 0;
        while (i < this.fChildren.size()) {
            BaseClassLookup child = this.fChildren.get(i);
            result = child.collectResult(data, this.fVirtual.get(i), result);
            ++i;
        }
        return result;
    }

    static void verifyResult(LookupData data, IBinding[] bindings) {
        if ((bindings = (IBinding[])ArrayUtil.trim(IBinding.class, bindings)).length == 0) {
            return;
        }
        if (data.problem != null) {
            data.problem.setCandidateBindings(bindings);
        } else {
            ICPPClassType uniqueOwner = null;
            IBinding[] iBindingArray = bindings;
            int n = bindings.length;
            int n2 = 0;
            while (n2 < n) {
                IBinding b = iBindingArray[n2];
                if (!(b instanceof IType)) {
                    try {
                        IBinding owner = b.getOwner();
                        if (owner instanceof ICPPClassType) {
                            ICPPClassType classOwner = (ICPPClassType)owner;
                            if (uniqueOwner == null) {
                                uniqueOwner = classOwner;
                            } else if (!uniqueOwner.isSameType(classOwner)) {
                                data.problem = new ProblemBinding(data.astName, 4, bindings);
                                return;
                            }
                        }
                    }
                    catch (DOMException dOMException) {}
                }
                ++n2;
            }
        }
        data.foundItems = ArrayUtil.addAll(Object.class, (Object[])data.foundItems, bindings);
    }
}

