/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.ast;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedList;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.ICArrayType;
import org.eclipse.cdt.core.dom.ast.c.ICPointerType;
import org.eclipse.cdt.core.dom.ast.c.ICQualifierType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBasicType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameterPackType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.IGPPPointerType;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.IGPPQualifierType;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTTypeId;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.cdt.internal.core.dom.parser.c.ICInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTypeId;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class ASTTypeUtil {
    private static final String COMMA_SPACE = ", ";
    private static final String EMPTY_STRING = "";
    private static final String SPACE = " ";
    private static final int DEAULT_ITYPE_SIZE = 2;

    public static String getParameterTypeString(IFunctionType type) {
        StringBuilder result = new StringBuilder();
        String[] parms = ASTTypeUtil.getParameterTypeStringArray(type);
        result.append(Keywords.cpLPAREN);
        boolean needComma = false;
        String[] stringArray = parms;
        int n = parms.length;
        int n2 = 0;
        while (n2 < n) {
            String parm = stringArray[n2];
            if (parm != null) {
                if (needComma) {
                    result.append(COMMA_SPACE);
                }
                result.append(parm);
                needComma = true;
            }
            ++n2;
        }
        if (type instanceof ICPPFunctionType && ((ICPPFunctionType)type).takesVarArgs()) {
            if (needComma) {
                result.append(COMMA_SPACE);
            }
            result.append(Keywords.cpELLIPSIS);
        }
        result.append(Keywords.cpRPAREN);
        return result.toString();
    }

    public static boolean functionTakesParameters(IFunction function) throws DOMException {
        IParameter[] parameters = function.getParameters();
        if (parameters.length == 0) {
            return false;
        }
        return parameters.length != 1 || !SemanticUtil.isVoidType(parameters[0].getType());
    }

    public static String getTypeListString(IType[] types) {
        return ASTTypeUtil.getTypeListString(types, true);
    }

    public static String getTypeListString(IType[] types, boolean normalize) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < types.length) {
            if (types[i] != null) {
                result.append(ASTTypeUtil.getType(types[i], normalize));
                if (i < types.length - 1) {
                    result.append(COMMA_SPACE);
                }
            }
            ++i;
        }
        return result.toString();
    }

    public static String getArgumentListString(ICPPTemplateArgument[] args, boolean normalize) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        result.append('<');
        ICPPTemplateArgument[] iCPPTemplateArgumentArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPTemplateArgument arg = iCPPTemplateArgumentArray[n2];
            if (!first) {
                result.append(',');
            }
            first = false;
            result.append(ASTTypeUtil.getArgumentString(arg, normalize));
            ++n2;
        }
        result.append('>');
        return result.toString();
    }

    public static String getArgumentString(ICPPTemplateArgument arg, boolean normalize) {
        IValue val = arg.getNonTypeValue();
        if (val != null) {
            return new String(val.getSignature());
        }
        return ASTTypeUtil.getType(arg.getTypeValue(), normalize);
    }

    public static String[] getParameterTypeStringArray(IFunctionType type) {
        IType[] parms = type.getParameterTypes();
        String[] result = new String[parms.length];
        int i = 0;
        while (i < parms.length) {
            if (parms[i] != null) {
                result[i] = ASTTypeUtil.getType(parms[i]);
            }
            ++i;
        }
        return result;
    }

    private static String getTypeString(IType type, boolean normalize) {
        StringBuilder result = new StringBuilder();
        boolean needSpace = false;
        if (type instanceof IArrayType) {
            IValue val;
            result.append(Keywords.cpLBRACKET);
            if (type instanceof ICArrayType) {
                ICArrayType catype = (ICArrayType)type;
                if (catype.isConst()) {
                    result.append("const");
                    needSpace = true;
                }
                if (catype.isRestrict()) {
                    if (needSpace) {
                        result.append(SPACE);
                        needSpace = false;
                    }
                    result.append("restrict");
                    needSpace = true;
                }
                if (catype.isStatic()) {
                    if (needSpace) {
                        result.append(SPACE);
                        needSpace = false;
                    }
                    result.append("static");
                    needSpace = true;
                }
                if (catype.isVolatile()) {
                    if (needSpace) {
                        result.append(SPACE);
                        needSpace = false;
                    }
                    result.append("volatile");
                }
            }
            if ((val = ((IArrayType)type).getSize()) != null && val != Value.UNKNOWN) {
                if (normalize) {
                    if (needSpace) {
                        result.append(SPACE);
                        needSpace = false;
                    }
                    result.append(val.getSignature());
                } else {
                    Long v = val.numericalValue();
                    if (v != null) {
                        if (needSpace) {
                            result.append(SPACE);
                            needSpace = false;
                        }
                        result.append(v);
                    }
                }
            }
            result.append(Keywords.cpRBRACKET);
        } else if (type instanceof IBasicType) {
            IBasicType basicType = (IBasicType)type;
            if (basicType.getModifiers() == CPPBasicType.UNIQUE_TYPE_QUALIFIER) {
                return "@" + String.valueOf(basicType.hashCode());
            }
            IBasicType.Kind kind = basicType.getKind();
            if (basicType.isSigned()) {
                if (!normalize || kind == IBasicType.Kind.eChar) {
                    result.append("signed");
                    needSpace = true;
                }
            } else if (basicType.isUnsigned()) {
                if (needSpace) {
                    result.append(SPACE);
                    needSpace = false;
                }
                result.append("unsigned");
                needSpace = true;
            }
            if (basicType.isLong()) {
                if (needSpace) {
                    result.append(SPACE);
                    needSpace = false;
                }
                result.append("long");
                needSpace = true;
            } else if (basicType.isShort()) {
                if (needSpace) {
                    result.append(SPACE);
                    needSpace = false;
                }
                result.append("short");
                needSpace = true;
            } else if (basicType.isLongLong()) {
                if (needSpace) {
                    result.append(SPACE);
                    needSpace = false;
                }
                result.append("long long");
                needSpace = true;
            }
            if (basicType.isComplex()) {
                if (needSpace) {
                    result.append(SPACE);
                    needSpace = false;
                }
                result.append(Keywords.c_COMPLEX);
                needSpace = true;
            }
            if (basicType.isImaginary()) {
                if (needSpace) {
                    result.append(SPACE);
                    needSpace = false;
                }
                result.append(Keywords.c_IMAGINARY);
                needSpace = true;
            }
            switch (kind) {
                case eChar: {
                    if (needSpace) {
                        result.append(SPACE);
                    }
                    result.append("char");
                    break;
                }
                case eDouble: {
                    if (needSpace) {
                        result.append(SPACE);
                    }
                    result.append("double");
                    break;
                }
                case eFloat: {
                    if (needSpace) {
                        result.append(SPACE);
                    }
                    result.append("float");
                    break;
                }
                case eInt: {
                    if (needSpace) {
                        result.append(SPACE);
                    }
                    result.append("int");
                    break;
                }
                case eVoid: {
                    if (needSpace) {
                        result.append(SPACE);
                    }
                    result.append("void");
                    break;
                }
                case eBoolean: {
                    if (needSpace) {
                        result.append(SPACE);
                    }
                    if (basicType instanceof ICPPBasicType) {
                        result.append("bool");
                        break;
                    }
                    result.append(Keywords.c_BOOL);
                    break;
                }
                case eWChar: {
                    if (needSpace) {
                        result.append(SPACE);
                    }
                    result.append("wchar_t");
                    break;
                }
                case eChar16: {
                    if (needSpace) {
                        result.append(SPACE);
                    }
                    result.append("char16_t");
                    break;
                }
                case eChar32: {
                    if (needSpace) {
                        result.append(SPACE);
                    }
                    result.append("char32_t");
                    break;
                }
            }
        } else if (type instanceof ICPPTemplateParameter) {
            ICPPTemplateParameter tpar = (ICPPTemplateParameter)((Object)type);
            if (normalize) {
                result.append('#');
                result.append(Integer.toString(tpar.getParameterID(), 16));
            } else {
                result.append(tpar.getName());
            }
        } else if (type instanceof ICompositeType) {
            if (type instanceof ICPPClassType) {
                try {
                    String qn = CPPVisitor.renderQualifiedName(ASTTypeUtil.getQualifiedNameForAnonymous((ICPPClassType)type, normalize));
                    result.append(qn);
                }
                catch (DOMException dOMException) {
                    result.append(ASTTypeUtil.getNameForAnonymous((ICompositeType)type));
                }
            } else {
                result.append(ASTTypeUtil.getNameForAnonymous((ICompositeType)type));
            }
            if (type instanceof ICPPTemplateInstance) {
                ICPPTemplateInstance inst = (ICPPTemplateInstance)((Object)type);
                result.append(ASTTypeUtil.getArgumentListString(inst.getTemplateArguments(), normalize));
            }
        } else if (type instanceof ICPPReferenceType) {
            if (((ICPPReferenceType)type).isRValueReference()) {
                result.append(Keywords.cpAND);
            } else {
                result.append(Keywords.cpAMPER);
            }
        } else if (type instanceof ICPPParameterPackType) {
            result.append(Keywords.cpELLIPSIS);
        } else if (type instanceof IEnumeration) {
            result.append("enum");
            result.append(SPACE);
            result.append(ASTTypeUtil.getNameForAnonymous((IEnumeration)type));
        } else if (type instanceof IFunctionType) {
            String temp = ASTTypeUtil.getParameterTypeString((IFunctionType)type);
            if (temp != null && !temp.equals(EMPTY_STRING)) {
                result.append(temp);
                needSpace = false;
            }
            if (type instanceof ICPPFunctionType) {
                ICPPFunctionType ft = (ICPPFunctionType)type;
                needSpace = ASTTypeUtil.appendCVQ(result, needSpace, ft.isConst(), ft.isVolatile());
            }
        } else if (type instanceof IPointerType) {
            if (type instanceof ICPPPointerToMemberType) {
                result.append(ASTTypeUtil.getTypeString(((ICPPPointerToMemberType)type).getMemberOfClass(), normalize));
                result.append(Keywords.cpCOLONCOLON);
            }
            result.append(Keywords.cpSTAR);
            needSpace = true;
            if (type instanceof IGPPPointerType) {
                if (((IGPPPointerType)type).isRestrict()) {
                    if (needSpace) {
                        result.append(SPACE);
                        needSpace = false;
                    }
                    result.append("restrict");
                    needSpace = true;
                }
            } else if (type instanceof ICPointerType && ((ICPointerType)type).isRestrict()) {
                if (needSpace) {
                    result.append(SPACE);
                    needSpace = false;
                }
                result.append("restrict");
                needSpace = true;
            }
            IPointerType pt = (IPointerType)type;
            needSpace = ASTTypeUtil.appendCVQ(result, needSpace, pt.isConst(), pt.isVolatile());
        } else if (type instanceof IQualifierType) {
            if (type instanceof ICQualifierType) {
                if (((ICQualifierType)type).isRestrict()) {
                    result.append("restrict");
                    needSpace = true;
                }
            } else if (type instanceof IGPPQualifierType && ((IGPPQualifierType)type).isRestrict()) {
                result.append("restrict");
                needSpace = true;
            }
            IQualifierType qt = (IQualifierType)type;
            needSpace = ASTTypeUtil.appendCVQ(result, needSpace, qt.isConst(), qt.isVolatile());
        } else if (type instanceof ITypedef) {
            result.append(((ITypedef)type).getNameCharArray());
        }
        return result.toString();
    }

    private static boolean appendCVQ(StringBuilder target, boolean needSpace, boolean isConst, boolean isVolatile) {
        if (isConst) {
            if (needSpace) {
                target.append(SPACE);
                needSpace = false;
            }
            target.append("const");
            needSpace = true;
        }
        if (isVolatile) {
            if (needSpace) {
                target.append(SPACE);
                needSpace = false;
            }
            target.append("volatile");
            needSpace = true;
        }
        return needSpace;
    }

    public static String getType(IType type) {
        return ASTTypeUtil.getType(type, true);
    }

    public static String getType(IType type, boolean normalize) {
        Object tj;
        StringBuilder result = new StringBuilder();
        Object[] types = new IType[2];
        int i = 0;
        IQualifierType cvq = null;
        ICPPReferenceType ref = null;
        while (type != null && ++i < 100) {
            if (type instanceof ITypedef) {
                if (!normalize && !(type instanceof ICPPSpecialization)) {
                    types = (IType[])ArrayUtil.append(IType.class, types, type);
                    type = null;
                }
            } else if (type instanceof ICPPReferenceType) {
                cvq = null;
                if (ref == null || ref.isRValueReference()) {
                    ref = (ICPPReferenceType)type;
                }
            } else {
                if (cvq != null && (type instanceof IQualifierType || type instanceof IPointerType)) {
                    type = SemanticUtil.addQualifiers(type, cvq.isConst(), cvq.isVolatile());
                    cvq = null;
                }
                if (type instanceof IQualifierType) {
                    cvq = (IQualifierType)type;
                } else {
                    if (ref != null) {
                        types = (IType[])ArrayUtil.append(IType.class, types, ref);
                        ref = null;
                    }
                    if (cvq != null) {
                        types = (IType[])ArrayUtil.append(IType.class, types, cvq);
                        cvq = null;
                    }
                    types = (IType[])ArrayUtil.append(IType.class, types, type);
                }
            }
            type = type instanceof ITypeContainer ? ((ITypeContainer)type).getType() : (type instanceof IFunctionType ? ((IFunctionType)type).getReturnType() : null);
        }
        ArrayList<Object> postfix = null;
        BitSet parenthesis = null;
        boolean needParenthesis = false;
        int j = types.length - 1;
        while (j >= 0) {
            tj = types[j];
            if (tj != null) {
                if (j > 0 && types[j - 1] instanceof IQualifierType) {
                    if (result.length() > 0) {
                        result.append(SPACE);
                    }
                    result.append(ASTTypeUtil.getTypeString((IType)types[j - 1], normalize));
                    result.append(SPACE);
                    result.append(ASTTypeUtil.getTypeString((IType)tj, normalize));
                    --j;
                } else if (tj instanceof IFunctionType || tj instanceof IArrayType) {
                    if (j == 0) {
                        if (result.length() > 0) {
                            result.append(SPACE);
                        }
                        result.append(ASTTypeUtil.getTypeString((IType)tj, normalize));
                    } else {
                        if (postfix == null) {
                            postfix = new ArrayList<Object>();
                        }
                        postfix.add(tj);
                        needParenthesis = true;
                    }
                } else {
                    if (result.length() > 0) {
                        result.append(SPACE);
                    }
                    if (needParenthesis && postfix != null) {
                        result.append('(');
                        if (parenthesis == null) {
                            parenthesis = new BitSet();
                        }
                        parenthesis.set(postfix.size() - 1);
                    }
                    result.append(ASTTypeUtil.getTypeString((IType)tj, normalize));
                    needParenthesis = false;
                }
            }
            --j;
        }
        if (postfix != null) {
            j = postfix.size() - 1;
            while (j >= 0) {
                if (parenthesis != null && parenthesis.get(j)) {
                    result.append(')');
                }
                tj = (IType)postfix.get(j);
                result.append(ASTTypeUtil.getTypeString((IType)tj, normalize));
                --j;
            }
        }
        return result.toString();
    }

    public static String getType(IASTDeclarator decltor) {
        while (decltor.getNestedDeclarator() != null) {
            decltor = decltor.getNestedDeclarator();
        }
        IBinding binding = decltor.getName().resolveBinding();
        IType type = null;
        try {
            if (binding instanceof IEnumerator) {
                type = ((IEnumerator)binding).getType();
            } else if (binding instanceof IFunction) {
                type = ((IFunction)binding).getType();
            } else if (binding instanceof ITypedef) {
                type = ((ITypedef)binding).getType();
            } else if (binding instanceof IVariable) {
                type = ((IVariable)binding).getType();
            }
        }
        catch (DOMException dOMException) {
            return EMPTY_STRING;
        }
        if (type != null) {
            return ASTTypeUtil.getType(type);
        }
        return EMPTY_STRING;
    }

    public static String getNodeType(IASTNode node) {
        try {
            if (node instanceof IASTDeclarator) {
                return ASTTypeUtil.getType((IASTDeclarator)node);
            }
            if (node instanceof IASTName && ((IASTName)node).resolveBinding() instanceof IVariable) {
                return ASTTypeUtil.getType(((IVariable)((IASTName)node).resolveBinding()).getType());
            }
            if (node instanceof IASTName && ((IASTName)node).resolveBinding() instanceof IFunction) {
                return ASTTypeUtil.getType(((IFunction)((IASTName)node).resolveBinding()).getType());
            }
            if (node instanceof IASTName && ((IASTName)node).resolveBinding() instanceof IType) {
                return ASTTypeUtil.getType((IType)((Object)((IASTName)node).resolveBinding()));
            }
            if (node instanceof IASTTypeId) {
                return ASTTypeUtil.getType((IASTTypeId)node);
            }
        }
        catch (DOMException dOMException) {
            return EMPTY_STRING;
        }
        return EMPTY_STRING;
    }

    public static String getType(IASTTypeId typeId) {
        if (typeId instanceof CASTTypeId) {
            return ASTTypeUtil.createCType(typeId.getAbstractDeclarator());
        }
        if (typeId instanceof CPPASTTypeId) {
            return ASTTypeUtil.createCPPType(typeId.getAbstractDeclarator());
        }
        return EMPTY_STRING;
    }

    private static String createCType(IASTDeclarator declarator) {
        IType type = CVisitor.createType(declarator);
        return ASTTypeUtil.getType(type);
    }

    private static String createCPPType(IASTDeclarator declarator) {
        IType type = CPPVisitor.createType(declarator);
        return ASTTypeUtil.getType(type);
    }

    @Deprecated
    public static boolean isConst(IType type) {
        if (type instanceof IQualifierType) {
            return ((IQualifierType)type).isConst();
        }
        if (type instanceof ITypeContainer) {
            return ASTTypeUtil.isConst(((ITypeContainer)type).getType());
        }
        if (type instanceof IArrayType) {
            return ASTTypeUtil.isConst(((IArrayType)type).getType());
        }
        if (type instanceof ICPPReferenceType) {
            return ASTTypeUtil.isConst(((ICPPReferenceType)type).getType());
        }
        if (type instanceof IFunctionType) {
            return ASTTypeUtil.isConst(((IFunctionType)type).getReturnType());
        }
        if (type instanceof IPointerType) {
            return ASTTypeUtil.isConst(((IPointerType)type).getType());
        }
        if (type instanceof ITypedef) {
            return ASTTypeUtil.isConst(((ITypedef)type).getType());
        }
        return false;
    }

    private static String[] getQualifiedNameForAnonymous(ICPPBinding binding, boolean normalize) throws DOMException {
        ICPPDeferredClassInstance deferredInst;
        LinkedList<String> result = new LinkedList<String>();
        result.addFirst(ASTTypeUtil.getNameForAnonymous(binding));
        IBinding owner = binding;
        while (!(owner instanceof ICPPTemplateParameter || owner instanceof ICPPDeferredClassInstance && (deferredInst = (ICPPDeferredClassInstance)owner).getTemplateDefinition() instanceof ICPPTemplateParameter || !((owner = owner.getOwner()) instanceof ICPPNamespace) && !(owner instanceof IType))) {
            char[] name = owner.getNameCharArray();
            if (name == null || name.length == 0) {
                char[] altname;
                if (owner instanceof ICPPNamespace || (altname = ASTTypeUtil.createNameForAnonymous(owner)) == null) continue;
                result.addFirst(new String(altname));
                continue;
            }
            if (normalize && owner instanceof IType) {
                result.addFirst(ASTTypeUtil.getType((IType)((Object)owner), normalize));
                continue;
            }
            result.addFirst(new String(name));
        }
        return result.toArray(new String[result.size()]);
    }

    private static String getNameForAnonymous(IBinding binding) {
        char[] altname;
        char[] name = binding.getNameCharArray();
        if ((name == null || name.length == 0) && (altname = ASTTypeUtil.createNameForAnonymous(binding)) != null) {
            return new String(altname);
        }
        return new String(name);
    }

    public static char[] createNameForAnonymous(IBinding binding) {
        IASTNode node = null;
        if (binding instanceof ICInternalBinding) {
            node = ((ICInternalBinding)((Object)binding)).getPhysicalNode();
        } else if (binding instanceof ICPPInternalBinding) {
            node = ((ICPPInternalBinding)binding).getDefinition();
        }
        if (node != null) {
            IASTFileLocation loc = node.getFileLocation();
            if (loc == null && (node = node.getParent()) != null) {
                loc = node.getFileLocation();
            }
            if (loc != null) {
                char[] fname = loc.getFileName().toCharArray();
                int fnamestart = ASTTypeUtil.findFileNameStart(fname);
                StringBuilder buf = new StringBuilder();
                buf.append('{');
                buf.append(fname, fnamestart, fname.length - fnamestart);
                buf.append(':');
                buf.append(loc.getNodeOffset());
                buf.append('}');
                return buf.toString().toCharArray();
            }
        }
        return null;
    }

    private static int findFileNameStart(char[] fname) {
        int i = fname.length - 2;
        while (i >= 0) {
            switch (fname[i]) {
                case '/': 
                case '\\': {
                    return i + 1;
                }
            }
            --i;
        }
        return 0;
    }
}

